/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.impl.acknowledgements;

import java.sql.SQLException;
import org.sakaiproject.pasystem.api.AcknowledgementType;
import org.sakaiproject.pasystem.impl.common.DB;
import org.sakaiproject.pasystem.impl.common.DBAction;
import org.sakaiproject.pasystem.impl.common.DBConnection;

public class AcknowledgementStorage {
    private final String tableName;

    public AcknowledgementStorage(NotificationType type) {
        this.tableName = ("PASYSTEM_" + (Object)((Object)type) + "_dismissed").toLowerCase();
    }

    public void acknowledge(final String uuid, final String userEid, final AcknowledgementType acknowledgementType) {
        DB.transaction("Acknowledge a notification on behalf of a user", new DBAction<Void>(){

            @Override
            public Void call(DBConnection db) throws SQLException {
                db.run("DELETE FROM " + AcknowledgementStorage.this.tableName + " where uuid = ? AND user_eid = ?").param(uuid).param(userEid.toLowerCase()).executeUpdate();
                db.run("INSERT INTO " + AcknowledgementStorage.this.tableName + " (uuid, user_eid, state, dismiss_time) values (?, ?, ?, ?)").param(uuid).param(userEid.toLowerCase()).param(acknowledgementType.dbValue()).param(System.currentTimeMillis()).executeUpdate();
                db.commit();
                return null;
            }
        });
    }

    public void clearTemporaryDismissedForUser(final String userEid) {
        DB.transaction("Delete all temporarily dismissed banners for a user", new DBAction<Void>(){

            @Override
            public Void call(DBConnection db) throws SQLException {
                db.run("DELETE FROM " + AcknowledgementStorage.this.tableName + " WHERE state = ? AND user_eid = ?").param(AcknowledgementType.TEMPORARY.dbValue()).param(userEid).executeUpdate();
                db.commit();
                return null;
            }
        });
    }

    public static enum NotificationType {
        BANNER,
        POPUP;

    }
}

