/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.impl.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.sakaiproject.pasystem.impl.common.DBPreparedStatement;

public class DBConnection {
    private final Connection connection;
    private boolean resolved;
    private boolean dirty;

    public DBConnection(Connection connection) {
        this.connection = connection;
        this.dirty = false;
        this.resolved = false;
    }

    public void commit() throws SQLException {
        this.connection.commit();
        this.resolved = true;
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
        this.resolved = true;
    }

    public void markAsDirty() {
        this.dirty = true;
    }

    public boolean wasResolved() {
        if (this.dirty) {
            return this.resolved;
        }
        return true;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    public DBPreparedStatement run(String sql) throws SQLException {
        return new DBPreparedStatement(this.connection.prepareStatement(sql), this);
    }
}

