/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.impl;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.sakaiproject.authz.cover.FunctionManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.db.cover.SqlService;
import org.sakaiproject.pasystem.api.Banner;
import org.sakaiproject.pasystem.api.Banners;
import org.sakaiproject.pasystem.api.I18n;
import org.sakaiproject.pasystem.api.MissingUuidException;
import org.sakaiproject.pasystem.api.PASystem;
import org.sakaiproject.pasystem.api.PASystemException;
import org.sakaiproject.pasystem.api.Popup;
import org.sakaiproject.pasystem.api.Popups;
import org.sakaiproject.pasystem.impl.banners.BannerStorage;
import org.sakaiproject.pasystem.impl.common.SakaiI18n;
import org.sakaiproject.pasystem.impl.popups.PopupForUser;
import org.sakaiproject.pasystem.impl.popups.PopupStorage;
import org.sakaiproject.portal.util.PortalUtils;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PASystemImpl
implements PASystem {
    private static final Logger LOG = LoggerFactory.getLogger(PASystemImpl.class);
    private static final String POPUP_SCREEN_SHOWN = "pasystem.popup.screen.shown";

    PASystemImpl() {
    }

    public void init() {
        if (ServerConfigurationService.getBoolean((String)"auto.ddl", (boolean)false) || ServerConfigurationService.getBoolean((String)"pasystem.auto.ddl", (boolean)false)) {
            this.runDBMigration(ServerConfigurationService.getString((String)"vendor@org.sakaiproject.db.api.SqlService"));
        }
        FunctionManager.registerFunction((String)"pasystem.manage");
    }

    public void destroy() {
    }

    public String getFooter() {
        StringBuilder result = new StringBuilder();
        I18n i18n = this.getI18n(this.getClass().getClassLoader(), "org.sakaiproject.pasystem.impl.i18n.pasystem");
        Handlebars handlebars = this.loadHandleBars(i18n);
        Session session = SessionManager.getCurrentSession();
        HashMap<String, Object> context = new HashMap<String, Object>();
        try {
            Template template = handlebars.compile("templates/shared_footer");
            context.put("portalCDNQuery", PortalUtils.getCDNQuery());
            context.put("sakai_csrf_token", session.getAttribute("sakai.csrf.token"));
            result.append(template.apply(context));
        }
        catch (IOException e) {
            LOG.warn("IOException while getting footer", (Throwable)e);
            return "";
        }
        result.append(this.getBannersFooter(handlebars, context));
        result.append(this.getPopupsFooter(handlebars, context));
        result.append(this.getTimezoneCheckFooter(handlebars, context));
        return result.toString();
    }

    public Banners getBanners() {
        return new BannerStorage();
    }

    public Popups getPopups() {
        return new PopupStorage();
    }

    public I18n getI18n(ClassLoader loader, String resourceBase) {
        return new SakaiI18n(loader, resourceBase);
    }

    private Handlebars loadHandleBars(final I18n i18n) {
        Handlebars handlebars = new Handlebars();
        handlebars.registerHelper("t", (Helper)new Helper<Object>(){

            public CharSequence apply(Object context, Options options) {
                String key = (String)options.param(0);
                return i18n.t(key);
            }
        });
        return handlebars;
    }

    private void runDBMigration(String vendor) {
        String migrationFile = "db/migration/" + vendor + ".sql";
        InputStream is = PASystemImpl.class.getClassLoader().getResourceAsStream(migrationFile);
        if (is == null) {
            throw new PASystemException("Failed to find migration file: " + migrationFile);
        }
        InputStreamReader migrationInput = new InputStreamReader(is);
        try {
            Connection db = SqlService.borrowConnection();
            try {
                for (String sql : this.parseMigrationFile(migrationInput)) {
                    try {
                        PreparedStatement ps = db.prepareStatement(sql);
                        ps.execute();
                        ps.close();
                    }
                    catch (SQLException e) {
                        LOG.warn("runDBMigration: " + e + "(sql: " + sql + ")");
                    }
                }
            }
            catch (IOException e) {
                throw new PASystemException("Failed to read migration file: " + migrationFile, (Throwable)e);
            }
            finally {
                SqlService.returnConnection((Connection)db);
                try {
                    migrationInput.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (SQLException e) {
            throw new PASystemException("Database migration failed", (Throwable)e);
        }
    }

    private String[] parseMigrationFile(InputStreamReader migrationInput) throws IOException {
        int len;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[4096];
        while ((len = migrationInput.read(buf)) > 0) {
            sb.append(buf, 0, len);
        }
        return sb.toString().replace("\n", " ").split(";\\s*");
    }

    private String getBannersFooter(Handlebars handlebars, Map<String, Object> context) {
        try {
            Template template = handlebars.compile("templates/banner_footer");
            context.put("bannerJSON", this.getActiveBannersJSON());
            return template.apply(context);
        }
        catch (IOException e) {
            LOG.warn("IOException while getting banners footer", (Throwable)e);
            return "";
        }
    }

    private String getActiveBannersJSON() {
        JSONArray banners = new JSONArray();
        String serverId = ServerConfigurationService.getString((String)"serverId", (String)"localhost");
        User currentUser = UserDirectoryService.getCurrentUser();
        if (currentUser != null && currentUser.getEid() != null) {
            for (Banner banner : this.getBanners().getRelevantBanners(serverId, currentUser.getEid())) {
                try {
                    JSONObject bannerData = new JSONObject();
                    bannerData.put((Object)"id", (Object)banner.getUuid());
                    bannerData.put((Object)"message", (Object)banner.getMessage());
                    bannerData.put((Object)"dismissible", (Object)banner.isDismissible());
                    bannerData.put((Object)"dismissed", (Object)banner.isDismissed());
                    bannerData.put((Object)"type", (Object)banner.getType());
                    banners.add((Object)bannerData);
                }
                catch (Exception e) {
                    LOG.warn("Error processing banner: " + banner, (Throwable)e);
                }
            }
        }
        return banners.toJSONString();
    }

    private String getPopupsFooter(Handlebars handlebars, Map<String, Object> context) {
        Session session = SessionManager.getCurrentSession();
        User currentUser = UserDirectoryService.getCurrentUser();
        if (currentUser == null) {
            return "";
        }
        try {
            Popup popup;
            if (session.getAttribute(POPUP_SCREEN_SHOWN) == null && (popup = new PopupForUser(currentUser).getPopup()).isActiveNow()) {
                context.put("popupTemplate", popup.getTemplate());
                context.put("popupUuid", popup.getUuid());
                context.put("popup", true);
                if (currentUser.getEid() != null) {
                    session.setAttribute(POPUP_SCREEN_SHOWN, (Object)"true");
                }
            }
            Template template = handlebars.compile("templates/popup_footer");
            return template.apply(context);
        }
        catch (IOException | MissingUuidException e) {
            LOG.warn("IOException while getting popups footer", e);
            return "";
        }
    }

    private String getTimezoneCheckFooter(Handlebars handlebars, Map<String, Object> context) {
        if (ServerConfigurationService.getBoolean((String)"pasystem.timezone-check", (boolean)false)) {
            try {
                Template template = handlebars.compile("templates/timezone_footer");
                return template.apply(context);
            }
            catch (IOException e) {
                LOG.warn("Timezone footer failed", (Throwable)e);
                return "";
            }
        }
        return "";
    }
}

