/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.impl.common;

import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.sakaiproject.pasystem.impl.common.DBConnection;
import org.sakaiproject.pasystem.impl.common.DBResults;

public class DBPreparedStatement {
    private final DBConnection dbConnection;
    private final PreparedStatement preparedStatement;
    private int paramCount;

    public DBPreparedStatement(PreparedStatement preparedStatement, DBConnection dbc) {
        this.dbConnection = dbc;
        this.preparedStatement = preparedStatement;
        this.paramCount = 1;
    }

    public DBPreparedStatement param(String parameter) throws SQLException {
        try {
            this.preparedStatement.setString(this.paramCount(), parameter);
            return this;
        }
        catch (SQLException e) {
            this.cleanup();
            throw e;
        }
    }

    public DBPreparedStatement param(Long parameter) throws SQLException {
        try {
            this.preparedStatement.setLong(this.paramCount(), parameter);
            return this;
        }
        catch (SQLException e) {
            this.cleanup();
            throw e;
        }
    }

    public DBPreparedStatement param(Integer parameter) throws SQLException {
        try {
            this.preparedStatement.setInt(this.paramCount(), parameter);
            return this;
        }
        catch (SQLException e) {
            this.cleanup();
            throw e;
        }
    }

    public DBPreparedStatement param(Reader reader) throws SQLException {
        try {
            this.preparedStatement.setClob(this.paramCount(), reader);
            return this;
        }
        catch (SQLException e) {
            this.cleanup();
            throw e;
        }
    }

    public DBPreparedStatement param(Reader reader, long length) throws SQLException {
        try {
            int param = this.paramCount();
            try {
                this.preparedStatement.setCharacterStream(param, reader, length);
            }
            catch (AbstractMethodError e) {
                this.preparedStatement.setCharacterStream(param, reader, (int)length);
            }
            return this;
        }
        catch (SQLException e) {
            this.cleanup();
            throw e;
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            this.dbConnection.markAsDirty();
            int n = this.preparedStatement.executeUpdate();
            return n;
        }
        finally {
            this.cleanup();
        }
    }

    public DBResults executeQuery() throws SQLException {
        return new DBResults(this.preparedStatement.executeQuery(), this.preparedStatement);
    }

    private void cleanup() throws SQLException {
        this.preparedStatement.close();
    }

    private int paramCount() {
        return this.paramCount++;
    }
}

