/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.impl.common;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBResults
implements Iterable<ResultSet>,
Iterator<ResultSet>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DBResults.class);
    private final PreparedStatement originalStatement;
    private final ResultSet resultSet;
    private boolean hasRowReady;

    public DBResults(ResultSet rs, PreparedStatement originalStatement) {
        this.resultSet = rs;
        this.originalStatement = originalStatement;
    }

    @Override
    public void close() throws SQLException {
        this.resultSet.close();
        this.originalStatement.close();
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this.hasRowReady) {
                this.hasRowReady = this.resultSet.next();
            }
            return this.hasRowReady;
        }
        catch (SQLException e) {
            LOG.warn("SQLException while calling hasNext", (Throwable)e);
            return false;
        }
    }

    @Override
    public ResultSet next() {
        if (!this.hasRowReady) {
            throw new NoSuchElementException("Read past end of results");
        }
        this.hasRowReady = false;
        return this.resultSet;
    }

    @Override
    public Iterator<ResultSet> iterator() {
        return this;
    }
}

