/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.impl.common;

import java.sql.Connection;
import java.sql.SQLException;
import org.sakaiproject.db.cover.SqlService;
import org.sakaiproject.pasystem.impl.common.DBAction;
import org.sakaiproject.pasystem.impl.common.DBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB {
    private static final Logger LOG = LoggerFactory.getLogger(DB.class);

    private DB() {
    }

    public static <E> E transaction(DBAction<E> action) throws RuntimeException {
        return DB.transaction(action.toString(), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E> E transaction(String actionDescription, DBAction<E> action) throws RuntimeException {
        try {
            Connection db = SqlService.borrowConnection();
            DBConnection dbc = new DBConnection(db);
            boolean autocommit = db.getAutoCommit();
            try {
                db.setAutoCommit(false);
                E e = action.call(dbc);
                return e;
            }
            finally {
                if (!dbc.wasResolved()) {
                    LOG.warn("**************\nDB Transaction was neither committed nor rolled back.  Committing for you.");
                    new Throwable().printStackTrace();
                    dbc.commit();
                }
                if (autocommit) {
                    db.setAutoCommit(true);
                }
                SqlService.returnConnection((Connection)db);
            }
        }
        catch (SQLException e2) {
            throw new RuntimeException("Failure in database action: " + actionDescription, e2);
        }
    }
}

