/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.impl.popups;

import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.pasystem.api.Popup;
import org.sakaiproject.pasystem.impl.common.DB;
import org.sakaiproject.pasystem.impl.common.DBAction;
import org.sakaiproject.pasystem.impl.common.DBConnection;
import org.sakaiproject.pasystem.impl.common.DBResults;
import org.sakaiproject.user.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopupForUser {
    private static final Logger LOG = LoggerFactory.getLogger(PopupForUser.class);
    private User user;
    private String eid;

    public PopupForUser(User currentUser) {
        this.user = currentUser;
        if (this.user != null && this.user.getEid() != null) {
            this.eid = this.user.getEid().toLowerCase();
        } else {
            this.user = null;
        }
    }

    public Popup getPopup() {
        if (this.user == null) {
            return Popup.createNullPopup();
        }
        final String sql = "SELECT popup.uuid, popup.descriptor, popup.start_time, popup.end_time, popup.open_campaign, content.template_content  FROM pasystem_popup_screens popup INNER JOIN pasystem_popup_content content on content.uuid = popup.uuid LEFT OUTER join pasystem_popup_assign assign  on assign.uuid = popup.uuid AND assign.user_eid = ? LEFT OUTER JOIN pasystem_popup_dismissed dismissed  on dismissed.uuid = popup.uuid AND dismissed.user_eid = ? WHERE  ((assign.uuid IS NOT NULL) OR (popup.open_campaign = 1)) AND  popup.start_time <= ? AND  ((popup.end_time = 0) OR (popup.end_time > ?)) AND  (dismissed.state is NULL OR  (dismissed.state = 'temporary' AND   (? - dismissed.dismiss_time) >= ?))";
        try {
            final long now = System.currentTimeMillis();
            return DB.transaction("Find a popup for the current user", new DBAction<Popup>(){

                @Override
                public Popup call(DBConnection db) throws SQLException {
                    try (DBResults results = db.run(sql).param(PopupForUser.this.eid).param(PopupForUser.this.eid).param(now).param(now).param(now).param(PopupForUser.this.getTemporaryTimeoutMilliseconds()).executeQuery();){
                        Popup popup = results.iterator();
                        if (popup.hasNext()) {
                            ResultSet result = popup.next();
                            Clob contentClob = result.getClob("template_content");
                            String templateContent = contentClob.getSubString(1L, (int)contentClob.length());
                            Popup popup2 = Popup.create((String)result.getString("uuid"), (String)result.getString("descriptor"), (long)result.getLong("start_time"), (long)result.getLong("end_time"), (result.getInt("open_campaign") == 1 ? 1 : 0) != 0, (String)templateContent);
                            return popup2;
                        }
                        popup = Popup.createNullPopup();
                        return popup;
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error determining active popup", (Throwable)e);
            return Popup.createNullPopup();
        }
    }

    private int getTemporaryTimeoutMilliseconds() {
        return ServerConfigurationService.getInt((String)"pasystem.popup.temporary-timeout-ms", (int)86400000);
    }
}

