/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.impl.popups;

import java.io.InputStreamReader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.sakaiproject.pasystem.api.AcknowledgementType;
import org.sakaiproject.pasystem.api.Acknowledger;
import org.sakaiproject.pasystem.api.MissingUuidException;
import org.sakaiproject.pasystem.api.Popup;
import org.sakaiproject.pasystem.api.Popups;
import org.sakaiproject.pasystem.api.TemplateStream;
import org.sakaiproject.pasystem.impl.acknowledgements.AcknowledgementStorage;
import org.sakaiproject.pasystem.impl.common.DB;
import org.sakaiproject.pasystem.impl.common.DBAction;
import org.sakaiproject.pasystem.impl.common.DBConnection;
import org.sakaiproject.pasystem.impl.common.DBResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopupStorage
implements Popups,
Acknowledger {
    private static final Logger LOG = LoggerFactory.getLogger(PopupStorage.class);

    public String createCampaign(final Popup popup, final TemplateStream templateInput, final Optional<List<String>> assignToUsers) {
        return DB.transaction("Popup creation", new DBAction<String>(){

            @Override
            public String call(DBConnection db) throws SQLException {
                String uuid = UUID.randomUUID().toString();
                db.run("INSERT INTO pasystem_popup_screens (uuid, descriptor, start_time, end_time, open_campaign) VALUES (?, ?, ?, ?, ?)").param(uuid).param(popup.getDescriptor()).param(popup.getStartTime()).param(popup.getEndTime()).param(popup.isOpenCampaign() ? 1 : 0).executeUpdate();
                PopupStorage.this.setPopupContent(db, uuid, templateInput);
                PopupStorage.this.setPopupAssignees(db, uuid, assignToUsers);
                db.commit();
                return uuid;
            }
        });
    }

    public void updateCampaign(final Popup popup, final Optional<TemplateStream> templateInput, final Optional<List<String>> assignToUsers) {
        try {
            final String uuid = popup.getUuid();
            DB.transaction("Update an existing popup campaign", new DBAction<Void>(){

                @Override
                public Void call(DBConnection db) throws SQLException {
                    db.run("UPDATE pasystem_popup_screens SET descriptor = ?, start_time = ?, end_time = ?, open_campaign = ? WHERE uuid = ?").param(popup.getDescriptor()).param(popup.getStartTime()).param(popup.getEndTime()).param(popup.isOpenCampaign() ? 1 : 0).param(uuid).executeUpdate();
                    PopupStorage.this.setPopupAssignees(db, uuid, assignToUsers);
                    if (templateInput.isPresent()) {
                        PopupStorage.this.setPopupContent(db, uuid, (TemplateStream)templateInput.get());
                    }
                    db.commit();
                    LOG.info("Update of popup {} completed", (Object)uuid);
                    return null;
                }
            });
        }
        catch (MissingUuidException e) {
            throw new RuntimeException("Can't update a popup with no UUID specified", e);
        }
    }

    public List<Popup> getAll() {
        return DB.transaction("Find all popups", new DBAction<List<Popup>>(){

            @Override
            public List<Popup> call(DBConnection db) throws SQLException {
                ArrayList<Popup> popups = new ArrayList<Popup>();
                try (DBResults results = db.run("SELECT * from pasystem_popup_screens").executeQuery();){
                    for (ResultSet result : results) {
                        popups.add(Popup.create((String)result.getString("uuid"), (String)result.getString("descriptor"), (long)result.getLong("start_time"), (long)result.getLong("end_time"), (result.getInt("open_campaign") == 1 ? 1 : 0) != 0));
                    }
                    ArrayList<Popup> arrayList = popups;
                    return arrayList;
                }
            }
        });
    }

    public String getPopupContent(final String uuid) {
        return DB.transaction("Get the content for a popup", new DBAction<String>(){

            @Override
            public String call(DBConnection db) throws SQLException {
                try (DBResults results = db.run("SELECT template_content from pasystem_popup_content where uuid = ?").param(uuid).executeQuery();){
                    Object object = results.iterator();
                    if (object.hasNext()) {
                        ResultSet result = object.next();
                        Clob contentClob = result.getClob("template_content");
                        String string = contentClob.getSubString(1L, (int)contentClob.length());
                        return string;
                    }
                    object = "";
                    return object;
                }
            }
        });
    }

    public Optional<Popup> getForId(final String uuid) {
        return DB.transaction("Find a popup by uuid", new DBAction<Optional<Popup>>(){

            @Override
            public Optional<Popup> call(DBConnection db) throws SQLException {
                try (DBResults results = db.run("SELECT * from pasystem_popup_screens WHERE UUID = ?").param(uuid).executeQuery();){
                    Object object = results.iterator();
                    if (object.hasNext()) {
                        ResultSet result = object.next();
                        Optional<Popup> optional = Optional.of(Popup.create((String)result.getString("uuid"), (String)result.getString("descriptor"), (long)result.getLong("start_time"), (long)result.getLong("end_time"), (result.getInt("open_campaign") == 1 ? 1 : 0) != 0));
                        return optional;
                    }
                    object = Optional.empty();
                    return object;
                }
            }
        });
    }

    public List<String> getAssignees(final String uuid) {
        return DB.transaction("Find a list of assignees by popup uuid", new DBAction<List<String>>(){

            @Override
            public List<String> call(DBConnection db) throws SQLException {
                ArrayList<String> users = new ArrayList<String>();
                try (DBResults results = db.run("SELECT user_eid from pasystem_popup_assign WHERE UUID = ? AND user_eid is not NULL").param(uuid).executeQuery();){
                    for (ResultSet result : results) {
                        users.add(result.getString("user_eid"));
                    }
                    ArrayList<String> arrayList = users;
                    return arrayList;
                }
            }
        });
    }

    private void setPopupContent(DBConnection db, String uuid, TemplateStream templateContent) throws SQLException {
        try {
            db.run("INSERT INTO pasystem_popup_content (uuid) VALUES (?)").param(uuid).executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        db.run("UPDATE pasystem_popup_content set template_content = ? WHERE uuid = ?").param(new InputStreamReader(templateContent.getInputStream()), templateContent.getLength()).param(uuid).executeUpdate();
    }

    private void setPopupAssignees(DBConnection db, String uuid, Optional<List<String>> assignToUsers) throws SQLException {
        if (assignToUsers.isPresent()) {
            db.run("DELETE FROM pasystem_popup_assign where uuid = ? AND user_eid is not NULL").param(uuid).executeUpdate();
            for (String userEid : assignToUsers.get()) {
                db.run("INSERT INTO pasystem_popup_assign (uuid, user_eid) VALUES (?, ?)").param(uuid).param(userEid).executeUpdate();
            }
        }
    }

    public boolean deleteCampaign(final String uuid) {
        return DB.transaction("Delete an existing popup campaign", new DBAction<Boolean>(){

            @Override
            public Boolean call(DBConnection db) throws SQLException {
                db.run("DELETE FROM pasystem_popup_assign where uuid = ?").param(uuid).executeUpdate();
                db.run("DELETE FROM pasystem_popup_dismissed where uuid = ?").param(uuid).executeUpdate();
                db.run("DELETE FROM pasystem_popup_content where uuid = ?").param(uuid).executeUpdate();
                db.run("DELETE FROM pasystem_popup_screens WHERE uuid = ?").param(uuid).executeUpdate();
                db.commit();
                return true;
            }
        });
    }

    public void acknowledge(String uuid, String userEid, AcknowledgementType acknowledgementType) {
        new AcknowledgementStorage(AcknowledgementStorage.NotificationType.POPUP).acknowledge(uuid, userEid, acknowledgementType);
    }

    public void acknowledge(String uuid, String userEid) {
        this.acknowledge(uuid, userEid, AcknowledgementType.TEMPORARY);
    }
}

