/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.impl.rest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.simple.JSONObject;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.EntityProvider;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderManager;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.pasystem.api.Banner;
import org.sakaiproject.pasystem.api.Errors;
import org.sakaiproject.pasystem.api.PASystem;
import org.sakaiproject.pasystem.api.PASystemException;
import org.sakaiproject.pasystem.api.Popup;
import org.sakaiproject.pasystem.api.TemplateStream;
import org.sakaiproject.tool.cover.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PASystemAdminEntityProvider
implements EntityProvider,
AutoRegisterEntityProvider,
ActionsExecutable,
Outputable,
Describeable {
    private static final Logger LOG = LoggerFactory.getLogger(PASystemAdminEntityProvider.class);
    private static final String ADMIN_SITE_REALM = "/site/!admin";
    private static final String SAKAI_SESSION_TOKEN_PROPERTY = "sakai.pasystem-admin.token";
    private static final String REQUEST_SESSION_PARAMETER = "session";
    protected DeveloperHelperService developerHelperService;
    private EntityProviderManager entityProviderManager;

    public String[] getHandledOutputFormats() {
        return new String[]{"json"};
    }

    public String getEntityPrefix() {
        return "pasystem-admin";
    }

    @EntityCustomAction(action="startSession", viewKey="new")
    public String startSession(EntityView view, Map<String, Object> params) {
        try {
            this.assertPermission();
            JSONObject result = new JSONObject();
            String newSessionId = this.mintSessionId();
            result.put((Object)REQUEST_SESSION_PARAMETER, (Object)newSessionId);
            SessionManager.getCurrentSession().setAttribute(SAKAI_SESSION_TOKEN_PROPERTY, (Object)newSessionId);
            return result.toJSONString();
        }
        catch (Exception e) {
            return this.respondWithError(e);
        }
    }

    @EntityCustomAction(action="createPopup", viewKey="new")
    public String createPopup(EntityView view, Map<String, Object> params) {
        try {
            this.assertSession(params);
            WrappedParams wp = new WrappedParams(params);
            Popup popup = Popup.create((String)wp.getString("descriptor"), (long)wp.getEpochMS("start_time"), (long)wp.getEpochMS("end_time"), (boolean)wp.getBoolean("is_open_campaign"));
            Errors errors = popup.validate();
            if (errors.hasErrors()) {
                return this.respondWithError(errors);
            }
            String template = wp.getString("template");
            TemplateStream templateStream = new TemplateStream((InputStream)new ByteArrayInputStream(template.getBytes()), (long)template.length());
            String uuid = this.paSystem().getPopups().createCampaign(popup, templateStream, Optional.ofNullable(wp.getCommaList("assign_to_users")));
            JSONObject result = new JSONObject();
            result.put((Object)"status", (Object)"OK");
            result.put((Object)"created_id", (Object)uuid);
            return result.toJSONString();
        }
        catch (Exception e) {
            return this.respondWithError(e);
        }
    }

    @EntityCustomAction(action="deletePopup", viewKey="new")
    public String deletePopup(EntityView view, Map<String, Object> params) {
        try {
            this.assertSession(params);
            WrappedParams wp = new WrappedParams(params);
            String uuid = wp.getString("id");
            this.paSystem().getPopups().deleteCampaign(uuid);
            JSONObject result = new JSONObject();
            result.put((Object)"status", (Object)"OK");
            result.put((Object)"id", (Object)uuid);
            return result.toJSONString();
        }
        catch (Exception e) {
            return this.respondWithError(e);
        }
    }

    @EntityCustomAction(action="createBanner", viewKey="new")
    public String createBanner(EntityView view, Map<String, Object> params) {
        try {
            this.assertSession(params);
            WrappedParams wp = new WrappedParams(params);
            Banner banner = new Banner(wp.getString("message"), wp.getString("hosts", ""), wp.getBoolean("is_active"), wp.getEpochMS("start_time"), wp.getEpochMS("end_time"), wp.getString("type"));
            Errors errors = banner.validate();
            if (errors.hasErrors()) {
                return this.respondWithError(errors);
            }
            String uuid = this.paSystem().getBanners().createBanner(banner);
            JSONObject result = new JSONObject();
            result.put((Object)"status", (Object)"OK");
            result.put((Object)"created_id", (Object)uuid);
            return result.toJSONString();
        }
        catch (Exception e) {
            return this.respondWithError(e);
        }
    }

    @EntityCustomAction(action="deleteBanner", viewKey="new")
    public String deleteBanner(EntityView view, Map<String, Object> params) {
        try {
            this.assertSession(params);
            WrappedParams wp = new WrappedParams(params);
            String uuid = wp.getString("id");
            this.paSystem().getBanners().deleteBanner(uuid);
            JSONObject result = new JSONObject();
            result.put((Object)"status", (Object)"OK");
            result.put((Object)"id", (Object)uuid);
            return result.toJSONString();
        }
        catch (Exception e) {
            return this.respondWithError(e);
        }
    }

    private String respondWithError(Exception e) {
        JSONObject result = new JSONObject();
        result.put((Object)"status", (Object)"ERROR");
        result.put((Object)"message", (Object)e.getMessage());
        LOG.error("Caught an error while handling a request", (Throwable)e);
        return result.toJSONString();
    }

    private String respondWithError(Errors e) {
        JSONObject result = new JSONObject();
        result.put((Object)"status", (Object)"ERROR");
        result.put((Object)"message", (Object)e.toMap());
        return result.toJSONString();
    }

    private void assertSession(Map<String, Object> params) {
        this.assertPermission();
        String tokenFromUser = (String)params.get(REQUEST_SESSION_PARAMETER);
        String tokenFromSession = (String)SessionManager.getCurrentSession().getAttribute(SAKAI_SESSION_TOKEN_PROPERTY);
        if (tokenFromSession == null || tokenFromUser == null || !tokenFromSession.equals(tokenFromUser)) {
            LOG.error("assertSession failed for user " + SessionManager.getCurrentSessionUserId());
            throw new PASystemException("Access denied");
        }
    }

    private void assertPermission() {
        if (!SecurityService.unlock((String)"pasystem.manage", (String)ADMIN_SITE_REALM)) {
            LOG.error("assertPermission denied access to user " + SessionManager.getCurrentSessionUserId());
            throw new PASystemException("Access denied");
        }
    }

    private PASystem paSystem() {
        return (PASystem)ComponentManager.get(PASystem.class);
    }

    private String mintSessionId() {
        byte[] b = new byte[32];
        try {
            SecureRandom.getInstance("SHA1PRNG").nextBytes(b);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Couldn't generate a session ID", e);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(String.format("%02x", b[i]));
        }
        return sb.toString();
    }

    public void setEntityProviderManager(EntityProviderManager entityProviderManager) {
        this.entityProviderManager = entityProviderManager;
    }

    public void setDeveloperHelperService(DeveloperHelperService developerHelperService) {
        this.developerHelperService = developerHelperService;
    }

    private class WrappedParams {
        private final Map<String, Object> params;

        public WrappedParams(Map<String, Object> params) {
            this.params = params;
        }

        public String getString(String name) {
            String result = (String)this.params.get(name);
            if (result == null) {
                throw new IllegalArgumentException("Parameter " + name + " cannot be null.");
            }
            return result;
        }

        public String getString(String name, String defaultValue) {
            if (this.containsKey(name)) {
                return this.getString(name);
            }
            return defaultValue;
        }

        public long getEpochMS(String name) {
            return Long.valueOf(this.getString(name));
        }

        public boolean getBoolean(String name) {
            return Boolean.valueOf(this.getString(name));
        }

        public List<String> getCommaList(String name) {
            if (this.containsKey("assign_to_users")) {
                return Arrays.asList(this.getString("assign_to_users").split("[, ]+"));
            }
            return null;
        }

        public boolean containsKey(String name) {
            return this.params.containsKey(name);
        }
    }
}

