/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pasystem.impl.rest;

import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.EntityProvider;
import org.sakaiproject.entitybroker.entityprovider.EntityProviderManager;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.pasystem.api.AcknowledgementType;
import org.sakaiproject.pasystem.api.Acknowledger;
import org.sakaiproject.pasystem.api.PASystem;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PASystemEntityProvider
implements EntityProvider,
AutoRegisterEntityProvider,
ActionsExecutable,
Outputable,
Describeable {
    private static final Logger LOG = LoggerFactory.getLogger(PASystemEntityProvider.class);
    protected DeveloperHelperService developerHelperService;
    private EntityProviderManager entityProviderManager;

    public String[] getHandledOutputFormats() {
        return new String[]{"json"};
    }

    public String getEntityPrefix() {
        return "pasystem";
    }

    @EntityCustomAction(action="popupAcknowledge", viewKey="new")
    public String popupAcknowledge(EntityView view, Map<String, Object> params) {
        PASystem paSystem = (PASystem)ComponentManager.get(PASystem.class);
        return this.doAcknowledge((Acknowledger)paSystem.getPopups(), params);
    }

    @EntityCustomAction(action="bannerAcknowledge", viewKey="new")
    public String bannerAcknowledge(EntityView view, Map<String, Object> params) {
        PASystem paSystem = (PASystem)ComponentManager.get(PASystem.class);
        return this.doAcknowledge((Acknowledger)paSystem.getBanners(), params);
    }

    private boolean checkCSRFToken(Map<String, Object> params) {
        Object sessionToken = SessionManager.getCurrentSession().getAttribute("sakai.csrf.token");
        if (sessionToken == null || !sessionToken.equals(params.get("sakai_csrf_token"))) {
            LOG.warn("CSRF token validation failed");
            return false;
        }
        return true;
    }

    private String doAcknowledge(Acknowledger acknowledger, Map<String, Object> params) {
        JSONObject result = new JSONObject();
        result.put((Object)"status", (Object)"ERROR");
        if (!this.checkCSRFToken(params)) {
            return result.toJSONString();
        }
        User currentUser = UserDirectoryService.getCurrentUser();
        String uuid = (String)params.get("uuid");
        String acknowledgement = (String)params.get("acknowledgement");
        String eid = currentUser.getEid();
        if (uuid == null || eid == null) {
            LOG.warn("Parameter mismatch: {}", params);
            return result.toJSONString();
        }
        if (acknowledgement == null) {
            acknowledger.acknowledge(uuid, eid);
        } else {
            acknowledger.acknowledge(uuid, eid, AcknowledgementType.of((String)acknowledgement));
        }
        result.put((Object)"status", (Object)"SUCCESS");
        return result.toJSONString();
    }

    @EntityCustomAction(action="clearBannerAcknowledgements", viewKey="new")
    public String clearBannerAcknowledgements(EntityView view, Map<String, Object> params) {
        PASystem paSystem = (PASystem)ComponentManager.get(PASystem.class);
        JSONObject result = new JSONObject();
        result.put((Object)"status", (Object)"ERROR");
        if (!this.checkCSRFToken(params)) {
            return result.toJSONString();
        }
        User currentUser = UserDirectoryService.getCurrentUser();
        String eid = currentUser.getEid();
        if (eid == null) {
            LOG.warn("Parameter mismatch: {}", params);
            return result.toJSONString();
        }
        paSystem.getBanners().clearTemporaryDismissedForUser(eid);
        result.put((Object)"status", (Object)"SUCCESS");
        return result.toJSONString();
    }

    @EntityCustomAction(action="checkTimeZone", viewKey="list")
    public String checkTimeZone(EntityView view, Map<String, Object> params) {
        TimezoneChecker checker = new TimezoneChecker();
        JSONObject result = new JSONObject();
        result.put((Object)"status", (Object)"OK");
        String timezoneFromUser = (String)params.get("timezone");
        if (timezoneFromUser != null && checker.timezoneMismatch(timezoneFromUser)) {
            result.put((Object)"status", (Object)"MISMATCH");
            result.put((Object)"setTimezoneUrl", (Object)checker.getTimezoneToolUrlForUser());
            result.put((Object)"prefsTimezone", (Object)checker.formatTimezoneFromProfile());
            result.put((Object)"reportedTimezone", (Object)checker.formatReportedTimezone(timezoneFromUser));
        }
        return result.toJSONString();
    }

    public void setEntityProviderManager(EntityProviderManager entityProviderManager) {
        this.entityProviderManager = entityProviderManager;
    }

    public void setDeveloperHelperService(DeveloperHelperService developerHelperService) {
        this.developerHelperService = developerHelperService;
    }

    static class TimezoneChecker {
        TimezoneChecker() {
        }

        public String getTimezoneToolUrlForUser() {
            User thisUser = UserDirectoryService.getCurrentUser();
            String userid = thisUser.getId();
            if (StringUtils.isEmpty((String)userid)) {
                return null;
            }
            try {
                Site userSite = SiteService.getSite((String)("~" + userid));
                ToolConfiguration preferences = userSite.getToolForCommonId("sakai.preferences");
                return String.format("/portal/site/~%s/tool/%s/timezone", userid, preferences.getId());
            }
            catch (Exception e) {
                LOG.warn("Couldn't find a timezone tool for user {}", (Object)userid, (Object)e);
                return null;
            }
        }

        public boolean timezoneMismatch(String timezoneFromUser) {
            TimeZone preferredTimeZone = TimeService.getLocalTimeZone();
            TimeZone reportedTimeZone = TimeZone.getTimeZone(timezoneFromUser);
            long now = new Date().getTime();
            return preferredTimeZone.getOffset(now) != reportedTimeZone.getOffset(now);
        }

        public String formatTimezoneFromProfile() {
            return this.formatTimezone(TimeService.getLocalTimeZone());
        }

        public String formatReportedTimezone(String timezoneFromUser) {
            return this.formatTimezone(TimeZone.getTimeZone(timezoneFromUser));
        }

        public String formatTimezone(TimeZone tz) {
            return tz.getID() + " " + this.formatOffset(tz);
        }

        private String formatOffset(TimeZone tz) {
            long now = new Date().getTime();
            long offset = tz.getOffset(now);
            int mins = 60000;
            int hour = 60 * mins;
            return "(GMT " + String.format("%s%0,2d:%0,2d", offset >= 0L ? "+" : "", offset / (long)hour, offset % (long)hour / (long)mins) + ")";
        }
    }
}

