/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.pcservice.impl.entity;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.EntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Createable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Inputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.presence.api.PresenceService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCServiceEntityProvider
extends ReceiverAdapter
implements EntityProvider,
Createable,
Inputable,
Outputable,
ActionsExecutable,
AutoRegisterEntityProvider {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private static ResourceLoader rb = new ResourceLoader("portal-chat");
    public static final String ENTITY_PREFIX = "portal-chat";
    private final String HEARTBEAT_PREAMBLE = "heartbeat:";
    private final String MESSAGE_PREAMBLE = "message:";
    private final String CLEAR_PREAMBLE = "clear:";
    private boolean connectionsAvailable = true;
    private Object profileServiceObject = null;
    private Method getConnectionsForUserMethod = null;
    private Method getUuidMethod = null;
    private UserDirectoryService userDirectoryService;
    private EmailService emailService;
    private PresenceService presenceService;
    private ServerConfigurationService serverConfigurationService;
    private Map<String, List<UserMessage>> messageMap = new HashMap<String, List<UserMessage>>();
    private Map<String, Date> heartbeatMap = new ConcurrentHashMap<String, Date>(500, 0.75f, 32);
    private Channel clusterChannel = null;
    private boolean clustered = false;
    private String portalUrl;
    private String service;
    private String serverName;

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setPresenceService(PresenceService presenceService) {
        this.presenceService = presenceService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void init() {
        this.service = this.serverConfigurationService.getString("ui.service", "Sakai");
        this.portalUrl = this.serverConfigurationService.getServerUrl() + "/portal";
        this.serverName = this.serverConfigurationService.getServerName();
        try {
            String channelId = this.serverConfigurationService.getString("portalchat.cluster.channel");
            if (channelId != null && !channelId.equals("")) {
                this.clusterChannel = new JChannel();
                this.clusterChannel.setReceiver((Receiver)this);
                this.clusterChannel.connect(channelId);
                this.clusterChannel.setOpt(3, (Object)false);
                this.clustered = true;
                this.logger.info((Object)("Portal chat is connected on JGroups channel '" + channelId + "'"));
            } else {
                this.logger.info((Object)"No 'portalchat.cluster.channel' specified in sakai.properties. JGroups will not be used and chat messages will not be replicated.");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error creating JGroups channel. Chat messages will now NOT BE KEPT IN SYNC", (Throwable)e);
        }
        try {
            ComponentManager componentManager = org.sakaiproject.component.cover.ComponentManager.getInstance();
            this.profileServiceObject = componentManager.get("org.sakaiproject.profile2.service.ProfileService");
            this.getConnectionsForUserMethod = this.profileServiceObject.getClass().getMethod("getConnectionsForUser", String.class);
            Class<?> personClass = Class.forName("org.sakaiproject.profile2.model.Person");
            this.getUuidMethod = personClass.getMethod("getUuid", null);
        }
        catch (Exception e) {
            this.connectionsAvailable = false;
            this.logger.info((Object)"Profile2 not installed so portal chat will not use connections.");
        }
    }

    private List<Object> getConnectionsForUser(String uuid) {
        List<Object> connections = new ArrayList<Object>();
        if (!this.connectionsAvailable) {
            return connections;
        }
        try {
            connections = (List)this.getConnectionsForUserMethod.invoke(this.profileServiceObject, uuid);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to invoke the getConnectionsForUser method. Returning an empty connections list ...", (Throwable)e);
        }
        return connections;
    }

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"txt", "json"};
    }

    public Object getSampleEntity() {
        return new UserMessage();
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        User currentUser = this.userDirectoryService.getCurrentUser();
        User anon = this.userDirectoryService.getAnonymousUser();
        if (anon.equals(currentUser)) {
            throw new SecurityException("You must be logged in to use this service");
        }
        String to = (String)params.get("to");
        if (to == null) {
            throw new IllegalArgumentException("You must supply a recipient");
        }
        if (to.equals(currentUser.getId())) {
            throw new IllegalArgumentException("You can't chat with yourself");
        }
        Date now = new Date();
        Date lastHeartbeat = null;
        lastHeartbeat = this.heartbeatMap.get(to);
        if (lastHeartbeat == null) {
            return "OFFLINE";
        }
        if (now.getTime() - lastHeartbeat.getTime() >= 5000L) {
            return "OFFLINE";
        }
        String message = (String)params.get("message");
        if (message == null) {
            throw new IllegalArgumentException("You must supply a message");
        }
        this.addMessageToMap(new UserMessage(currentUser.getId(), to, message));
        if (this.clustered) {
            try {
                Message msg = new Message(null, null, (Serializable)((Object)("message:" + currentUser.getId() + ":" + to + ":" + message)));
                this.clusterChannel.send(msg);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error sending JGroups message", (Throwable)e);
            }
        }
        return "success";
    }

    public String[] getHandledInputFormats() {
        return new String[]{"html"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EntityCustomAction(action="latestData", viewKey="show")
    public Map<String, Object> handleLatestData(EntityReference ref, Map<String, Object> params) {
        Object uuid;
        User currentUser = this.userDirectoryService.getCurrentUser();
        User anon = this.userDirectoryService.getAnonymousUser();
        if (anon.equals(currentUser)) {
            throw new SecurityException("You must be logged in to use this service");
        }
        String online = (String)params.get("online");
        if ("true".equals(online)) {
            this.heartbeatMap.put(currentUser.getId(), new Date());
            if (this.clustered) {
                Message msg = new Message(null, null, (Serializable)((Object)("heartbeat:" + currentUser.getId())));
                try {
                    this.clusterChannel.send(msg);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error sending JGroups heartbeat message", (Throwable)e);
                }
            }
        } else {
            Map<String, List<UserMessage>> msg = this.messageMap;
            synchronized (msg) {
                this.messageMap.remove(currentUser.getId());
            }
            this.sendClearMessage(currentUser.getId());
            return new HashMap<String, Object>(0);
        }
        List presentUsers = new ArrayList();
        String siteId = (String)params.get("siteId");
        if (siteId != null && siteId.length() > 0) {
            presentUsers = this.presenceService.getPresentUsers(siteId + "-presence");
            presentUsers.remove(currentUser);
        }
        List<Object> connections = this.getConnectionsForUser(currentUser.getId());
        ArrayList<Object> onlineConnections = new ArrayList<Object>(connections.size());
        Date now = new Date();
        for (Object personObject : connections) {
            uuid = null;
            try {
                uuid = (String)this.getUuidMethod.invoke(personObject, null);
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to invoke getUuid on a Person instance. Skipping this person ...", (Throwable)e);
                continue;
            }
            Date lastHeartbeat = null;
            lastHeartbeat = this.heartbeatMap.get(uuid);
            if (lastHeartbeat == null || now.getTime() - lastHeartbeat.getTime() >= 5000L) continue;
            onlineConnections.add(uuid);
        }
        List<Object> messages = new ArrayList();
        String currentUserId = currentUser.getId();
        uuid = this.messageMap;
        synchronized (uuid) {
            if (this.messageMap.containsKey(currentUserId)) {
                messages = this.messageMap.get(currentUserId);
                this.messageMap.remove(currentUserId);
            }
            this.sendClearMessage(currentUserId);
        }
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("connections", connections);
        data.put("messages", messages);
        data.put("online", onlineConnections);
        data.put("presentUsers", presentUsers);
        data.put("connectionsAvailable", this.connectionsAvailable);
        return data;
    }

    private void sendClearMessage(String userId) {
        if (this.clustered) {
            try {
                Message msg = new Message(null, null, (Serializable)((Object)("clear:" + userId)));
                this.clusterChannel.send(msg);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error sending JGroups clear message", (Throwable)e);
            }
        }
    }

    @EntityCustomAction(action="ping", viewKey="show")
    public String handlePing(EntityReference ref) {
        User currentUser = this.userDirectoryService.getCurrentUser();
        User anon = this.userDirectoryService.getAnonymousUser();
        if (anon.equals(currentUser)) {
            throw new SecurityException("You must be logged in to use this service");
        }
        String userId = ref.getId();
        try {
            String email = this.userDirectoryService.getUser(userId).getEmail();
            new EmailSender(email, rb.getString("email.subject"), rb.getFormattedMessage("email.body", (Object[])new String[]{currentUser.getDisplayName(), this.service, this.portalUrl}));
        }
        catch (Exception e) {
            throw new EntityException("Failed to send email", userId);
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message msg) {
        Object o = msg.getObject();
        if (o instanceof String) {
            String message = (String)o;
            if (message.startsWith("heartbeat:")) {
                String onlineUserId = message.substring("heartbeat:".length());
                this.heartbeatMap.put(onlineUserId, new Date());
            } else if (message.startsWith("message:")) {
                Address address = this.clusterChannel.getAddress();
                String[] parts = message.split(":");
                String from = parts[1];
                String to = parts[2];
                String m = parts[3];
                this.addMessageToMap(new UserMessage(from, to, m));
            } else if (message.startsWith("clear:")) {
                String userId = message.substring("clear:".length());
                Map<String, List<UserMessage>> map = this.messageMap;
                synchronized (map) {
                    this.messageMap.remove(userId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageToMap(UserMessage m) {
        Map<String, List<UserMessage>> map = this.messageMap;
        synchronized (map) {
            List<UserMessage> current = this.messageMap.get(m.to);
            if (current != null) {
                ArrayList<UserMessage> copy = new ArrayList<UserMessage>(current.size());
                copy.addAll(current);
                copy.add(m);
                this.messageMap.put(m.to, copy);
            } else {
                this.messageMap.put(m.to, Arrays.asList(m));
            }
        }
    }

    private class EmailSender
    implements Runnable {
        private Thread runner;
        private String email;
        private String subject;
        private String message;

        public EmailSender(String email, String subject, String message) {
            this.email = email;
            this.subject = subject;
            this.message = message;
            this.runner = new Thread((Runnable)this, "PC EmailSender thread");
            this.runner.start();
        }

        public synchronized void run() {
            try {
                ArrayList<String> additionalHeaders = new ArrayList<String>();
                additionalHeaders.add("Content-Type: text/plain; charset=ISO-8859-1");
                String emailFromAddress = "\"" + PCServiceEntityProvider.this.service + "\" <no-reply@" + PCServiceEntityProvider.this.serverName + ">";
                PCServiceEntityProvider.this.emailService.send(emailFromAddress, this.email, this.subject, this.message, this.email, null, additionalHeaders);
            }
            catch (Exception e) {
                PCServiceEntityProvider.this.logger.error((Object)("sendEmail() failed for email: " + this.email), (Throwable)e);
            }
        }
    }

    public class UserMessage {
        public String from;
        public String to;
        public String content;
        public long timestamp;

        private UserMessage() {
        }

        private UserMessage(String from, String to, String content) {
            this.to = to;
            this.from = from;
            this.content = content;
            this.timestamp = new Date().getTime();
        }
    }
}

