/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.podcasts;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.podcasts.PodfeedService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.cover.ContentHostingService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.event.cover.NotificationService;
import org.sakaiproject.event.cover.UsageSessionService;
import org.sakaiproject.user.api.Authentication;
import org.sakaiproject.user.api.Evidence;
import org.sakaiproject.user.cover.AuthenticationManager;
import org.sakaiproject.util.IdPwEvidence;

public class RSSPodfeedServlet
extends HttpServlet {
    private static final String RESPONSE_MIME_TYPE = "application/xml; charset=UTF-8";
    private final String EVENT_PUBLIC_FEED = "podcast.read.public";
    private final String EVENT_PRIVATE_FEED = "podcast.read.site";
    private static final String FEED_TYPE = "type";
    private PodfeedService podfeedService;
    private final Log LOG = LogFactory.getLog(RSSPodfeedServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String siteId;
        String reqURL = request.getPathInfo();
        if (reqURL != null) {
            siteId = reqURL.substring(reqURL.lastIndexOf("/") + 1);
        } else {
            reqURL = request.getRequestURI();
            siteId = reqURL.substring(1, reqURL.lastIndexOf("/"));
        }
        this.LOG.debug((Object)("Podcast feed requested for site: " + siteId));
        String podcastsCollection = this.podfeedService.retrievePodcastFolderId(siteId);
        if (podcastsCollection == null) {
            response.setStatus(500);
            return;
        }
        boolean pubView = ContentHostingService.isPubView((String)podcastsCollection);
        if (!pubView) {
            block11: {
                IdPwEvidence e = this.getBasicAuthEvidence(request);
                if (e != null) {
                    try {
                        this.LOG.info((Object)("Authenticating " + e));
                        Authentication a = AuthenticationManager.authenticate((Evidence)e);
                        if (!UsageSessionService.login((Authentication)a, (HttpServletRequest)request)) {
                            this.sendErrorResponse(response);
                            return;
                        }
                        break block11;
                    }
                    catch (Exception exc) {
                        this.sendErrorResponse(response);
                        return;
                    }
                }
                this.sendErrorResponse(response);
                return;
            }
            if (!this.podfeedService.allowAccess(podcastsCollection)) {
                response.sendError(403);
            }
        }
        response.setContentType(RESPONSE_MIME_TYPE);
        String podcastFeed = this.podfeedService.generatePodcastRSS(siteId, request.getParameter(FEED_TYPE));
        if (podcastFeed == null || podcastFeed.equals("")) {
            response.setStatus(500);
        } else {
            response.getWriter().write(podcastFeed);
            Event event = null;
            event = pubView ? EventTrackingService.newEvent((String)"podcast.read.public", (String)podcastsCollection, (boolean)false, (int)NotificationService.NOTI_NONE) : EventTrackingService.newEvent((String)"podcast.read.site", (String)podcastsCollection, (boolean)false, (int)NotificationService.NOTI_NONE);
            EventTrackingService.post((Event)event);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void init() throws ServletException {
        this.LOG.debug((Object)(this + ": RSSPodfeedServlet.init()"));
        this.podfeedService = (PodfeedService)ComponentManager.get((String)"org.sakaiproject.api.app.podcasts.PodfeedService");
        if (this.podfeedService == null) {
            throw new ServletException((Throwable)new IllegalStateException("podfeedService == null"));
        }
    }

    public void setPodfeedService(PodfeedService podfeedService) {
        this.podfeedService = podfeedService;
    }

    private IdPwEvidence getBasicAuthEvidence(HttpServletRequest request) {
        Base64 base64Encoder = new Base64();
        String header = request.getHeader("Authorization");
        String[] elements = null;
        this.LOG.debug((Object)("Authorization: " + header));
        if (header != null) {
            elements = header.split(" ");
        }
        if (elements != null && elements.length >= 2) {
            String type = elements[0];
            String hash = elements[1];
            this.LOG.debug((Object)("type: " + type + " hash: " + hash));
            String[] credential = new String(base64Encoder.decode(hash.getBytes())).split(":");
            this.LOG.debug((Object)("credential: " + credential));
            if (credential != null && credential.length >= 2) {
                String eid = credential[0];
                String password = credential[1];
                this.LOG.debug((Object)("eid: " + eid + " password: ********"));
                if (eid.length() == 0 || password.length() == 0) {
                    return null;
                }
                return new IdPwEvidence(eid, password);
            }
        }
        return null;
    }

    private void sendErrorResponse(HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "BASIC realm=\"Podcaster\"");
        response.sendError(401);
    }
}

