/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Vote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Poll
implements Entity {
    private static final Logger log = LoggerFactory.getLogger(Poll.class);
    private static final long serialVersionUID = 2L;
    private static final String ISO8601_DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private Long id;
    private String owner;
    private String siteId;
    private Date creationDate;
    private String pollText = "";
    private String description = "";
    private int minOptions = 1;
    private int maxOptions = 1;
    private Date voteOpen = new Date();
    private Date voteClose;
    private List<Option> options;
    private List<Vote> votes;
    private String displayResult = "open";
    private boolean limitVoting = true;
    private boolean currentUserVoted = false;
    private List<Vote> currentUserVotes = null;
    private String entityID;
    private boolean isPublic = false;
    private static final String ID = "id";
    private static final String POLL_ID = "pollid";
    private static final String POLL_TEXT = "title";
    private static final String DESCRIPTION = "description";
    private static final String VOTE_OPEN = "open-time";
    private static final String VOTE_CLOSE = "close-time";
    private static final String LIMIT_VOTING = "limit-voting";
    private static final String MIN_OPTIONS = "min-options";
    private static final String MAX_OPTIONS = "max-options";

    public Poll() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 7);
        this.voteClose = cal.getTime();
        this.displayResult = "open";
        this.options = new ArrayList<Option>();
        this.votes = new ArrayList<Vote>();
    }

    public Long getPollId() {
        return this.id;
    }

    public void setPollId(Long id) {
        this.id = id;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getText() {
        return this.pollText;
    }

    public void setText(String poll) {
        this.pollText = poll;
    }

    public void setMinOptions(int value) {
        this.minOptions = value;
    }

    public int getMinOptions() {
        return this.minOptions;
    }

    public void setMaxOptions(int value) {
        this.maxOptions = value;
    }

    public int getMaxOptions() {
        return this.maxOptions;
    }

    public void setVoteOpen(Date value) {
        this.voteOpen = value;
    }

    public Date getVoteOpen() {
        return this.voteOpen;
    }

    public void setVoteOpenStr(String value) {
        try {
            Date parsedDate = DATE_FORMAT.parse(value);
            if (parsedDate != null) {
                this.voteOpen = parsedDate;
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getVoteOpenStr() {
        return DATE_FORMAT.format(this.voteOpen);
    }

    public void setVoteClose(Date value) {
        this.voteClose = value;
    }

    public Date getVoteClose() {
        return this.voteClose;
    }

    public void setVoteCloseStr(String value) {
        try {
            Date parsedDate = DATE_FORMAT.parse(value);
            if (parsedDate != null) {
                this.voteClose = parsedDate;
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getVoteCloseStr() {
        return DATE_FORMAT.format(this.voteClose);
    }

    public String getPollText() {
        return this.pollText;
    }

    public void setPollText(String pollText) {
        this.pollText = pollText;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isCurrentUserVoted() {
        return this.currentUserVoted;
    }

    public void setCurrentUserVoted(boolean currentUserVoted) {
        this.currentUserVoted = currentUserVoted;
    }

    public List<Vote> getCurrentUserVotes() {
        if (this.currentUserVotes == null) {
            return new ArrayList<Vote>();
        }
        return this.currentUserVotes;
    }

    public void setCurrentUserVotes(List<Vote> currentUserVotes) {
        this.currentUserVotes = currentUserVotes;
    }

    public void setDisplayResult(String value) {
        this.displayResult = value;
    }

    public String getDisplayResult() {
        return this.displayResult;
    }

    public void setVotes(List<Vote> value) {
        this.votes = value;
    }

    public List<Vote> getVotes() {
        return this.votes;
    }

    public void addVote(Vote vote) {
        this.votes.add(vote);
    }

    public void setOptions(List<Option> value) {
        this.options = value;
    }

    public List<Option> getPollOptions() {
        return this.options;
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    public void setLimitVoting(boolean value) {
        this.limitVoting = value;
    }

    public boolean getLimitVoting() {
        return this.limitVoting;
    }

    public void setDetails(String value) {
        this.description = value;
    }

    public String getDetails() {
        return this.description;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.id).append((Object)this.owner).append((Object)this.siteId).append((Object)this.creationDate).append((Object)this.pollText).toString();
    }

    public String getUrl() {
        return ServerConfigurationService.getAccessUrl() + "/poll/" + this.getId();
    }

    public String getReference() {
        return ServerConfigurationService.getAccessUrl() + "/poll/" + "/" + this.getId();
    }

    public String getUrl(String arg0) {
        return this.getUrl();
    }

    public String getReference(String arg0) {
        return this.getReference();
    }

    public String getId() {
        if (this.entityID == null) {
            this.entityID = this.id + "";
        }
        return this.entityID;
    }

    public void setId(String s) {
        this.entityID = s;
    }

    public boolean getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public ResourceProperties getProperties() {
        return null;
    }

    private static DateFormat getDateFormatForXML() {
        return DateFormat.getDateTimeInstance(3, 3);
    }

    public Element toXml(Document doc, Stack stack) {
        Element poll = doc.createElement("poll");
        if (stack.isEmpty()) {
            doc.appendChild(poll);
        } else {
            ((Element)stack.peek()).appendChild(poll);
        }
        stack.push(poll);
        poll.setAttribute(ID, this.getId());
        poll.setAttribute(POLL_ID, this.getPollId().toString());
        poll.setAttribute(POLL_TEXT, this.getText());
        poll.setAttribute(MIN_OPTIONS, new Integer(this.getMinOptions()).toString());
        poll.setAttribute(MAX_OPTIONS, new Integer(this.getMaxOptions()).toString());
        if (this.description != null) {
            poll.setAttribute(DESCRIPTION, this.description);
        }
        DateFormat dformat = Poll.getDateFormatForXML();
        poll.setAttribute(VOTE_OPEN, dformat.format(this.voteOpen));
        poll.setAttribute(VOTE_CLOSE, dformat.format(this.voteClose));
        poll.setAttribute(LIMIT_VOTING, Boolean.valueOf(this.limitVoting).toString());
        stack.pop();
        return poll;
    }

    public static Poll fromXML(Element element) {
        Poll poll = new Poll();
        poll.setId(element.getAttribute(ID));
        poll.setText(element.getAttribute(POLL_TEXT));
        poll.setDescription(element.getAttribute(DESCRIPTION));
        DateFormat dformat = Poll.getDateFormatForXML();
        if (!"".equals(element.getAttribute(VOTE_OPEN))) {
            try {
                poll.setVoteOpen(dformat.parse(element.getAttribute(VOTE_OPEN)));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (!"".equals(element.getAttribute(VOTE_CLOSE))) {
            try {
                poll.setVoteClose(dformat.parse(element.getAttribute(VOTE_CLOSE)));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (!"".equals(element.getAttribute(MIN_OPTIONS))) {
            try {
                poll.setMinOptions(Integer.parseInt(element.getAttribute(MIN_OPTIONS)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!"".equals(element.getAttribute(MAX_OPTIONS))) {
            try {
                poll.setMaxOptions(Integer.parseInt(element.getAttribute(MAX_OPTIONS)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        poll.setLimitVoting(Boolean.parseBoolean(element.getAttribute(LIMIT_VOTING)));
        return poll;
    }
}

