/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Vote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Poll
implements Entity {
    private static final Logger log = LoggerFactory.getLogger(Poll.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private Long pollId;
    private String owner;
    private String siteId;
    private Date creationDate;
    private String text = "";
    private String description = "";
    private int minOptions = 1;
    private int maxOptions = 1;
    private Date voteOpen = new Date();
    private Date voteClose;
    private List<Vote> votes;
    private String displayResult = "open";
    private Boolean limitVoting = true;
    private boolean currentUserVoted = false;
    private List<Option> options;
    private Boolean isPublic = false;
    private String id;
    private static final String ID = "id";
    private static final String POLL_ID = "pollid";
    private static final String POLL_TEXT = "title";
    private static final String DESCRIPTION = "description";
    private static final String VOTE_OPEN = "open-time";
    private static final String VOTE_CLOSE = "close-time";
    private static final String LIMIT_VOTING = "limit-voting";
    private static final String MIN_OPTIONS = "min-options";
    private static final String MAX_OPTIONS = "max-options";

    public Poll() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 7);
        this.voteClose = cal.getTime();
        this.displayResult = "open";
        this.options = new ArrayList<Option>();
        this.votes = new ArrayList<Vote>();
    }

    public void setVoteOpenStr(String value) {
        try {
            Date parsedDate = DATE_FORMAT.parse(value);
            if (parsedDate != null) {
                this.voteOpen = parsedDate;
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getVoteOpenStr() {
        return DATE_FORMAT.format(this.voteOpen);
    }

    public void setVoteCloseStr(String value) {
        try {
            Date parsedDate = DATE_FORMAT.parse(value);
            if (parsedDate != null) {
                this.voteClose = parsedDate;
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getVoteCloseStr() {
        return DATE_FORMAT.format(this.voteClose);
    }

    public void addVote(Vote vote) {
        this.votes.add(vote);
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    public void setDetails(String value) {
        this.description = value;
    }

    public String getDetails() {
        return this.description;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.id).append((Object)this.owner).append((Object)this.siteId).append((Object)this.creationDate).append((Object)this.text).toString();
    }

    public String getUrl() {
        return ServerConfigurationService.getAccessUrl() + "/poll/" + this.getId();
    }

    public String getReference() {
        return ServerConfigurationService.getAccessUrl() + "/poll/" + "/" + this.getId();
    }

    public String getUrl(String arg0) {
        return this.getUrl();
    }

    public String getReference(String arg0) {
        return this.getReference();
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.pollId + "";
        }
        return this.id;
    }

    public ResourceProperties getProperties() {
        return null;
    }

    private static DateFormat getDateFormatForXML() {
        return DateFormat.getDateTimeInstance(3, 3);
    }

    public Element toXml(Document doc, Stack stack) {
        Element poll = doc.createElement("poll");
        if (stack.isEmpty()) {
            doc.appendChild(poll);
        } else {
            ((Element)stack.peek()).appendChild(poll);
        }
        stack.push(poll);
        poll.setAttribute(ID, this.getId());
        poll.setAttribute(POLL_ID, this.getPollId().toString());
        poll.setAttribute(POLL_TEXT, this.getText());
        poll.setAttribute(MIN_OPTIONS, new Integer(this.getMinOptions()).toString());
        poll.setAttribute(MAX_OPTIONS, new Integer(this.getMaxOptions()).toString());
        if (this.description != null) {
            poll.setAttribute(DESCRIPTION, this.description);
        }
        DateFormat dformat = Poll.getDateFormatForXML();
        poll.setAttribute(VOTE_OPEN, dformat.format(this.voteOpen));
        poll.setAttribute(VOTE_CLOSE, dformat.format(this.voteClose));
        poll.setAttribute(LIMIT_VOTING, Boolean.valueOf(this.limitVoting).toString());
        stack.pop();
        return poll;
    }

    public static Poll fromXML(Element element) {
        Poll poll = new Poll();
        poll.setId(element.getAttribute(ID));
        poll.setText(element.getAttribute(POLL_TEXT));
        poll.setDetails(element.getAttribute(DESCRIPTION));
        DateFormat dformat = Poll.getDateFormatForXML();
        if (!"".equals(element.getAttribute(VOTE_OPEN))) {
            try {
                poll.setVoteOpen(dformat.parse(element.getAttribute(VOTE_OPEN)));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (!"".equals(element.getAttribute(VOTE_CLOSE))) {
            try {
                poll.setVoteClose(dformat.parse(element.getAttribute(VOTE_CLOSE)));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (!"".equals(element.getAttribute(MIN_OPTIONS))) {
            try {
                poll.setMinOptions(Integer.parseInt(element.getAttribute(MIN_OPTIONS)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!"".equals(element.getAttribute(MAX_OPTIONS))) {
            try {
                poll.setMaxOptions(Integer.parseInt(element.getAttribute(MAX_OPTIONS)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        poll.setLimitVoting(Boolean.parseBoolean(element.getAttribute(LIMIT_VOTING)));
        return poll;
    }

    public Long getPollId() {
        return this.pollId;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getText() {
        return this.text;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMinOptions() {
        return this.minOptions;
    }

    public int getMaxOptions() {
        return this.maxOptions;
    }

    public Date getVoteOpen() {
        return this.voteOpen;
    }

    public Date getVoteClose() {
        return this.voteClose;
    }

    public List<Vote> getVotes() {
        return this.votes;
    }

    public String getDisplayResult() {
        return this.displayResult;
    }

    public Boolean getLimitVoting() {
        return this.limitVoting;
    }

    public boolean isCurrentUserVoted() {
        return this.currentUserVoted;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public void setPollId(Long pollId) {
        this.pollId = pollId;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMinOptions(int minOptions) {
        this.minOptions = minOptions;
    }

    public void setMaxOptions(int maxOptions) {
        this.maxOptions = maxOptions;
    }

    public void setVoteOpen(Date voteOpen) {
        this.voteOpen = voteOpen;
    }

    public void setVoteClose(Date voteClose) {
        this.voteClose = voteClose;
    }

    public void setVotes(List<Vote> votes) {
        this.votes = votes;
    }

    public void setDisplayResult(String displayResult) {
        this.displayResult = displayResult;
    }

    public void setLimitVoting(Boolean limitVoting) {
        this.limitVoting = limitVoting;
    }

    public void setCurrentUserVoted(boolean currentUserVoted) {
        this.currentUserVoted = currentUserVoted;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public void setIsPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Poll)) {
            return false;
        }
        Poll other = (Poll)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$pollId = this.getPollId();
        Long other$pollId = other.getPollId();
        if (this$pollId == null ? other$pollId != null : !((Object)this$pollId).equals(other$pollId)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        Date this$creationDate = this.getCreationDate();
        Date other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (this.getMinOptions() != other.getMinOptions()) {
            return false;
        }
        if (this.getMaxOptions() != other.getMaxOptions()) {
            return false;
        }
        Date this$voteOpen = this.getVoteOpen();
        Date other$voteOpen = other.getVoteOpen();
        if (this$voteOpen == null ? other$voteOpen != null : !((Object)this$voteOpen).equals(other$voteOpen)) {
            return false;
        }
        Date this$voteClose = this.getVoteClose();
        Date other$voteClose = other.getVoteClose();
        if (this$voteClose == null ? other$voteClose != null : !((Object)this$voteClose).equals(other$voteClose)) {
            return false;
        }
        List<Vote> this$votes = this.getVotes();
        List<Vote> other$votes = other.getVotes();
        if (this$votes == null ? other$votes != null : !((Object)this$votes).equals(other$votes)) {
            return false;
        }
        String this$displayResult = this.getDisplayResult();
        String other$displayResult = other.getDisplayResult();
        if (this$displayResult == null ? other$displayResult != null : !this$displayResult.equals(other$displayResult)) {
            return false;
        }
        Boolean this$limitVoting = this.getLimitVoting();
        Boolean other$limitVoting = other.getLimitVoting();
        if (this$limitVoting == null ? other$limitVoting != null : !((Object)this$limitVoting).equals(other$limitVoting)) {
            return false;
        }
        if (this.isCurrentUserVoted() != other.isCurrentUserVoted()) {
            return false;
        }
        List<Option> this$options = this.getOptions();
        List<Option> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        Boolean this$isPublic = this.getIsPublic();
        Boolean other$isPublic = other.getIsPublic();
        if (this$isPublic == null ? other$isPublic != null : !((Object)this$isPublic).equals(other$isPublic)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Poll;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $pollId = this.getPollId();
        result = result * 59 + ($pollId == null ? 43 : ((Object)$pollId).hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        Date $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + this.getMinOptions();
        result = result * 59 + this.getMaxOptions();
        Date $voteOpen = this.getVoteOpen();
        result = result * 59 + ($voteOpen == null ? 43 : ((Object)$voteOpen).hashCode());
        Date $voteClose = this.getVoteClose();
        result = result * 59 + ($voteClose == null ? 43 : ((Object)$voteClose).hashCode());
        List<Vote> $votes = this.getVotes();
        result = result * 59 + ($votes == null ? 43 : ((Object)$votes).hashCode());
        String $displayResult = this.getDisplayResult();
        result = result * 59 + ($displayResult == null ? 43 : $displayResult.hashCode());
        Boolean $limitVoting = this.getLimitVoting();
        result = result * 59 + ($limitVoting == null ? 43 : ((Object)$limitVoting).hashCode());
        result = result * 59 + (this.isCurrentUserVoted() ? 79 : 97);
        List<Option> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        Boolean $isPublic = this.getIsPublic();
        result = result * 59 + ($isPublic == null ? 43 : ((Object)$isPublic).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

