/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.util;

import java.util.Stack;
import org.sakaiproject.poll.model.Option;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PollUtil {
    private static final String UUID = "id";
    private static final String OPTION_ID = "optionid";
    private static final String TEXT = "title";
    private static final String DELETED = "deleted";

    public static Element optionToXml(Option option, Document doc, Stack<Element> stack) {
        Element element = doc.createElement("option");
        if (stack.isEmpty()) {
            doc.appendChild(element);
        } else {
            stack.peek().appendChild(element);
        }
        stack.push(element);
        element.setAttribute(UUID, option.getUuid());
        element.setAttribute(OPTION_ID, option.getOptionId().toString());
        element.setAttribute(TEXT, option.getText());
        element.setAttribute(DELETED, option.getDeleted().toString());
        stack.pop();
        return element;
    }

    public static Option xmlToOption(Element element) {
        Option option = new Option();
        option.setUuid(element.getAttribute(UUID));
        if (!"".equals(element.getAttribute(OPTION_ID))) {
            try {
                option.setOptionId(Long.parseLong(element.getAttribute(OPTION_ID)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        option.setText(element.getAttribute(TEXT));
        option.setDeleted(Boolean.parseBoolean(element.getAttribute(DELETED)));
        return option;
    }
}

