/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.genericdao.api.search.Restriction;
import org.sakaiproject.genericdao.api.search.Search;
import org.sakaiproject.poll.dao.PollDao;
import org.sakaiproject.poll.logic.ExternalLogic;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.logic.PollVoteManager;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Poll;
import org.sakaiproject.poll.model.Vote;
import org.sakaiproject.poll.service.impl.PollListManagerImpl;

public class PollVoteManagerImpl
implements PollVoteManager {
    private static Log log = LogFactory.getLog(PollListManagerImpl.class);
    private ExternalLogic externalLogic;
    private PollDao dao;
    private PollListManager pollListManager;

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void setDao(PollDao dao) {
        this.dao = dao;
    }

    public void setPollListManager(PollListManager pollListManaver) {
        this.pollListManager = pollListManaver;
    }

    public void saveVoteList(List<Vote> votes) {
        Long pollId = null;
        for (int i = 0; i < votes.size(); ++i) {
            Vote vote = votes.get(i);
            pollId = vote.getPollId();
            this.saveVote(vote);
        }
        this.externalLogic.postEvent("poll.vote", "poll/site/" + this.externalLogic.getCurrentLocationReference() + "/poll/" + pollId, true);
    }

    public boolean saveVote(Vote vote) {
        this.dao.save(vote);
        log.debug((Object)(" Vote  " + vote.getId() + " successfuly saved"));
        return true;
    }

    public List<Vote> getAllVotesForPoll(Poll poll) {
        Search search = new Search();
        search.addRestriction(new Restriction("pollId", (Object)poll.getPollId()));
        List votes = this.dao.findBySearch(Vote.class, search);
        return votes;
    }

    public List<Vote> getAllVotesForOption(Option option) {
        Search search = new Search();
        search.addRestriction(new Restriction("pollId", (Object)option.getPollId()));
        search.addRestriction(new Restriction("pollOption", (Object)option.getOptionId()));
        List votes = this.dao.findBySearch(Vote.class, search);
        return votes;
    }

    public Map<Long, List<Vote>> getVotesForUser(String userId, Long[] pollIds) {
        if (userId == null) {
            throw new IllegalArgumentException("userId cannot be null");
        }
        Search search = new Search();
        search.addRestriction(new Restriction("userId", (Object)userId));
        if (pollIds != null) {
            if (pollIds.length > 0) {
                search.addRestriction(new Restriction("pollId", (Object)pollIds));
            } else {
                return new HashMap<Long, List<Vote>>();
            }
        }
        HashMap<Long, List<Vote>> map = new HashMap<Long, List<Vote>>();
        if (pollIds != null && pollIds.length > 0) {
            List votes = this.dao.findBySearch(Vote.class, search);
            for (Vote vote : votes) {
                Long pollId = vote.getPollId();
                if (!map.containsKey(pollId)) {
                    map.put(pollId, new ArrayList());
                }
                ((List)map.get(pollId)).add(vote);
            }
        }
        return map;
    }

    public int getDisctinctVotersForPoll(Poll poll) {
        return this.dao.getDisctinctVotersForPoll(poll);
    }

    public boolean userHasVoted(Long pollid, String userID) {
        Search search = new Search();
        search.addRestriction(new Restriction("userId", (Object)userID));
        search.addRestriction(new Restriction("pollId", (Object)pollid));
        List votes = this.dao.findBySearch(Vote.class, search);
        return votes.size() > 0;
    }

    public boolean userHasVoted(Long pollId) {
        return this.userHasVoted(pollId, this.externalLogic.getCurrentUserId());
    }

    public Vote getVoteById(Long voteId) {
        if (voteId == null) {
            throw new IllegalArgumentException("voteId cannot be null when getting vote");
        }
        Search search = new Search(new Restriction("id", (Object)voteId));
        Vote vote = (Vote)this.dao.findOneBySearch(Vote.class, search);
        return vote;
    }

    public boolean isUserAllowedVote(String userId, Long pollId, boolean ignoreVoted) {
        boolean allowed = false;
        Search search = new Search(new Restriction("pollId", (Object)pollId));
        Poll poll = (Poll)this.dao.findOneBySearch(Poll.class, search);
        if (poll == null) {
            throw new IllegalArgumentException("Invalid poll id (" + pollId + ") when checking user can vote");
        }
        if (this.externalLogic.isUserAdmin(userId)) {
            allowed = true;
        } else {
            String siteRef = "/site/" + poll.getSiteId();
            if (this.externalLogic.isAllowedInLocation("poll.vote", siteRef, "/user/" + userId)) {
                if (ignoreVoted) {
                    allowed = true;
                } else {
                    Map<Long, List<Vote>> m = this.getVotesForUser(userId, new Long[]{pollId});
                    if (m.isEmpty()) {
                        allowed = true;
                    }
                }
            }
        }
        return allowed;
    }

    public boolean pollIsVotable(Poll poll) {
        if (poll == null) {
            return false;
        }
        List votableOptions = this.pollListManager.getVisibleOptionsForPoll(poll.getPollId());
        if (votableOptions == null || votableOptions.size() == 0) {
            log.debug((Object)"poll has no options");
            return false;
        }
        boolean pollAfterOpen = true;
        boolean pollBeforeClose = true;
        if (poll.getVoteClose() != null && poll.getVoteClose().before(new Date())) {
            log.debug((Object)"Poll is closed for voting");
            pollBeforeClose = false;
        }
        if (poll.getVoteOpen() != null && new Date().before(poll.getVoteOpen())) {
            log.debug((Object)"Poll is not open yet");
            pollAfterOpen = false;
        }
        if (pollAfterOpen && pollBeforeClose) {
            if (poll.getLimitVoting() && this.userHasVoted(poll.getPollId())) {
                return false;
            }
            log.debug((Object)("about to check if this user can vote in " + poll.getSiteId()));
            if (this.externalLogic.isAllowedInLocation("poll.vote", this.externalLogic.getSiteRefFromId(poll.getSiteId())) || this.externalLogic.isUserAdmin()) {
                log.debug((Object)("this poll is votable because the user has permissions, " + poll.getText()));
                return true;
            }
            if (poll.getIsPublic()) {
                log.debug((Object)("this poll is votable because it is public, " + poll.getText()));
                return true;
            }
        }
        return false;
    }

    public void deleteVote(Vote vote) {
        this.dao.delete(vote);
    }
}

