/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.logic.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.AuthzPermissionException;
import org.sakaiproject.authz.api.FunctionManager;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.emailtemplateservice.model.RenderedTemplate;
import org.sakaiproject.emailtemplateservice.service.EmailTemplateService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.event.api.LearningResourceStoreService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.poll.logic.ExternalLogic;
import org.sakaiproject.poll.model.PollRolePerms;
import org.sakaiproject.poll.model.Vote;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalLogicImpl
implements ExternalLogic {
    private static Logger log = LoggerFactory.getLogger(ExternalLogicImpl.class);
    private static final String EMAIL_TEMPLATE_NOTIFY_DELETED_OPTION = "polls.notifyDeletedOption";
    private static final String FILE_NOTIFY_DELETED_OPTION_TEMPLATE = "org/sakaiproject/poll/templates/notifyDeletedOption.xml";
    private static final String USER_ADMIN_ID = "admin";
    private static final String USER_ADMIN_EID = "admin";
    private static final String USER_ENTITY_PREFIX = "/user/";
    private DeveloperHelperService developerHelperService;
    private AuthzGroupService authzGroupService;
    private EntityManager entityManager;
    private EmailService emailService;
    private EmailTemplateService emailTemplateService;
    private ArrayList<String> emailTemplates;
    private EventTrackingService eventTrackingService;
    private FunctionManager functionManager;
    private TimeService timeService;
    private SiteService siteService;
    private SecurityService securityService;
    private ServerConfigurationService serverConfigurationService;
    private SessionManager sessionManager;
    private UserDirectoryService userDirectoryService;
    private String fromEmailAddress;
    private String replyToEmailAddress;
    private static final String SAKAI_SITE_TYPE = "site";

    public void setDeveloperHelperService(DeveloperHelperService developerHelperService) {
        this.developerHelperService = developerHelperService;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public void setEntityManager(EntityManager em) {
        this.entityManager = em;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    public void setEmailTemplates(ArrayList<String> emailTemplates) {
        this.emailTemplates = emailTemplates;
    }

    public void setEventTrackingService(EventTrackingService ets) {
        this.eventTrackingService = ets;
    }

    public void setFunctionManager(FunctionManager fm) {
        this.functionManager = fm;
    }

    public void setTimeService(TimeService ts) {
        this.timeService = ts;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setFromEmailAddress(String fromEmailAddress) {
        this.fromEmailAddress = fromEmailAddress;
    }

    public void setReplyToEmailAddress(String replyToEmailAddress) {
        this.replyToEmailAddress = replyToEmailAddress;
    }

    public String getCurrentLocationId() {
        return this.developerHelperService.getCurrentLocationId();
    }

    public boolean isUserAdmin(String userId) {
        return this.developerHelperService.isUserAdmin(USER_ENTITY_PREFIX + userId);
    }

    public boolean isUserAdmin() {
        return this.isUserAdmin(this.getCurrentUserId());
    }

    public String getCurrentUserId() {
        return this.developerHelperService.getCurrentUserId();
    }

    public String getCurrentuserReference() {
        return this.developerHelperService.getCurrentUserReference();
    }

    public String getUserEidFromId(String userId) {
        try {
            return this.userDirectoryService.getUserEid(userId);
        }
        catch (UserNotDefinedException e) {
            log.debug("Looked up non-existant user id: " + userId, (Throwable)e);
            return null;
        }
    }

    public String getCurrentLocationReference() {
        log.debug("getCurrentLocationReference");
        return this.developerHelperService.getCurrentLocationReference();
    }

    public boolean isAllowedInLocation(String permission, String locationReference, String userReference) {
        log.debug("isAllowed in location( " + permission + " , " + locationReference + " , " + userReference);
        return this.developerHelperService.isUserAllowedInEntityReference(userReference, permission, locationReference);
    }

    public boolean isAllowedInLocation(String permission, String locationReference) {
        log.debug("isAllowed in location( " + permission + " , " + locationReference);
        return this.isAllowedInLocation(permission, locationReference, this.developerHelperService.getCurrentUserReference());
    }

    public void init() {
        log.info("init()");
        this.emailTemplateService.processEmailTemplates(this.emailTemplates);
    }

    public List<String> getSitesForUser(String userId, String permission) {
        log.debug("userId: " + userId + ", permission: " + permission);
        ArrayList<String> l = new ArrayList<String>();
        Set authzGroupIds = this.authzGroupService.getAuthzGroupsIsAllowed(userId, permission, null);
        for (String authzGroupId : authzGroupIds) {
            String type;
            Reference r = this.entityManager.newReference(authzGroupId);
            if (!r.isKnownType() || !r.getType().equals("sakai:site") || !SAKAI_SITE_TYPE.equals(type = r.getSubType())) continue;
            String siteId = r.getId();
            l.add(siteId);
        }
        if (l.isEmpty()) {
            log.info("Empty list of siteIds for user:" + userId + ", permission: " + permission);
        }
        return l;
    }

    public void postEvent(String eventId, String reference, boolean modify) {
        this.eventTrackingService.post(this.eventTrackingService.newEvent(eventId, reference, modify));
    }

    public void registerFunction(String function) {
        this.functionManager.registerFunction(function);
    }

    public TimeZone getLocalTimeZone() {
        return this.timeService.getLocalTimeZone();
    }

    public List<String> getRoleIdsInRealm(String realmId) {
        try {
            AuthzGroup group = this.authzGroupService.getAuthzGroup(realmId);
            ArrayList<String> ret = new ArrayList<String>();
            Set roles = group.getRoles();
            for (Role role : roles) {
                ret.add(role.getId());
            }
            return ret;
        }
        catch (GroupNotDefinedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isRoleAllowedInRealm(String roleId, String realmId, String permission) {
        try {
            AuthzGroup group = this.authzGroupService.getAuthzGroup(realmId);
            Role role = group.getRole(roleId);
            return role.isAllowed(permission);
        }
        catch (GroupNotDefinedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getSiteTile(String siteId) {
        try {
            Site site = this.siteService.getSite(siteId);
            return site.getTitle();
        }
        catch (IdUnusedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setToolPermissions(Map<String, PollRolePerms> permMap, String locationReference) throws SecurityException, IllegalArgumentException {
        AuthzGroup authz = null;
        try {
            authz = this.authzGroupService.getAuthzGroup(locationReference);
        }
        catch (GroupNotDefinedException e) {
            throw new IllegalArgumentException(e);
        }
        Set<Map.Entry<String, PollRolePerms>> entrySet = permMap.entrySet();
        for (Map.Entry<String, PollRolePerms> entry : entrySet) {
            String key = entry.getKey();
            Role role = authz.getRole(key);
            PollRolePerms rp = entry.getValue();
            if (rp.add != null) {
                this.setFunc(role, "poll.add", rp.add);
            }
            if (rp.deleteAny != null) {
                this.setFunc(role, "poll.deleteAny", rp.deleteAny);
            }
            if (rp.deleteOwn != null) {
                this.setFunc(role, "poll.deleteOwn", rp.deleteOwn);
            }
            if (rp.editAny != null) {
                this.setFunc(role, "poll.editAny", rp.editAny);
            }
            if (rp.editOwn != null) {
                this.setFunc(role, "poll.editOwn", rp.editOwn);
            }
            if (rp.vote != null) {
                this.setFunc(role, "poll.vote", rp.vote);
            }
            log.info(" Key: " + key + " Vote: " + rp.vote + " New: " + rp.add);
        }
        try {
            this.authzGroupService.save(authz);
        }
        catch (GroupNotDefinedException e) {
            throw new IllegalArgumentException(e);
        }
        catch (AuthzPermissionException e) {
            throw new SecurityException(e);
        }
    }

    public Map<String, PollRolePerms> getRoles(String locationReference) {
        log.debug("Getting permRoles");
        HashMap<String, PollRolePerms> perms = new HashMap<String, PollRolePerms>();
        try {
            AuthzGroup group = this.authzGroupService.getAuthzGroup(locationReference);
            Set roles = group.getRoles();
            for (Role role : roles) {
                String name = role.getId();
                log.debug("Adding element for " + name);
                perms.put(name, new PollRolePerms(name, role.isAllowed("poll.vote"), role.isAllowed("poll.add"), role.isAllowed("poll.deleteOwn"), role.isAllowed("poll.deleteAny"), role.isAllowed("poll.editOwn"), role.isAllowed("poll.editAny")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return perms;
    }

    private void setFunc(Role role, String function, Boolean allow) {
        if (allow.booleanValue()) {
            role.allowFunction(function);
        } else {
            role.disallowFunction(function);
        }
    }

    public String getSiteRefFromId(String siteId) {
        return this.siteService.siteReference(siteId);
    }

    public boolean userIsViewingAsRole() {
        String effectiveRole = this.securityService.getUserEffectiveRole(this.developerHelperService.getCurrentLocationReference());
        return effectiveRole != null;
    }

    public void notifyDeletedOption(List<String> userEids, String siteTitle, String pollQuestion) {
        if (siteTitle == null) {
            throw new IllegalArgumentException("Site title cannot be null");
        }
        if (pollQuestion == null) {
            throw new IllegalArgumentException("Poll Question cannot be null");
        }
        HashMap<String, Object> replacementValues = new HashMap<String, Object>();
        String from = this.fromEmailAddress == null || this.fromEmailAddress.equals("") ? this.serverConfigurationService.getString("setup.request", "no-reply@" + this.serverConfigurationService.getServerName()) : this.fromEmailAddress;
        for (String userEid : userEids) {
            User user = null;
            try {
                user = this.userDirectoryService.getUserByEid(userEid);
                replacementValues.put("localSakaiName", this.developerHelperService.getConfigurationSetting("ui.service", (Object)"Sakai"));
                replacementValues.put("recipientFirstName", user.getFirstName());
                replacementValues.put("recipientDisplayName", user.getDisplayName());
                replacementValues.put("pollQuestion", pollQuestion);
                replacementValues.put("siteTitle", siteTitle);
                RenderedTemplate template = this.emailTemplateService.getRenderedTemplateForUser(EMAIL_TEMPLATE_NOTIFY_DELETED_OPTION, user.getReference(), replacementValues);
                if (template == null) {
                    return;
                }
                String content = template.getRenderedMessage();
                String subject = template.getRenderedSubject();
                this.emailService.send(from, user.getEmail(), subject, content, user.getEmail(), from, null);
            }
            catch (UserNotDefinedException e) {
                log.warn("Attempted to send email to unknown user (eid): '" + userEid + "'", (Throwable)e);
            }
        }
    }

    public ToolSession getCurrentToolSession() {
        return this.sessionManager.getCurrentToolSession();
    }

    public boolean isResultsChartEnabled() {
        return this.serverConfigurationService.getBoolean("poll.results.chart.enabled", false);
    }

    public boolean isShowPublicAccess() {
        return this.serverConfigurationService.getBoolean("poll.allow.public.access", false);
    }

    public boolean isMobileBrowser() {
        Session session = this.sessionManager.getCurrentSession();
        return session.getAttribute("is_wireless_device") != null && (Boolean)session.getAttribute("is_wireless_device") != false;
    }

    public List<String> getPermissionKeys() {
        String[] perms = new String[]{"poll.vote", "poll.add", "poll.editOwn", "poll.editAny", "poll.deleteOwn", "poll.deleteAny"};
        List<String> ret = Arrays.asList(perms);
        return ret;
    }

    private LearningResourceStoreService.LRS_Statement getStatementForUserVotedInPoll(LearningResourceStoreService.LRS_Actor student, String text, Vote vote) {
        String url = this.serverConfigurationService.getPortalUrl();
        LearningResourceStoreService.LRS_Verb verb = new LearningResourceStoreService.LRS_Verb(LearningResourceStoreService.LRS_Verb.SAKAI_VERB.interacted);
        LearningResourceStoreService.LRS_Object lrsObject = new LearningResourceStoreService.LRS_Object(url + "/poll", "voted-in-poll");
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("en-US", "User voted in a poll");
        lrsObject.setActivityName(nameMap);
        HashMap<String, String> descMap = new HashMap<String, String>();
        descMap.put("en-US", "User voted in a poll with text:" + text + "; their vote was option: " + vote.getPollOption());
        lrsObject.setDescription(descMap);
        return new LearningResourceStoreService.LRS_Statement(student, verb, lrsObject);
    }

    private LearningResourceStoreService.LRS_Statement getStatementForUserEditPoll(LearningResourceStoreService.LRS_Actor student, String text, boolean newPoll) {
        String url = this.serverConfigurationService.getPortalUrl();
        LearningResourceStoreService.LRS_Verb verb = new LearningResourceStoreService.LRS_Verb(LearningResourceStoreService.LRS_Verb.SAKAI_VERB.interacted);
        LearningResourceStoreService.LRS_Object lrsObject = new LearningResourceStoreService.LRS_Object(url + "/poll", newPoll ? "new-poll" : "updated-poll");
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("en-US", "User " + (newPoll ? "created" : "updated") + " a poll");
        lrsObject.setActivityName(nameMap);
        HashMap<String, String> descMap = new HashMap<String, String>();
        descMap.put("en-US", "User " + (newPoll ? "created" : "updated") + " a poll with text:" + text);
        lrsObject.setDescription(descMap);
        return new LearningResourceStoreService.LRS_Statement(student, verb, lrsObject);
    }

    public void registerStatement(String pollText, Vote vote) {
        LearningResourceStoreService lrss = (LearningResourceStoreService)ComponentManager.get((String)"org.sakaiproject.event.api.LearningResourceStoreService");
        if (null != lrss) {
            Event event = this.eventTrackingService.newEvent("poll", "vote", true);
            lrss.registerStatement(this.getStatementForUserVotedInPoll(lrss.getEventActor(event), pollText, vote), "polls");
        }
    }

    public void registerStatement(String pollText, boolean newPoll) {
        LearningResourceStoreService lrss = (LearningResourceStoreService)ComponentManager.get((String)"org.sakaiproject.event.api.LearningResourceStoreService");
        if (null != lrss) {
            Event event = this.eventTrackingService.newEvent("poll", "edit poll", true);
            lrss.registerStatement(this.getStatementForUserEditPoll(lrss.getEventActor(event), pollText, newPoll), "polls");
        }
    }
}

