/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.Vector;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.EntityTransferrer;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.genericdao.api.search.Order;
import org.sakaiproject.genericdao.api.search.Restriction;
import org.sakaiproject.genericdao.api.search.Search;
import org.sakaiproject.id.api.IdManager;
import org.sakaiproject.poll.dao.PollDao;
import org.sakaiproject.poll.logic.ExternalLogic;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.logic.PollVoteManager;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Poll;
import org.sakaiproject.poll.model.Vote;
import org.sakaiproject.poll.util.PollUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PollListManagerImpl
implements PollListManager,
EntityTransferrer {
    private static Logger log = LoggerFactory.getLogger(PollListManagerImpl.class);
    public static final String REFERENCE_ROOT = "/poll";
    private EntityManager entityManager;
    private IdManager idManager;
    private PollDao dao;
    private PollVoteManager pollVoteManager;
    private ExternalLogic externalLogic;

    public void setEntityManager(EntityManager em) {
        this.entityManager = em;
    }

    public void setIdManager(IdManager idm) {
        this.idManager = idm;
    }

    public void setDao(PollDao dao) {
        this.dao = dao;
    }

    public void setPollVoteManager(PollVoteManager pollVoteManager) {
        this.pollVoteManager = pollVoteManager;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void init() {
        try {
            this.entityManager.registerEntityProducer((EntityProducer)this, REFERENCE_ROOT);
        }
        catch (Exception t) {
            log.warn("init(): ", (Throwable)t);
        }
        this.externalLogic.registerFunction("poll.vote");
        this.externalLogic.registerFunction("poll.add");
        this.externalLogic.registerFunction("poll.deleteOwn");
        this.externalLogic.registerFunction("poll.deleteAny");
        this.externalLogic.registerFunction("poll.editAny");
        this.externalLogic.registerFunction("poll.editOwn");
        log.info(this + " init()");
    }

    public void destroy() {
    }

    public List<Poll> findAllPollsForUserAndSitesAndPermission(String userId, String[] siteIds, String permissionConstant) {
        if (userId == null || permissionConstant == null) {
            throw new IllegalArgumentException("userId and permissionConstant must be set");
        }
        List polls = null;
        List allowedSites = this.externalLogic.getSitesForUser(userId, permissionConstant);
        if (siteIds != null && siteIds.length > 0 && !allowedSites.isEmpty()) {
            List<String> requestedSiteIds = Arrays.asList(siteIds);
            allowedSites.retainAll(requestedSiteIds);
            if (allowedSites.isEmpty()) {
                return new ArrayList<Poll>();
            }
            String[] siteIdsToSearch = allowedSites.toArray(new String[allowedSites.size()]);
            Search search = new Search();
            if (siteIdsToSearch.length > 0) {
                search.addRestriction(new Restriction("siteId", (Object)siteIdsToSearch));
            }
            if ("poll.vote".equals(permissionConstant)) {
                Date now = new Date();
                search.addRestriction(new Restriction("voteOpen", (Object)now, 2));
                search.addRestriction(new Restriction("voteClose", (Object)now, 1));
            }
            search.addOrder(new Order("creationDate"));
            polls = this.dao.findBySearch(Poll.class, search);
        }
        if (polls == null) {
            polls = new ArrayList();
        }
        return polls;
    }

    public boolean savePoll(Poll t) throws SecurityException, IllegalArgumentException {
        boolean newPoll = false;
        if (t == null || t.getText() == null || t.getSiteId() == null || t.getVoteOpen() == null || t.getVoteClose() == null) {
            throw new IllegalArgumentException("you must supply a question, siteId & open and close dates");
        }
        if (!this.externalLogic.isUserAdmin() && !this.externalLogic.isAllowedInLocation("poll.add", this.externalLogic.getSiteRefFromId(t.getSiteId()), this.externalLogic.getCurrentuserReference())) {
            throw new SecurityException();
        }
        if (t.getId() == null) {
            newPoll = true;
            t.setId(this.idManager.createUuid());
        }
        try {
            this.dao.save(t);
        }
        catch (DataAccessException e) {
            log.error("Hibernate could not save: " + e.toString());
            e.printStackTrace();
            return false;
        }
        log.debug(" Poll  " + t.toString() + "successfuly saved");
        this.externalLogic.registerStatement(t.getText(), newPoll);
        if (newPoll) {
            this.externalLogic.postEvent("poll.add", "poll/site/" + t.getSiteId() + "/poll/" + t.getId(), true);
        } else {
            this.externalLogic.postEvent("poll.update", "poll/site/" + t.getSiteId() + " /poll/" + t.getId(), true);
        }
        return true;
    }

    public boolean deletePoll(Poll t) throws SecurityException, IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("Poll can't be null");
        }
        if (t.getPollId() == null) {
            throw new IllegalArgumentException("Poll id can't be null");
        }
        if (!this.pollCanDelete(t)) {
            throw new SecurityException("user:" + this.externalLogic.getCurrentuserReference() + " can't delete poll: " + t.getId());
        }
        List vote = t.getVotes();
        if (vote == null || vote.isEmpty()) {
            log.debug("getting votes as they where null");
            vote = this.pollVoteManager.getAllVotesForPoll(t);
            log.debug("got " + vote.size() + " vote");
        }
        HashSet voteSet = new HashSet(vote);
        this.dao.deleteSet(voteSet);
        List<Option> options = t.getPollOptions();
        if (options == null || options.isEmpty()) {
            options = this.getOptionsForPoll(t);
        }
        HashSet<Option> optionSet = new HashSet<Option>(options);
        this.dao.deleteSet(optionSet);
        this.dao.delete(t);
        log.info("Poll id " + t.getId() + " deleted");
        this.externalLogic.postEvent("poll.delete", "poll/site/" + t.getSiteId() + "/poll/" + t.getId(), true);
        return true;
    }

    public boolean userCanDeletePoll(Poll poll) {
        if (this.externalLogic.isUserAdmin()) {
            return true;
        }
        if (this.externalLogic.isAllowedInLocation("poll.deleteAny", this.externalLogic.getCurrentLocationReference())) {
            return true;
        }
        return this.externalLogic.isAllowedInLocation("poll.deleteOwn", this.externalLogic.getCurrentLocationReference()) && poll.getOwner().equals(this.externalLogic.getCurrentUserId());
    }

    public List<Poll> findAllPolls(String siteId) {
        Search search = new Search();
        search.addOrder(new Order("creationDate", false));
        search.addRestriction(new Restriction("siteId", (Object)siteId));
        List polls = this.dao.findBySearch(Poll.class, search);
        return polls;
    }

    public Poll getPollById(Long pollId) throws SecurityException {
        return this.getPollById(pollId, true);
    }

    public Poll getPollById(Long pollId, boolean includeOptions) throws SecurityException {
        Search search = new Search();
        search.addRestriction(new Restriction("pollId", (Object)pollId));
        Poll poll = (Poll)this.dao.findOneBySearch(Poll.class, search);
        if (poll != null && includeOptions) {
            List<Option> optionList = this.getOptionsForPoll(poll);
            poll.setOptions(optionList);
        }
        if (poll == null) {
            return null;
        }
        if (!this.externalLogic.isAllowedInLocation("site.visit", this.externalLogic.getSiteRefFromId(poll.getSiteId()), this.externalLogic.getCurrentuserReference()) && !this.externalLogic.isUserAdmin()) {
            throw new SecurityException("user:" + this.externalLogic.getCurrentuserReference() + " can't read poll " + pollId);
        }
        return poll;
    }

    public List<Option> getOptionsForPoll(Poll poll) {
        return this.getOptionsForPoll(poll.getPollId());
    }

    public List<Option> getOptionsForPoll(Long pollId) {
        Poll poll;
        try {
            poll = this.getPollById(pollId, false);
        }
        catch (SecurityException e) {
            throw new SecurityException(e);
        }
        if (poll == null) {
            throw new IllegalArgumentException("Cannot get options for a poll (" + pollId + ") that does not exist");
        }
        Search search = new Search();
        search.addRestriction(new Restriction("pollId", (Object)pollId));
        search.addOrder(new Order("optionId"));
        List optionList = this.dao.findBySearch(Option.class, search);
        return optionList;
    }

    public List<Option> getVisibleOptionsForPoll(Long pollId) {
        List<Option> options = this.getOptionsForPoll(pollId);
        ListIterator<Option> i = options.listIterator();
        while (i.hasNext()) {
            Option o = (Option)i.next();
            if (o != null && !o.getDeleted().booleanValue()) continue;
            i.remove();
        }
        return options;
    }

    public Poll getPollWithVotes(Long pollId) {
        Search search = new Search();
        search.addRestriction(new Restriction("pollId", (Object)pollId));
        return (Poll)this.dao.findOneBySearch(Poll.class, search);
    }

    public Option getOptionById(Long optionId) {
        Search search = new Search();
        search.addRestriction(new Restriction("optionId", (Object)optionId));
        Option option = (Option)this.dao.findOneBySearch(Option.class, search);
        if (option != null && option.getUUId() == null) {
            option.setUUId(UUID.randomUUID().toString());
            this.saveOption(option);
        }
        return option;
    }

    public void deleteOption(Option option) {
        try {
            this.dao.delete(option);
        }
        catch (DataAccessException e) {
            log.error("Hibernate could not delete: " + e.toString());
            e.printStackTrace();
            return;
        }
        log.info("Option id " + option.getId() + " deleted");
    }

    public void deleteOption(Option option, boolean soft) {
        if (!soft) {
            this.deleteOption(option);
            return;
        }
        try {
            option.setDeleted(Boolean.TRUE);
            this.dao.save(option);
            log.info("Option id " + option.getId() + " soft deleted.");
        }
        catch (DataAccessException e) {
            log.error("Hibernate could not soft delete delete!", (Throwable)e);
            return;
        }
    }

    public boolean saveOption(Option t) {
        if (t.getUUId() == null || t.getUUId().trim().length() == 0) {
            t.setUUId(UUID.randomUUID().toString());
        }
        try {
            this.dao.save(t);
        }
        catch (DataAccessException e) {
            log.error("Hibernate could not save: " + e.toString());
            e.printStackTrace();
            return false;
        }
        log.info("Option  " + t.toString() + "successfuly saved");
        return true;
    }

    private boolean pollCanDelete(Poll poll) {
        if (this.externalLogic.isUserAdmin() || this.isSiteOwner(poll.getSiteId())) {
            return true;
        }
        if (this.externalLogic.isAllowedInLocation("poll.deleteAny", this.externalLogic.getSiteRefFromId(poll.getSiteId()))) {
            return true;
        }
        return this.externalLogic.isAllowedInLocation("poll.deleteOwn", this.externalLogic.getSiteRefFromId(poll.getSiteId())) && poll.getOwner().equals(this.externalLogic.getCurrentUserId());
    }

    private boolean isSiteOwner(String siteId) {
        if (this.externalLogic.isUserAdmin()) {
            return true;
        }
        return this.externalLogic.isAllowedInLocation("site.upd", this.externalLogic.getSiteRefFromId(siteId));
    }

    public String getLabel() {
        return "poll";
    }

    public boolean willArchiveMerge() {
        return true;
    }

    public String archive(String siteId, Document doc, Stack stack, String archivePath, List attachments) {
        log.debug("archive: poll " + siteId);
        StringBuilder results = new StringBuilder();
        results.append("archiving " + this.getLabel() + " context " + "/" + siteId + "/" + "main" + ".\n");
        Element element = doc.createElement(PollListManager.class.getName());
        ((Element)stack.peek()).appendChild(element);
        stack.push(element);
        List<Poll> pollsList = this.findAllPolls(siteId);
        log.debug("got list of " + pollsList.size() + " polls");
        for (int i = 0; pollsList.size() > i; ++i) {
            try {
                Poll poll = pollsList.get(i);
                log.info("got poll " + poll.getId());
                Element el = poll.toXml(doc, stack);
                List<Option> options = this.getVisibleOptionsForPoll(poll.getPollId());
                for (int q = 0; options.size() > q; ++q) {
                    Option opt = options.get(q);
                    Element el2 = PollUtil.optionToXml((Option)opt, (Document)doc, (Stack)stack);
                    el.appendChild(el2);
                }
                element.appendChild(el);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stack.pop();
        return results.toString();
    }

    public String merge(String siteId, Element root, String archivePath, String fromSiteId, Map<String, String> attachmentNames, Map<String, String> userIdTrans, Set<String> userListAllowImport) {
        NodeList polls = root.getElementsByTagName("poll");
        for (int i = 0; i < polls.getLength(); ++i) {
            Element pollElement = (Element)polls.item(i);
            Poll poll = Poll.fromXML((Element)pollElement);
            poll.setSiteId(siteId);
            this.savePoll(poll);
            NodeList options = pollElement.getElementsByTagName("option");
            for (int j = 0; j < options.getLength(); ++j) {
                Element optionElement = (Element)options.item(j);
                Option option = PollUtil.xmlToOption((Element)optionElement);
                option.setPollId(poll.getPollId());
                this.saveOption(option);
            }
        }
        return null;
    }

    public boolean parseEntityReference(String reference, Reference ref) {
        if (reference.startsWith(REFERENCE_ROOT)) {
            String[] parts = this.split(reference, "/");
            String subType = "";
            String context = null;
            String id = null;
            String container = "";
            if (parts.length > 2) {
                context = parts[2];
                if (parts.length > 3) {
                    id = parts[3];
                }
            }
            ref.set(PollListManager.class.getName(), subType, id, container, context);
            return true;
        }
        return false;
    }

    public String getEntityDescription(Reference arg0) {
        return null;
    }

    public ResourceProperties getEntityResourceProperties(Reference arg0) {
        return null;
    }

    public Entity getEntity(Reference ref) {
        Poll rv = null;
        if ("poll".equals(ref.getSubType())) {
            rv = this.getPoll(ref.getReference());
        }
        return rv;
    }

    public String getEntityUrl(Reference arg0) {
        return null;
    }

    public Collection getEntityAuthzGroups(Reference arg0, String arg1) {
        return null;
    }

    public HttpAccess getHttpAccess() {
        return null;
    }

    public String[] myToolIds() {
        String[] toolIds = new String[]{"sakai.poll"};
        return toolIds;
    }

    public void transferCopyEntities(String fromContext, String toContext, List resourceIds, boolean condition) {
        this.transferCopyEntities(fromContext, toContext, resourceIds);
    }

    public void transferCopyEntities(String fromContext, String toContext, List resourceIds) {
        try {
            for (Poll fromPoll : this.findAllPolls(fromContext)) {
                List votes;
                Poll fromPollV = this.getPollWithVotes(fromPoll.getPollId());
                Poll toPoll = new Poll();
                toPoll.setOwner(fromPollV.getOwner());
                toPoll.setSiteId(toContext);
                toPoll.setCreationDate(fromPollV.getCreationDate());
                toPoll.setText(fromPollV.getText());
                toPoll.setMinOptions(fromPollV.getMinOptions());
                toPoll.setMaxOptions(fromPollV.getMaxOptions());
                toPoll.setVoteOpen(fromPollV.getVoteOpen());
                toPoll.setVoteClose(fromPollV.getVoteClose());
                toPoll.setDisplayResult(fromPollV.getDisplayResult());
                toPoll.setLimitVoting(fromPollV.getLimitVoting());
                toPoll.setDetails(fromPollV.getDetails());
                this.savePoll(toPoll);
                List<Option> options = this.getOptionsForPoll(fromPoll);
                if (options != null) {
                    for (Option fromOption : options) {
                        Option toOption = new Option();
                        toOption.setOptionText(fromOption.getOptionText());
                        toOption.setStatus(fromOption.getStatus());
                        toOption.setPollId(toPoll.getPollId());
                        toOption.setDeleted(fromOption.getDeleted());
                        this.saveOption(toOption);
                        toPoll.addOption(toOption);
                    }
                }
                if ((votes = fromPollV.getVotes()) != null) {
                    Iterator fromVotes = votes.iterator();
                    while (fromVotes.hasNext()) {
                        toPoll.addVote((Vote)fromVotes.next());
                    }
                }
                this.savePoll(toPoll);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String[] split(String source, String splitter) {
        Vector<String> rv = new Vector<String>();
        int last = 0;
        int next = 0;
        do {
            if ((next = source.indexOf(splitter, last)) == -1) continue;
            rv.add(source.substring(last, next));
            last = next + splitter.length();
        } while (next != -1);
        if (last < source.length()) {
            rv.add(source.substring(last, source.length()));
        }
        return rv.toArray(new String[rv.size()]);
    }

    public Poll getPoll(String ref) {
        Search search = new Search();
        search.addRestriction(new Restriction("id", (Object)ref));
        Poll poll = (Poll)this.dao.findOneBySearch(Poll.class, search);
        if (poll.getId() == null) {
            poll.setId(this.idManager.createUuid());
            this.savePoll(poll);
        }
        return poll;
    }

    public boolean isAllowedViewResults(Poll poll, String userId) {
        if (this.externalLogic.isUserAdmin()) {
            return true;
        }
        if (poll.getDisplayResult().equals("open")) {
            return true;
        }
        if (poll.getDisplayResult().equals("afterVoting")) {
            Search search = new Search();
            search.addRestriction(new Restriction("pollId", (Object)poll.getPollId()));
            search.addRestriction(new Restriction("userId", (Object)userId));
            List votes = this.dao.findBySearch(Vote.class, search);
            if (votes.size() > 0) {
                return true;
            }
        }
        if ((poll.getDisplayResult().equals("afterClosing") || poll.getDisplayResult().equals("afterVoting")) && poll.getVoteClose().before(new Date())) {
            return true;
        }
        return poll.getOwner().equals(userId) && !this.externalLogic.userIsViewingAsRole();
    }

    public boolean isPollPublic(Poll poll) {
        if (poll.getIsPublic()) {
            return true;
        }
        return this.externalLogic.isAllowedInLocation("poll.vote", this.externalLogic.getSiteRefFromId(poll.getSiteId()));
    }
}

