/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.params;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.poll.model.PollRolePerms;
import org.sakaiproject.tool.cover.ToolManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleFactory {
    private static final Log LOG = LogFactory.getLog(RoleFactory.class);

    public Map<String, PollRolePerms> getRoles() {
        LOG.debug((Object)"Getting permRoles");
        HashMap<String, PollRolePerms> perms = new HashMap<String, PollRolePerms>();
        try {
            AuthzGroup group = AuthzGroupService.getAuthzGroup((String)("/site/" + ToolManager.getCurrentPlacement().getContext()));
            Set roles = group.getRoles();
            for (Role role : roles) {
                String name = role.getId();
                LOG.debug((Object)("Adding element for " + name));
                perms.put(name, new PollRolePerms(name, role.isAllowed("poll.vote"), role.isAllowed("poll.add"), role.isAllowed("poll.deleteOwn"), role.isAllowed("poll.deleteAny"), role.isAllowed("poll.editOwn"), role.isAllowed("poll.editAny")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return perms;
    }
}

