/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.producers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.poll.logic.ExternalLogic;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.logic.PollVoteManager;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Poll;
import org.sakaiproject.poll.model.VoteCollection;
import org.sakaiproject.poll.tool.params.PollViewParameters;
import org.sakaiproject.poll.tool.params.VoteCollectionViewParameters;
import uk.org.ponder.messageutil.MessageLocator;
import uk.org.ponder.messageutil.TargettedMessage;
import uk.org.ponder.messageutil.TargettedMessageList;
import uk.org.ponder.rsf.components.UIBranchContainer;
import uk.org.ponder.rsf.components.UICommand;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIELBinding;
import uk.org.ponder.rsf.components.UIForm;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.components.UIOutputMany;
import uk.org.ponder.rsf.components.UISelect;
import uk.org.ponder.rsf.components.UISelectChoice;
import uk.org.ponder.rsf.components.UIVerbatim;
import uk.org.ponder.rsf.flow.ARIResult;
import uk.org.ponder.rsf.flow.ActionResultInterceptor;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCase;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCaseReporter;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.AnyViewParameters;
import uk.org.ponder.rsf.viewstate.SimpleViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParamsReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollVoteProducer
implements ViewComponentProducer,
ViewParamsReporter,
ActionResultInterceptor,
NavigationCaseReporter {
    public static final String VIEW_ID = "voteQuestion";
    private PollListManager pollListManager;
    private MessageLocator messageLocator;
    private TargettedMessageList tml;
    private PollVoteManager pollVoteManager;
    private static final Log LOG = LogFactory.getLog(PollVoteProducer.class);
    private ExternalLogic externalLogic;

    public String getViewID() {
        return VIEW_ID;
    }

    public void setPollVoteManager(PollVoteManager pvm) {
        this.pollVoteManager = pvm;
    }

    public void setMessageLocator(MessageLocator messageLocator) {
        this.messageLocator = messageLocator;
    }

    public void setPollListManager(PollListManager pollListManager) {
        this.pollListManager = pollListManager;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void setTargettedMessageList(TargettedMessageList tml) {
        this.tml = tml;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker checker) {
        UIOutput.make((UIContainer)tofill, (String)"poll-vote-title", (String)this.messageLocator.getMessage("poll_vote_title"));
        PollViewParameters ecvp = (PollViewParameters)viewparams;
        String strId = ecvp.id;
        LOG.debug((Object)("got id of " + strId));
        Poll poll = this.pollListManager.getPollById(Long.valueOf(strId));
        if (!this.pollVoteManager.pollIsVotable(poll)) {
            this.tml.addMessage(new TargettedMessage("vote_noperm"));
            return;
        }
        LOG.info((Object)("user: " + this.externalLogic.getCurrentUserId() + " can vote on poll: " + poll.getPollId()));
        LOG.debug((Object)("got poll " + poll.getText()));
        if (poll.getLimitVoting() && this.pollVoteManager.userHasVoted(poll.getPollId())) {
            LOG.warn((Object)"This user has already voted!");
            UIOutput.make((UIContainer)tofill, (String)"hasErrors", (String)this.messageLocator.getMessage("vote_hasvoted"));
            return;
        }
        UIOutput.make((UIContainer)tofill, (String)"poll-text", (String)poll.getText());
        if (poll.getDetails() != null) {
            UIVerbatim.make((UIContainer)tofill, (String)"poll-description", (Object)poll.getDetails());
        }
        LOG.debug((Object)("this poll has " + poll.getPollOptions().size() + " options"));
        UIForm voteForm = UIForm.make((UIContainer)tofill, (String)"options-form", (String)"");
        List pollOptions = this.pollListManager.getVisibleOptionsForPoll(poll.getPollId());
        String[] values = new String[pollOptions.size()];
        for (int i = 0; i < pollOptions.size(); ++i) {
            Option po = (Option)pollOptions.get(i);
            values[i] = po.getOptionId().toString();
        }
        String[] labels = new String[pollOptions.size()];
        for (int i = 0; i < pollOptions.size(); ++i) {
            Option po = (Option)pollOptions.get(i);
            if (po.getOptionText() != null) {
                labels[i] = po.getOptionText();
                continue;
            }
            LOG.warn((Object)"Option text is null!");
            labels[i] = "null option!";
        }
        boolean isMultiple = false;
        if (poll.getMaxOptions() > 1) {
            isMultiple = true;
        }
        UISelect radio = isMultiple ? UISelect.makeMultiple((UIContainer)voteForm, (String)"optionform", (String[])values, (String)"#{voteCollection.optionsSelected}", (String[])new String[0]) : UISelect.make((UIContainer)voteForm, (String)"optionform", (String[])values, (String)"#{voteCollection.option}", (String)"");
        radio.optionnames = UIOutputMany.make((String[])labels);
        String selectID = radio.getFullID();
        for (int i = 0; i < pollOptions.size(); ++i) {
            Option po = (Option)pollOptions.get(i);
            LOG.debug((Object)("got option " + po.getOptionText() + " with id of  " + po.getId()));
            UIBranchContainer radioRow = UIBranchContainer.make((UIContainer)voteForm, (String)(isMultiple ? "option:select" : "option:radio"), (String)Integer.toString(i));
            UISelectChoice.make((UIContainer)radioRow, (String)"option-radio", (String)selectID, (int)i);
            UIVerbatim.make((UIContainer)radioRow, (String)"option-label", (Object)labels[i]);
        }
        voteForm.parameters.add((Object)new UIELBinding("#{voteCollection.pollId}", (Object)poll.getPollId()));
        UICommand sub = UICommand.make((UIContainer)voteForm, (String)"submit-new-vote", (String)this.messageLocator.getMessage("vote_vote"), (String)"#{pollToolBean.processActionVote}");
        sub.parameters.add((Object)new UIELBinding("#{voteCollection.submissionStatus}", (Object)"sub"));
        UICommand cancel = UICommand.make((UIContainer)voteForm, (String)"cancel", (String)this.messageLocator.getMessage("vote_cancel"), (String)"#{pollToolBean.cancel}");
        cancel.parameters.add((Object)new UIELBinding("#{voteCollection.submissionStatus}", (Object)"cancel"));
        if (poll.getMaxOptions() != 1 || poll.getMinOptions() != 1) {
            UIOutput.make((UIContainer)voteForm, (String)"reset", (String)this.messageLocator.getMessage("vote_reset"));
        }
    }

    public ViewParameters getViewParameters() {
        return new PollViewParameters();
    }

    public List<NavigationCase> reportNavigationCases() {
        ArrayList<NavigationCase> togo = new ArrayList<NavigationCase>();
        togo.add(new NavigationCase("Error", (AnyViewParameters)new SimpleViewParameters(VIEW_ID)));
        togo.add(new NavigationCase("Success", (AnyViewParameters)new VoteCollectionViewParameters("voteThanks")));
        togo.add(new NavigationCase("cancel", (AnyViewParameters)new SimpleViewParameters("votePolls")));
        return togo;
    }

    public void interceptActionResult(ARIResult result, ViewParameters incoming, Object actionReturn) {
        if (actionReturn instanceof VoteCollection) {
            VoteCollection votes = (VoteCollection)actionReturn;
            if (votes.getId() != null) {
                LOG.debug((Object)("got a voteCollection with id: " + votes.getId()));
                result.resultingView = new VoteCollectionViewParameters("voteThanks", votes.getId());
            } else {
                LOG.warn((Object)"no id in vote collection!");
            }
        }
    }
}

