/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.producers;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.logic.PollVoteManager;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Poll;
import org.sakaiproject.poll.tool.params.OptionViewParameters;
import org.sakaiproject.poll.tool.params.PollViewParameters;
import uk.org.ponder.messageutil.MessageLocator;
import uk.org.ponder.rsf.components.UIBranchContainer;
import uk.org.ponder.rsf.components.UICommand;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIELBinding;
import uk.org.ponder.rsf.components.UIForm;
import uk.org.ponder.rsf.components.UIInput;
import uk.org.ponder.rsf.components.UIMessage;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.components.UISelect;
import uk.org.ponder.rsf.components.UISelectChoice;
import uk.org.ponder.rsf.flow.ARIResult;
import uk.org.ponder.rsf.flow.ActionResultInterceptor;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.ViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParamsReporter;

public class PollOptionDeleteProducer
implements ViewComponentProducer,
ActionResultInterceptor,
ViewParamsReporter {
    public static final String VIEW_ID = "pollOptionDelete";
    private static final Log LOG = LogFactory.getLog(PollOptionDeleteProducer.class);
    private MessageLocator messageLocator;
    private PollListManager pollListManager;
    private PollVoteManager pollVoteManager;

    public String getViewID() {
        return VIEW_ID;
    }

    public void setMessageLocator(MessageLocator messageLocator) {
        this.messageLocator = messageLocator;
    }

    public void setPollListManager(PollListManager p) {
        this.pollListManager = p;
    }

    public void setPollVoteManager(PollVoteManager pollVoteManager) {
        this.pollVoteManager = pollVoteManager;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker arg2) {
        LOG.debug((Object)"rendering view");
        UIOutput.make((UIContainer)tofill, (String)"confirm_delete", (String)this.messageLocator.getMessage("delete_confirm"));
        Option option = null;
        OptionViewParameters aivp = (OptionViewParameters)viewparams;
        if (aivp.id != null) {
            LOG.debug((Object)("got a paramater with id: " + Long.valueOf(aivp.id)));
            option = this.pollListManager.getOptionById(Long.valueOf(aivp.id));
        }
        if (option == null) {
            LOG.error((Object)"no such option found!");
            return;
        }
        UIMessage.make((UIContainer)tofill, (String)"error", (String)"delete_option_message", (Object[])new Object[]{option.getOptionText()});
        UIForm form = UIForm.make((UIContainer)tofill, (String)"opt-form");
        UIInput.make((UIContainer)form, (String)"opt-text", (String)"#{option.optionText}", (String)option.getOptionText());
        Poll poll = this.pollListManager.getPollById(option.getPollId());
        Boolean showVoteHandlingOptions = Boolean.FALSE;
        if (this.pollVoteManager.pollIsVotable(poll)) {
            showVoteHandlingOptions = Boolean.TRUE;
        } else {
            List votes = this.pollVoteManager.getAllVotesForOption(option);
            if (votes != null && votes.size() > 0) {
                showVoteHandlingOptions = Boolean.TRUE;
            }
        }
        if (showVoteHandlingOptions.booleanValue()) {
            UIBranchContainer hasVotesContainer = UIBranchContainer.make((UIContainer)form, (String)"has-votes:");
            UIMessage.make((UIContainer)hasVotesContainer, (String)"has-votes-text", (String)"delete_option_has_votes");
            UISelect handleVotesSelect = UISelect.make((UIContainer)hasVotesContainer, (String)"handle-votes", (String[])new String[]{"do-nothing", "return-votes"}, (String)"#{pollToolBean.handleOrphanVotes}", (String)"return-votes");
            UISelectChoice.make((UIContainer)hasVotesContainer, (String)"do-nothing", (String)handleVotesSelect.getFullID(), (int)0);
            UISelectChoice.make((UIContainer)hasVotesContainer, (String)"return-votes", (String)handleVotesSelect.getFullID(), (int)1);
            UIMessage.make((UIContainer)hasVotesContainer, (String)"do-nothing-label", (String)"handle_delete_option_do_nothing_label");
            UIMessage.make((UIContainer)hasVotesContainer, (String)"return-votes-label", (String)"handle_delete_option_return_votes_label");
        }
        form.parameters.add((Object)new UIELBinding("#{option.optionId}", (Object)option.getOptionId()));
        form.parameters.add((Object)new UIELBinding("#{option.id}", (Object)option.getId()));
        form.parameters.add((Object)new UIELBinding("#{option.pollId}", (Object)option.getPollId()));
        UICommand saveAdd = UICommand.make((UIContainer)form, (String)"submit-option-add", (String)this.messageLocator.getMessage("delete_option_confirm"), (String)"#{pollToolBean.proccessActionDeleteOption}");
        saveAdd.parameters.add((Object)new UIELBinding("#{option.status}", (Object)"delete"));
        UICommand cancel = UICommand.make((UIContainer)form, (String)"cancel", (String)this.messageLocator.getMessage("new_poll_cancel"), (String)"#{pollToolBean.cancel}");
        cancel.parameters.add((Object)new UIELBinding("#{option.status}", (Object)"cancel"));
    }

    public ViewParameters getViewParameters() {
        return new OptionViewParameters();
    }

    public void interceptActionResult(ARIResult result, ViewParameters incoming, Object actionReturn) {
        LOG.debug((Object)"intercepting action results!");
        Poll poll = null;
        if (actionReturn != null && actionReturn instanceof Poll) {
            poll = (Poll)actionReturn;
            LOG.debug((Object)("return is poll: " + poll.getPollId()));
            result.resultingView = new PollViewParameters("voteAdd", poll.getPollId().toString());
        }
        if (result.resultingView instanceof OptionViewParameters) {
            OptionViewParameters optvp = (OptionViewParameters)result.resultingView;
            String retVal = (String)actionReturn;
            String viewId = "voteAdd";
            if (optvp.pollId != null) {
                if (!"option".equals(retVal)) {
                    result.resultingView = new PollViewParameters(viewId, optvp.pollId);
                } else {
                    LOG.debug((Object)("New option for poll: " + optvp.pollId));
                    result.resultingView = new OptionViewParameters(VIEW_ID, optvp.id, optvp.pollId);
                }
            } else {
                Option option = this.pollListManager.getOptionById(Long.valueOf(optvp.id));
                result.resultingView = new PollViewParameters(viewId, option.getPollId().toString());
            }
        }
    }
}

