/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.producers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.poll.logic.ExternalLogic;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Poll;
import org.sakaiproject.poll.tool.params.OptionViewParameters;
import org.sakaiproject.poll.tool.params.PollViewParameters;
import org.sakaiproject.poll.tool.params.VoteBean;
import uk.org.ponder.messageutil.MessageLocator;
import uk.org.ponder.messageutil.TargettedMessageList;
import uk.org.ponder.rsf.components.UIBranchContainer;
import uk.org.ponder.rsf.components.UICommand;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIELBinding;
import uk.org.ponder.rsf.components.UIForm;
import uk.org.ponder.rsf.components.UIInput;
import uk.org.ponder.rsf.components.UIMessage;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.evolvers.TextInputEvolver;
import uk.org.ponder.rsf.flow.ARIResult;
import uk.org.ponder.rsf.flow.ActionResultInterceptor;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCase;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCaseReporter;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.AnyViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParamsReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollOptionProducer
implements ViewComponentProducer,
ViewParamsReporter,
NavigationCaseReporter,
ActionResultInterceptor {
    public static final String VIEW_ID = "pollOption";
    private static final Log LOG = LogFactory.getLog(PollOptionProducer.class);
    private VoteBean voteBean;
    private MessageLocator messageLocator;
    private PollListManager pollListManager;
    private TargettedMessageList tml;
    private TextInputEvolver richTextEvolver;
    private ExternalLogic externalLogic;

    public String getViewID() {
        return VIEW_ID;
    }

    public void setVoteBean(VoteBean vb) {
        this.voteBean = vb;
    }

    public void setMessageLocator(MessageLocator messageLocator) {
        this.messageLocator = messageLocator;
    }

    public void setPollListManager(PollListManager p) {
        this.pollListManager = p;
    }

    public void setTargettedMessageList(TargettedMessageList tml) {
        this.tml = tml;
    }

    public void setRichTextEvolver(TextInputEvolver richTextEvolver) {
        this.richTextEvolver = richTextEvolver;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker arg2) {
        UIInput optText;
        if (this.tml.size() > 0) {
            for (int i = 0; i < this.tml.size(); ++i) {
                UIBranchContainer errorRow = UIBranchContainer.make((UIContainer)tofill, (String)"error-row:");
                String output = this.tml.messageAt((int)i).args != null ? this.messageLocator.getMessage(this.tml.messageAt(i).acquireMessageCode(), this.tml.messageAt((int)i).args[0]) : this.messageLocator.getMessage(this.tml.messageAt(i).acquireMessageCode());
                UIOutput.make((UIContainer)errorRow, (String)"error", (String)output);
            }
        }
        Option option = null;
        Poll poll = null;
        OptionViewParameters aivp = (OptionViewParameters)viewparams;
        boolean newOption = false;
        if (aivp.id != null) {
            LOG.debug((Object)("got a paramater with id: " + Long.valueOf(aivp.id)));
            option = this.pollListManager.getOptionById(Long.valueOf(aivp.id));
            poll = this.pollListManager.getPollById(option.getPollId());
            UIMessage.make((UIContainer)tofill, (String)"new-option-title", (String)"edit_option_title");
        } else {
            option = new Option();
            if (aivp.pollId != null) {
                option.setPollId(Long.valueOf(aivp.pollId));
                poll = this.pollListManager.getPollById(Long.valueOf(aivp.pollId));
            } else {
                option.setPollId(this.voteBean.getPoll().getPollId());
            }
            newOption = true;
            UIMessage.make((UIContainer)tofill, (String)"new-option-title", (String)"new_option_title");
        }
        if (poll == null) {
            LOG.warn((Object)"no poll found");
            return;
        }
        UIOutput.make((UIContainer)tofill, (String)"poll_text", (String)poll.getText());
        UIOutput.make((UIContainer)tofill, (String)"poll-question", (String)this.messageLocator.getMessage("new_poll_question"));
        UIForm form = UIForm.make((UIContainer)tofill, (String)"opt-form");
        if (option.getOptionText() == null) {
            option.setOptionText("");
        }
        if (!this.externalLogic.isMobileBrowser()) {
            optText = UIInput.make((UIContainer)form, (String)"optText:", (String)"#{option.optionText}", (String)option.getOptionText());
            this.richTextEvolver.evolveTextInput(optText);
        } else {
            optText = UIInput.make((UIContainer)form, (String)"optText_mobile", (String)"#{option.optionText}", (String)option.getOptionText());
        }
        form.parameters.add((Object)new UIELBinding("#{option.pollId}", (Object)poll.getPollId()));
        UICommand save = UICommand.make((UIContainer)form, (String)"submit-new-option", (String)this.messageLocator.getMessage("new_poll_submit"), (String)"#{pollToolBean.proccessActionAddOption}");
        save.parameters.add((Object)new UIELBinding("#{pollToolBean.submissionStatus}", (Object)"save"));
        if (newOption) {
            UICommand saveAdd = UICommand.make((UIContainer)form, (String)"submit-option-add", (String)this.messageLocator.getMessage("new_poll_saveoption"), (String)"#{pollToolBean.proccessActionAddOption}");
            saveAdd.parameters.add((Object)new UIELBinding("#{pollToolBean.submissionStatus}", (Object)"option"));
        } else {
            form.parameters.add((Object)new UIELBinding("#{option.optionId}", (Object)option.getOptionId()));
        }
        UICommand cancel = UICommand.make((UIContainer)form, (String)"cancel", (String)this.messageLocator.getMessage("new_poll_cancel"), (String)"#{pollToolBean.cancel}");
        cancel.parameters.add((Object)new UIELBinding("#{option.status}", (Object)"cancel"));
    }

    public List<NavigationCase> reportNavigationCases() {
        ArrayList<NavigationCase> togo = new ArrayList<NavigationCase>();
        togo.add(new NavigationCase("save", (AnyViewParameters)new PollViewParameters("voteAdd")));
        togo.add(new NavigationCase("cancel", null));
        return togo;
    }

    public ViewParameters getViewParameters() {
        return new OptionViewParameters();
    }

    public void interceptActionResult(ARIResult result, ViewParameters incoming, Object actionReturn) {
        LOG.debug((Object)"checking IntercetpActionResult(");
        if (result.resultingView instanceof OptionViewParameters) {
            OptionViewParameters optvp = (OptionViewParameters)result.resultingView;
            LOG.debug((Object)("OptionViewParams: " + optvp.id + " : " + optvp.pollId));
            String retVal = (String)actionReturn;
            LOG.debug((Object)("retval is " + retVal));
            if (retVal == null) {
                return;
            }
            String viewId = "voteAdd";
            if (optvp.pollId != null) {
                if (!"option".equals(retVal)) {
                    result.resultingView = new PollViewParameters(viewId, optvp.pollId);
                } else {
                    LOG.debug((Object)("New option for poll: " + optvp.pollId));
                    result.resultingView = new OptionViewParameters(VIEW_ID, optvp.id, optvp.pollId);
                }
            } else {
                Option option = this.pollListManager.getOptionById(Long.valueOf(optvp.id));
                result.resultingView = new PollViewParameters(viewId, option.getPollId().toString());
            }
        }
    }
}

