/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.producers;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.poll.logic.ExternalLogic;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.logic.PollVoteManager;
import org.sakaiproject.poll.model.Poll;
import org.sakaiproject.poll.tool.params.PollViewParameters;
import org.sakaiproject.poll.tool.params.VoteBean;
import uk.org.ponder.localeutil.LocaleGetter;
import uk.org.ponder.messageutil.MessageLocator;
import uk.org.ponder.messageutil.TargettedMessageList;
import uk.org.ponder.rsf.components.UIBoundString;
import uk.org.ponder.rsf.components.UIBranchContainer;
import uk.org.ponder.rsf.components.UICommand;
import uk.org.ponder.rsf.components.UIComponent;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIELBinding;
import uk.org.ponder.rsf.components.UIForm;
import uk.org.ponder.rsf.components.UIInternalLink;
import uk.org.ponder.rsf.components.UILink;
import uk.org.ponder.rsf.components.UIMessage;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.components.UISelect;
import uk.org.ponder.rsf.components.UISelectChoice;
import uk.org.ponder.rsf.components.UIVerbatim;
import uk.org.ponder.rsf.components.decorators.DecoratorList;
import uk.org.ponder.rsf.components.decorators.UIDecorator;
import uk.org.ponder.rsf.components.decorators.UIFreeAttributeDecorator;
import uk.org.ponder.rsf.components.decorators.UILabelTargetDecorator;
import uk.org.ponder.rsf.components.decorators.UITooltipDecorator;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCase;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCaseReporter;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.DefaultView;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.AnyViewParameters;
import uk.org.ponder.rsf.viewstate.SimpleViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParameters;
import uk.org.ponder.stringutil.StringList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollToolProducer
implements ViewComponentProducer,
DefaultView,
NavigationCaseReporter {
    public static final String VIEW_ID = "votePolls";
    private PollListManager pollListManager;
    private MessageLocator messageLocator;
    private LocaleGetter localegetter;
    private PollVoteManager pollVoteManager;
    private static final String NAVIGATE_ADD = "actions-add";
    private static final String NAVIGATE_PERMISSIONS = "actions-permissions";
    private static final String NAVIGATE_VOTE = "poll-vote";
    private static final Log LOG = LogFactory.getLog(PollToolProducer.class);
    private ExternalLogic externalLogic;
    private VoteBean voteBean;
    private TargettedMessageList tml;

    public String getViewID() {
        return VIEW_ID;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void setMessageLocator(MessageLocator messageLocator) {
        this.messageLocator = messageLocator;
    }

    public void setPollListManager(PollListManager pollListManager) {
        this.pollListManager = pollListManager;
    }

    public void setLocaleGetter(LocaleGetter localegetter) {
        this.localegetter = localegetter;
    }

    public void setPollVoteManager(PollVoteManager pvm) {
        this.pollVoteManager = pvm;
    }

    public void setVoteBean(VoteBean vb) {
        this.voteBean = vb;
    }

    public void setTargettedMessageList(TargettedMessageList tml) {
        this.tml = tml;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker checker) {
        this.voteBean.setPoll(null);
        this.voteBean.voteCollection = null;
        UIOutput.make((UIContainer)tofill, (String)"poll-list-title", (String)this.messageLocator.getMessage("poll_list_title"));
        boolean renderDelete = false;
        if (this.isAllowedPollAdd() || this.isSiteOwner()) {
            UIBranchContainer actions = UIBranchContainer.make((UIContainer)tofill, (String)"actions:", (String)Integer.toString(0));
            LOG.debug((Object)"this user has some admin functions");
            if (this.isAllowedPollAdd()) {
                LOG.debug((Object)"User can add polls");
                UIInternalLink.make((UIContainer)actions, (String)NAVIGATE_ADD, (UIBoundString)UIMessage.make((String)"action_add_poll"), (ViewParameters)new PollViewParameters("voteAdd", "New 0"));
            }
            if (this.isSiteOwner()) {
                UIInternalLink.make((UIContainer)actions, (String)NAVIGATE_PERMISSIONS, (UIBoundString)UIMessage.make((String)"action_set_permissions"), (ViewParameters)new SimpleViewParameters("votePermissions"));
            }
        }
        List polls = new ArrayList();
        String siteId = this.externalLogic.getCurrentLocationId();
        if (siteId != null) {
            polls = this.pollListManager.findAllPolls(siteId);
        } else {
            LOG.warn((Object)"Unable to get siteid!");
        }
        if (polls.isEmpty()) {
            UIOutput.make((UIContainer)tofill, (String)"no-polls", (String)this.messageLocator.getMessage("poll_list_empty"));
            UIOutput.make((UIContainer)tofill, (String)"add-poll-icon");
            if (this.isAllowedPollAdd()) {
                UIInternalLink.make((UIContainer)tofill, (String)"add-poll", (UIBoundString)UIMessage.make((String)"new_poll_title"), (ViewParameters)new PollViewParameters("voteAdd", "New 0"));
            }
        } else {
            Locale M_locale = null;
            String[] langLoc = this.localegetter.get().toString().split("_");
            M_locale = langLoc.length >= 2 ? ("en".equals(langLoc[0]) && "ZA".equals(langLoc[1]) ? new Locale("en", "GB") : new Locale(langLoc[0], langLoc[1])) : new Locale(langLoc[0]);
            DateFormat df = DateFormat.getDateTimeInstance(2, 3, M_locale);
            TimeZone tz = this.externalLogic.getLocalTimeZone();
            df.setTimeZone(tz);
            UIForm deleteForm = UIForm.make((UIContainer)tofill, (String)"delete-poll-form");
            UISelect deleteselect = UISelect.makeMultiple((UIContainer)deleteForm, (String)"delete-poll", null, (String)"#{pollToolBean.deleteids}", (String[])new String[0]);
            UIMessage.make((UIContainer)deleteForm, (String)"poll-result-title", (String)"poll_result_title");
            UIMessage.make((UIContainer)deleteForm, (String)"poll-remove-title", (String)"poll_remove_title");
            UILink question = UILink.make((UIContainer)tofill, (String)"poll-question-title", (String)this.messageLocator.getMessage("poll_question_title"), (String)"#");
            question.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("poll_question_title_tooltip")));
            UILink open = UILink.make((UIContainer)tofill, (String)"poll-open-title", (String)this.messageLocator.getMessage("poll_open_title"), (String)"#");
            open.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("poll_open_title_tooltip")));
            UILink close = UILink.make((UIContainer)tofill, (String)"poll-close-title", (String)this.messageLocator.getMessage("poll_close_title"), (String)"#");
            close.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("poll_close_title_tooltip")));
            StringList deletable = new StringList();
            for (int i = 0; i < polls.size(); ++i) {
                Poll poll = (Poll)polls.get(i);
                boolean canVote = this.pollVoteManager.pollIsVotable(poll);
                UIBranchContainer pollrow = UIBranchContainer.make((UIContainer)deleteForm, (String)(canVote ? "poll-row:votable" : "poll-row:nonvotable"), (String)poll.getPollId().toString());
                LOG.debug((Object)("adding poll row for " + poll.getText()));
                if (canVote) {
                    UIInternalLink voteLink = UIInternalLink.make((UIContainer)pollrow, (String)NAVIGATE_VOTE, (String)poll.getText(), (ViewParameters)new PollViewParameters("voteQuestion", poll.getPollId().toString()));
                    voteLink.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("poll_vote_title") + ":" + poll.getText()));
                } else {
                    poll.setOptions(this.pollListManager.getOptionsForPoll(poll.getPollId()));
                    if (poll.getPollOptions().size() == 0) {
                        UIOutput.make((UIContainer)pollrow, (String)"poll-text", (String)(poll.getText() + " (" + this.messageLocator.getMessage("poll_no_options") + ")"));
                    } else {
                        UIOutput.make((UIContainer)pollrow, (String)"poll-text", (String)poll.getText());
                    }
                }
                if (this.pollListManager.isAllowedViewResults(poll, this.externalLogic.getCurrentUserId())) {
                    UIInternalLink resultsLink = UIInternalLink.make((UIContainer)pollrow, (String)"poll-results", (String)this.messageLocator.getMessage("action_view_results"), (ViewParameters)new PollViewParameters("voteResults", poll.getPollId().toString()));
                    resultsLink.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("action_view_results") + ":" + poll.getText()));
                }
                if (poll.getVoteOpen() != null) {
                    UIOutput.make((UIContainer)pollrow, (String)"poll-open-date", (String)df.format((Date)poll.getVoteOpen())).decorators = new DecoratorList((UIDecorator)new UIFreeAttributeDecorator("name", "realDate:" + poll.getVoteOpen().toString()));
                } else {
                    UIVerbatim.make((UIContainer)pollrow, (String)"poll-open-date", (Object)"  ");
                }
                if (poll.getVoteClose() != null) {
                    UIOutput.make((UIContainer)pollrow, (String)"poll-close-date", (String)df.format((Date)poll.getVoteClose())).decorators = new DecoratorList((UIDecorator)new UIFreeAttributeDecorator("name", "realDate:" + poll.getVoteClose().toString()));
                } else {
                    UIVerbatim.make((UIContainer)pollrow, (String)"poll-close-date", (Object)"  ");
                }
                if (this.pollCanEdit(poll)) {
                    UIInternalLink editLink = UIInternalLink.make((UIContainer)pollrow, (String)"poll-revise", (String)this.messageLocator.getMessage("action_revise_poll"), (ViewParameters)new PollViewParameters("voteAdd", poll.getPollId().toString()));
                    editLink.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("action_revise_poll") + ":" + poll.getText()));
                }
                if (!this.pollCanDelete(poll)) continue;
                deletable.add((Object)poll.getPollId().toString());
                UISelectChoice delete = UISelectChoice.make((UIContainer)pollrow, (String)"poll-select", (String)deleteselect.getFullID(), (int)(deletable.size() - 1));
                delete.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator((UIBoundString)UIMessage.make((String)"delete_poll_tooltip", (Object[])new String[]{poll.getText()})));
                UIMessage message = UIMessage.make((UIContainer)pollrow, (String)"delete-label", (String)"delete_poll_tooltip", (Object[])new String[]{poll.getText()});
                UILabelTargetDecorator.targetLabel((UIComponent)message, (UIComponent)delete);
                LOG.debug((Object)"this poll can be deleted");
                renderDelete = true;
            }
            deleteselect.optionlist.setValue(deletable.toStringArray());
            deleteForm.parameters.add((Object)new UIELBinding("#{pollToolBean.siteID}", (Object)siteId));
            if (renderDelete) {
                UICommand.make((UIContainer)deleteForm, (String)"delete-polls", (UIBoundString)UIMessage.make((String)"poll_list_update"), (String)"#{pollToolBean.processActionDelete}").decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("poll_list_update_tooltip")));
            }
        }
    }

    private boolean isAllowedPollAdd() {
        if (this.externalLogic.isUserAdmin()) {
            return true;
        }
        return this.externalLogic.isAllowedInLocation("poll.add", this.externalLogic.getCurrentLocationReference());
    }

    private boolean isSiteOwner() {
        if (this.externalLogic.isUserAdmin()) {
            return true;
        }
        return this.externalLogic.isAllowedInLocation("site.upd", this.externalLogic.getCurrentLocationReference());
    }

    public List<NavigationCase> reportNavigationCases() {
        ArrayList<NavigationCase> togo = new ArrayList<NavigationCase>();
        togo.add(new NavigationCase(null, (AnyViewParameters)new SimpleViewParameters(VIEW_ID)));
        return togo;
    }

    private boolean pollCanEdit(Poll poll) {
        if (this.externalLogic.isUserAdmin()) {
            return true;
        }
        if (this.externalLogic.isAllowedInLocation("poll.editAny", this.externalLogic.getCurrentLocationReference())) {
            return true;
        }
        return this.externalLogic.isAllowedInLocation("poll.editOwn", this.externalLogic.getCurrentLocationReference()) && poll.getOwner().equals(this.externalLogic.getCurrentUserId());
    }

    private boolean pollCanDelete(Poll poll) {
        if (this.externalLogic.isUserAdmin()) {
            return true;
        }
        if (this.externalLogic.isAllowedInLocation("poll.deleteAny", this.externalLogic.getCurrentLocationReference())) {
            return true;
        }
        return this.externalLogic.isAllowedInLocation("poll.deleteOwn", this.externalLogic.getCurrentLocationReference()) && poll.getOwner().equals(this.externalLogic.getCurrentUserId());
    }
}

