/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.producers;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.poll.logic.ExternalLogic;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.logic.PollVoteManager;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Poll;
import org.sakaiproject.poll.model.Vote;
import org.sakaiproject.poll.tool.params.PollViewParameters;
import org.sakaiproject.poll.tool.producers.ResultsProducer;
import uk.org.ponder.localeutil.LocaleGetter;
import uk.org.ponder.messageutil.MessageLocator;
import uk.org.ponder.messageutil.TargettedMessage;
import uk.org.ponder.messageutil.TargettedMessageList;
import uk.org.ponder.rsf.components.UIBranchContainer;
import uk.org.ponder.rsf.components.UICommand;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIForm;
import uk.org.ponder.rsf.components.UIInternalLink;
import uk.org.ponder.rsf.components.UILink;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.components.UISelect;
import uk.org.ponder.rsf.components.UIVerbatim;
import uk.org.ponder.rsf.components.decorators.DecoratorList;
import uk.org.ponder.rsf.components.decorators.UIDecorator;
import uk.org.ponder.rsf.components.decorators.UITooltipDecorator;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCase;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCaseReporter;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.AnyViewParameters;
import uk.org.ponder.rsf.viewstate.SimpleViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParamsReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsProducer
implements ViewComponentProducer,
NavigationCaseReporter,
ViewParamsReporter {
    public static final String VIEW_ID = "voteResults";
    private PollListManager pollListManager;
    private PollVoteManager pollVoteManager;
    private MessageLocator messageLocator;
    private LocaleGetter localegetter;
    private static final Log LOG = LogFactory.getLog(ResultsProducer.class);
    private ExternalLogic externalLogic;
    private TargettedMessageList tml;

    public String getViewID() {
        return VIEW_ID;
    }

    public void setMessageLocator(MessageLocator messageLocator) {
        this.messageLocator = messageLocator;
    }

    public void setPollListManager(PollListManager pollListManager) {
        this.pollListManager = pollListManager;
    }

    public void setLocaleGetter(LocaleGetter localegetter) {
        this.localegetter = localegetter;
    }

    public void setPollVoteManager(PollVoteManager pvm) {
        this.pollVoteManager = pvm;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void setTargettedMessageList(TargettedMessageList tml) {
        this.tml = tml;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker checker) {
        PollViewParameters ecvp = (PollViewParameters)viewparams;
        String strId = ecvp.id;
        LOG.debug((Object)("got id of " + strId));
        Poll poll = this.pollListManager.getPollById(Long.valueOf(strId));
        if (!this.pollListManager.isAllowedViewResults(poll, this.externalLogic.getCurrentUserId())) {
            this.tml.addMessage(new TargettedMessage("poll.noviewresult", new Object[0], 1));
            return;
        }
        int voters = this.pollVoteManager.getDisctinctVotersForPoll(poll);
        if (poll.getMaxOptions() > 1) {
            UIOutput.make((UIContainer)tofill, (String)"poll-size", (String)this.messageLocator.getMessage("results_poll_size", (Object)Integer.valueOf(voters).toString()));
        }
        LOG.debug((Object)(voters + " have voted on this poll"));
        UIOutput.make((UIContainer)tofill, (String)"question", (String)poll.getText());
        LOG.debug((Object)("got poll " + poll.getText()));
        List pollOptions = poll.getPollOptions();
        LOG.debug((Object)("got a list of " + pollOptions.size() + " options"));
        if (poll.getMinOptions() == 0) {
            Option noVote = new Option(Long.valueOf(0L));
            noVote.setOptionText(this.messageLocator.getMessage("result_novote"));
            noVote.setPollId(poll.getPollId());
            pollOptions.add(noVote);
        }
        List votes = this.pollVoteManager.getAllVotesForPoll(poll);
        int totalVotes = votes.size();
        LOG.debug((Object)("got " + totalVotes + " votes"));
        ArrayList<CollatedVote> collation = new ArrayList<CollatedVote>();
        for (int i = 0; i < pollOptions.size(); ++i) {
            CollatedVote collatedVote = new CollatedVote();
            Option option = (Option)pollOptions.get(i);
            LOG.debug((Object)("collating option " + option.getOptionId()));
            collatedVote.setoptionId(option.getOptionId());
            collatedVote.setOptionText(option.getOptionText());
            collatedVote.setDeleted(option.getDeleted());
            for (int q = 0; q < votes.size(); ++q) {
                Vote vote = (Vote)votes.get(q);
                if (!vote.getPollOption().equals(option.getOptionId())) continue;
                LOG.debug((Object)("got a vote for option " + option.getOptionId()));
                collatedVote.incrementVotes();
            }
            collation.add(collatedVote);
        }
        UILink title = UILink.make((UIContainer)tofill, (String)"answers-title", (String)this.messageLocator.getMessage("results_answers_title"), (String)"#");
        title.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("results_answers_title_tooltip")));
        UILink count = UILink.make((UIContainer)tofill, (String)"answers-count", (String)this.messageLocator.getMessage("results_answers_numbering"), (String)"#");
        count.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("results_answers_numbering_tooltip")));
        UILink avotes = UILink.make((UIContainer)tofill, (String)"answers-votes", (String)this.messageLocator.getMessage("results_answers_votes"), (String)"#");
        avotes.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("results_answers_votes_tooltip")));
        UILink apercent = UILink.make((UIContainer)tofill, (String)"answers-percent", (String)"%", (String)"#");
        apercent.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("results_answers_percent_tooltip")));
        UIBranchContainer adefault = UIBranchContainer.make((UIContainer)tofill, (String)"answers-default:");
        adefault.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("results_answers_default_tooltip")));
        LinkedHashMap<Long, String> chartTextData = new LinkedHashMap<Long, String>();
        LinkedHashMap<Long, String> chartValueData = new LinkedHashMap<Long, String>();
        NumberFormat nf = NumberFormat.getPercentInstance(this.localegetter.get());
        for (int i = 0; i < collation.size(); ++i) {
            CollatedVote cv = (CollatedVote)collation.get(i);
            UIBranchContainer resultRow = UIBranchContainer.make((UIContainer)tofill, (String)"answer-row:", (String)cv.getoptionId().toString());
            String optionText = cv.getOptionText();
            if (cv.getDeleted().booleanValue()) {
                optionText = optionText + this.messageLocator.getMessage("deleted_option_tag_html");
            }
            UIVerbatim.make((UIContainer)resultRow, (String)"answer-option", (Object)optionText);
            UIOutput.make((UIContainer)resultRow, (String)"answer-count", (String)Integer.valueOf(i + 1).toString());
            UIOutput.make((UIContainer)resultRow, (String)"answer-numVotes", (String)Long.valueOf(cv.getVotes()).toString());
            LOG.debug((Object)("about to do the calc: (" + cv.getVotes() + "/" + totalVotes + ")*100"));
            double percent = 0.0;
            percent = totalVotes > 0 && poll.getMaxOptions() == 1 ? (double)cv.getVotes() / (double)totalVotes : (totalVotes > 0 && poll.getMaxOptions() > 1 ? (double)cv.getVotes() / (double)voters : 0.0);
            chartTextData.put(cv.getoptionId(), StringUtils.removeStart((String)optionText, (String)"&nbsp;"));
            chartValueData.put(cv.getoptionId(), StringUtils.removeEnd((String)nf.format(percent), (String)"%"));
            LOG.debug((Object)("result is " + percent));
            UIOutput.make((UIContainer)resultRow, (String)"answer-percVotes", (String)nf.format(percent));
        }
        UIOutput.make((UIContainer)tofill, (String)"votes-total", (String)Integer.valueOf(totalVotes).toString());
        if (totalVotes > 0 && poll.getMaxOptions() == 1) {
            UIOutput.make((UIContainer)tofill, (String)"total-percent", (String)"100%");
        }
        if (this.externalLogic.isResultsChartEnabled() && totalVotes > 0) {
            UIOutput.make((UIContainer)tofill, (String)"chart-type-label", (String)this.messageLocator.getMessage("results_chart_type"));
            String[] chartTypes = new String[]{"bar", "pie"};
            UISelect min = UISelect.make((UIContainer)tofill, (String)"chart-type", (String[])chartTypes, (String)"null", (String)"bar");
            StringBuilder sbBar = new StringBuilder();
            sbBar.append("https://chart.googleapis.com/chart?");
            sbBar.append("cht=bvg&");
            sbBar.append("chxt=y&");
            sbBar.append("chs=500x400&");
            sbBar.append("chd=t:" + StringUtils.join(chartValueData.values(), (char)'|') + "&");
            sbBar.append("chdl=" + StringUtils.join(chartTextData.values(), (char)'|') + "&");
            sbBar.append("chco=FF0000,00FF00,0000FF,FFFF00,00FFFF,FF00FF,C0C0C0,800080,000080,808000,800000,FF00FF,008080,800000,008000");
            UILink barChart = UILink.make((UIContainer)tofill, (String)"poll-chart-bar", (String)sbBar.toString());
            LOG.debug((Object)("bar chart URL:" + sbBar.toString()));
            StringBuilder sbPie = new StringBuilder();
            sbPie.append("https://chart.googleapis.com/chart?");
            sbPie.append("cht=p&");
            sbPie.append("chs=500x400&");
            sbPie.append("chd=t:" + StringUtils.join(chartValueData.values(), (char)',') + "&");
            sbPie.append("chl=" + StringUtils.join(chartTextData.values(), (char)'|') + "&");
            sbPie.append("chco=FF0000,00FF00,0000FF,FFFF00,00FFFF,FF00FF,C0C0C0,800080,000080,808000,800000,FF00FF,008080,800000,008000");
            UILink pieChart = UILink.make((UIContainer)tofill, (String)"poll-chart-pie", (String)sbPie.toString());
            LOG.debug((Object)("pie chart URL:" + sbPie.toString()));
            UIInternalLink resultsLink = UIInternalLink.make((UIContainer)tofill, (String)"results-refresh", (String)this.messageLocator.getMessage("action_refresh_results"), (ViewParameters)new PollViewParameters(VIEW_ID, poll.getPollId().toString()));
            resultsLink.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("action_refresh_results") + ":" + poll.getText()));
        }
        UIForm form = UIForm.make((UIContainer)tofill, (String)"actform");
        UICommand cancel = UICommand.make((UIContainer)form, (String)"cancel", (String)this.messageLocator.getMessage("results_cancel"), (String)"#{pollToolBean.cancel}");
        cancel.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("results_cancel_tooltip")));
        this.externalLogic.postEvent("poll.viewResult", "poll/site/" + this.externalLogic.getCurrentLocationId() + "/poll/" + poll.getPollId(), false);
    }

    public List<NavigationCase> reportNavigationCases() {
        ArrayList<NavigationCase> togo = new ArrayList<NavigationCase>();
        togo.add(new NavigationCase(null, (AnyViewParameters)new SimpleViewParameters(VIEW_ID)));
        togo.add(new NavigationCase("cancel", (AnyViewParameters)new SimpleViewParameters("votePolls")));
        return togo;
    }

    public ViewParameters getViewParameters() {
        return new PollViewParameters();
    }
}

