/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.entityproviders;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RedirectDefinable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestStorable;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestStorage;
import org.sakaiproject.entitybroker.entityprovider.extension.TemplateMap;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.logic.PollVoteManager;
import org.sakaiproject.poll.model.Poll;

public class PollEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
RESTful,
RequestStorable,
RedirectDefinable {
    private PollListManager pollListManager;
    private PollVoteManager pollVoteManager;
    public static final String PREFIX = "poll";
    RequestStorage requestStorage = null;

    public void setPollListManager(PollListManager pollListManager) {
        this.pollListManager = pollListManager;
    }

    public void setPollVoteManager(PollVoteManager pollVoteManager) {
        this.pollVoteManager = pollVoteManager;
    }

    public String getEntityPrefix() {
        return PREFIX;
    }

    public TemplateMap[] defineURLMappings() {
        return new TemplateMap[]{new TemplateMap("/{prefix}/{pollId}/vote", "poll-vote{dot-extension}"), new TemplateMap("/{prefix}/{pollId}/option", "poll-option{dot-extension}"), new TemplateMap("/{prefix}/site/{siteId}", "{prefix}{dot-extension}")};
    }

    public boolean entityExists(String id) {
        if (id == null) {
            return false;
        }
        if ("".equals(id)) {
            return true;
        }
        Poll poll = this.getPollById(id);
        boolean exists = poll != null;
        return exists;
    }

    private Poll getPollById(String id) {
        Long pollId;
        try {
            pollId = Long.valueOf(id);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid poll id (" + id + "), the id must be a number");
        }
        Poll poll = this.pollListManager.getPollById(pollId, false);
        return poll;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        Poll poll = (Poll)entity;
        poll.setCreationDate(new Date());
        if (poll.getId() == null) {
            poll.setId(UUID.randomUUID().toString());
        }
        if (poll.getOwner() == null) {
            poll.setOwner(this.developerHelperService.getCurrentUserId());
        }
        String siteId = this.developerHelperService.getCurrentLocationId();
        if (poll.getSiteId() == null) {
            poll.setSiteId(siteId);
        } else {
            siteId = poll.getSiteId();
        }
        String userReference = this.developerHelperService.getCurrentUserReference();
        String location = "/site/" + siteId;
        boolean allowed = this.developerHelperService.isUserAllowedInEntityReference(userReference, "poll.add", location);
        if (!allowed) {
            throw new SecurityException("Current user (" + userReference + ") cannot create polls in location (" + location + ")");
        }
        this.pollListManager.savePoll(poll);
        return poll.getPollId() + "";
    }

    public Object getSampleEntity() {
        return new Poll();
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        String id = ref.getId();
        if (id == null) {
            throw new IllegalArgumentException("The reference must include an id for updates (id is currently null)");
        }
        String userReference = this.developerHelperService.getCurrentUserReference();
        if (userReference == null) {
            throw new SecurityException("anonymous user cannot update poll: " + ref);
        }
        Poll current = this.getPollById(id);
        if (current == null) {
            throw new IllegalArgumentException("No poll found to update for the given reference: " + ref);
        }
        Poll poll = (Poll)entity;
        String siteId = this.developerHelperService.getCurrentLocationId();
        if (poll.getSiteId() == null) {
            poll.setSiteId(siteId);
        } else {
            siteId = poll.getSiteId();
        }
        String location = "/site/" + siteId;
        boolean allowed = this.developerHelperService.isUserAllowedInEntityReference(userReference, "poll.add", location);
        if (!allowed) {
            throw new SecurityException("Current user (" + userReference + ") cannot update polls in location (" + location + ")");
        }
        this.developerHelperService.copyBean((Object)poll, (Object)current, 0, new String[]{"id", "pollId", "owner", "siteId", "creationDate", "reference", "url", "properties"}, true);
        this.pollListManager.savePoll(current);
    }

    public Object getEntity(EntityReference ref) {
        Boolean includeOptions;
        Boolean includeVotes;
        String id = ref.getId();
        if (id == null) {
            return new Poll();
        }
        Poll poll = this.getPollById(id);
        if (poll == null) {
            throw new IllegalArgumentException("No poll found for the given reference: " + ref);
        }
        Long pollId = poll.getPollId();
        String currentUserId = this.developerHelperService.getCurrentUserId();
        boolean allowedManage = false;
        if (!this.developerHelperService.isEntityRequestInternal(ref + "") && !this.pollListManager.isPollPublic(poll)) {
            String userReference = this.developerHelperService.getCurrentUserReference();
            if (userReference == null) {
                throw new EntityException("User must be logged in in order to access poll data", ref.getId(), 401);
            }
            allowedManage = this.developerHelperService.isUserAllowedInEntityReference(userReference, "poll.add", "/site/" + poll.getSiteId());
            boolean allowedVote = this.developerHelperService.isUserAllowedInEntityReference(userReference, "poll.vote", "/site/" + poll.getSiteId());
            if (!allowedManage && !allowedVote) {
                throw new SecurityException("User (" + userReference + ") not allowed to access poll data: " + ref);
            }
        }
        if ((includeVotes = (Boolean)this.requestStorage.getStoredValueAsType(Boolean.class, "includeVotes")) == null) {
            includeVotes = false;
        }
        if (includeVotes.booleanValue()) {
            List votes = this.pollVoteManager.getAllVotesForPoll(poll);
            poll.setVotes(votes);
        }
        if ((includeOptions = (Boolean)this.requestStorage.getStoredValueAsType(Boolean.class, "includeOptions")) == null) {
            includeOptions = false;
        }
        if (includeOptions.booleanValue()) {
            List options = this.pollListManager.getOptionsForPoll(poll);
            poll.setOptions(options);
        }
        if (currentUserId != null) {
            Map voteMap = this.pollVoteManager.getVotesForUser(currentUserId, new Long[]{pollId});
            List l = (List)voteMap.get(pollId);
            if (l != null) {
                poll.setCurrentUserVoted(true);
                poll.setCurrentUserVotes(l);
            } else {
                poll.setCurrentUserVoted(false);
            }
        }
        return poll;
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
        String id = ref.getId();
        if (id == null) {
            throw new IllegalArgumentException("The reference must include an id for deletes (id is currently null)");
        }
        Poll poll = this.getPollById(id);
        if (poll == null) {
            throw new IllegalArgumentException("No poll found for the given reference: " + ref);
        }
        try {
            this.pollListManager.deletePoll(poll);
        }
        catch (SecurityException e) {
            throw new SecurityException("The current user (" + this.developerHelperService.getCurrentUserReference() + ") is not allowed to delete this poll: " + ref);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<?> getEntities(EntityReference ref, Search search) {
        System.out.println("get entities");
        boolean adminControl = false;
        Restriction adminRes = search.getRestrictionByProperty("admin");
        if (adminRes != null) {
            adminControl = (Boolean)this.developerHelperService.convert(adminRes.getSingleValue(), Boolean.TYPE);
        }
        Restriction locRes = search.getRestrictionByProperty("_locationReference");
        String[] siteIds = null;
        if (locRes != null) {
            String siteId = this.developerHelperService.getLocationIdFromRef(locRes.getStringValue());
            siteIds = new String[]{siteId};
        }
        Restriction userRes = search.getRestrictionByProperty("_userReference");
        String userId = null;
        if (userRes != null) {
            String currentUser = this.developerHelperService.getCurrentUserReference();
            String userReference = userRes.getStringValue();
            if (userReference == null) {
                throw new IllegalArgumentException("Invalid request: Cannot limit polls by user when the value is null");
            }
            if (!userReference.equals(currentUser) && !this.developerHelperService.isUserAdmin(currentUser)) throw new SecurityException("Only the admin can get polls for other users, you requested polls for: " + userReference);
            userId = this.developerHelperService.getUserIdFromRef(userReference);
        } else {
            userId = this.developerHelperService.getCurrentUserId();
            if (userId == null) {
                throw new EntityException("No user is currently logged in so no polls data can be retrieved", ref.getId(), 401);
            }
        }
        String perm = "poll.vote";
        if (adminControl) {
            perm = "poll.add";
        }
        List polls = this.pollListManager.findAllPollsForUserAndSitesAndPermission(userId, siteIds, perm);
        if (adminControl) {
            for (Poll p : polls) {
                List options = this.pollListManager.getOptionsForPoll(p.getPollId());
                p.setOptions(options);
            }
            return polls;
        } else {
            Long[] pollIds = new Long[polls.size()];
            for (int i = 0; i < polls.size(); ++i) {
                pollIds[i] = ((Poll)polls.get(i)).getPollId();
            }
            Map voteMap = this.pollVoteManager.getVotesForUser(userId, pollIds);
            for (Poll poll : polls) {
                Long pollId = poll.getPollId();
                List l = (List)voteMap.get(pollId);
                if (l != null) {
                    poll.setCurrentUserVoted(true);
                    poll.setCurrentUserVotes(l);
                    continue;
                }
                poll.setCurrentUserVoted(false);
            }
        }
        return polls;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json"};
    }

    public String[] getHandledInputFormats() {
        return new String[]{"xml", "json", "html"};
    }

    public void setRequestStorage(RequestStorage requestStorage) {
        this.requestStorage = requestStorage;
    }
}

