/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.entityproviders;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Poll;

public class PollOptionEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
RESTful {
    private PollListManager pollListManager;
    public static final String PREFIX = "poll-option";

    public void setPollListManager(PollListManager pollListManager) {
        this.pollListManager = pollListManager;
    }

    public String getEntityPrefix() {
        return PREFIX;
    }

    public boolean entityExists(String id) {
        if (id == null) {
            return false;
        }
        if ("".equals(id)) {
            return true;
        }
        Option option = this.getOptionById(id);
        boolean exists = option != null;
        return exists;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        String userReference = this.developerHelperService.getCurrentUserReference();
        if (userReference == null) {
            throw new EntityException("User must be logged in to create new options", ref.getId(), 401);
        }
        Option option = (Option)entity;
        if (option.getPollId() == null) {
            throw new IllegalArgumentException("Poll ID must be set to create an option");
        }
        if (option.getOptionText() == null) {
            throw new IllegalArgumentException("Poll Option text must be set to create an option");
        }
        this.checkOptionPermission(userReference, option);
        option.setUUId(UUID.randomUUID().toString());
        boolean saved = this.pollListManager.saveOption(option);
        if (!saved) {
            throw new IllegalStateException("Unable to save option (" + option + ") for user (" + userReference + "): " + ref);
        }
        return option.getId() + "";
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        String id = ref.getId();
        if (id == null) {
            throw new IllegalArgumentException("The reference must include an id for updates (id is currently null)");
        }
        String userReference = this.developerHelperService.getCurrentUserReference();
        if (userReference == null) {
            throw new EntityException("Anonymous user cannot update option", ref.getId(), 401);
        }
        Option current = this.getOptionById(id);
        if (current == null) {
            throw new IllegalArgumentException("No option found to update for the given reference: " + ref);
        }
        Option option = (Option)entity;
        this.checkOptionPermission(userReference, current);
        this.developerHelperService.copyBean((Object)option, (Object)current, 0, new String[]{"id", "pollId", "UUId"}, true);
        boolean saved = this.pollListManager.saveOption(current);
        if (!saved) {
            throw new IllegalStateException("Unable to update option (" + option + ") for user (" + userReference + "): " + ref);
        }
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
        String id = ref.getId();
        String userReference = this.developerHelperService.getCurrentUserReference();
        if (userReference == null) {
            throw new EntityException("Anonymous user cannot delete option", ref.getId(), 401);
        }
        Option option = this.getOptionById(id);
        if (option == null) {
            throw new IllegalArgumentException("No option found to delete for the given reference: " + ref);
        }
        this.checkOptionPermission(userReference, option);
        this.pollListManager.deleteOption(option);
    }

    public Object getSampleEntity() {
        return new Option();
    }

    public Object getEntity(EntityReference ref) {
        String id = ref.getId();
        if (id == null) {
            return new Option();
        }
        String currentUser = this.developerHelperService.getCurrentUserReference();
        if (currentUser == null) {
            throw new EntityException("Anonymous users cannot view specific options", ref.getId(), 401);
        }
        Option option = this.getOptionById(id);
        if (!this.developerHelperService.isEntityRequestInternal(ref.toString()) && !this.developerHelperService.isUserAdmin(currentUser)) {
            throw new SecurityException("User (" + currentUser + ") cannot view option (" + ref + ")");
        }
        return option;
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        Restriction pollRes = search.getRestrictionByProperty("pollId");
        if (pollRes == null || pollRes.getSingleValue() == null) {
            throw new IllegalArgumentException("Must include a non-null pollId in order to retreive a list of votes");
        }
        Long pollId = null;
        try {
            pollId = (Long)this.developerHelperService.convert(pollRes.getSingleValue(), Long.class);
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException("Invalid: pollId must be a long number: " + e.getMessage(), e);
        }
        Poll poll = this.pollListManager.getPollById(pollId);
        if (poll == null) {
            throw new IllegalArgumentException("pollId (" + pollId + ") is invalid and does not match any known polls");
        }
        boolean allowedPublic = this.pollListManager.isPollPublic(poll);
        if (!allowedPublic) {
            String userReference = this.developerHelperService.getCurrentUserReference();
            if (userReference == null) {
                throw new EntityException("User must be logged in in order to access poll data", ref.getId(), 401);
            }
            boolean allowedManage = false;
            boolean allowedVote = false;
            allowedManage = this.developerHelperService.isUserAllowedInEntityReference(userReference, "poll.add", "/site/" + poll.getSiteId());
            allowedVote = this.developerHelperService.isUserAllowedInEntityReference(userReference, "poll.vote", "/site/" + poll.getSiteId());
            if (!allowedManage && !allowedVote) {
                throw new SecurityException("User (" + userReference + ") not allowed to access poll data: " + ref);
            }
        }
        List options = this.pollListManager.getOptionsForPoll(pollId);
        return options;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json"};
    }

    public String[] getHandledInputFormats() {
        return new String[]{"xml", "json", "html"};
    }

    private void checkOptionPermission(String userRef, Option option) {
        if (option.getPollId() == null) {
            throw new IllegalArgumentException("Poll Id must be set in the option to check permissions: " + option);
        }
        Long pollId = option.getPollId();
        Poll poll = this.pollListManager.getPollById(pollId, false);
        if (poll == null) {
            throw new IllegalArgumentException("Invalid poll id (" + pollId + "), could not find poll from option: " + option);
        }
        String siteRef = "/site/" + poll.getSiteId();
        if (!this.developerHelperService.isUserAllowedInEntityReference(userRef, "poll.add", siteRef)) {
            throw new SecurityException("User (" + userRef + ") is not allowed to create/update/delete options in this poll (" + pollId + ")");
        }
    }

    private Option getOptionById(String id) {
        Long optionId;
        try {
            optionId = Long.valueOf(id);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot convert id (" + id + ") to long: " + e.getMessage(), e);
        }
        Option option = this.pollListManager.getOptionById(optionId);
        return option;
    }
}

