/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.entityproviders;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.CollectionResolvable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Createable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Inputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Redirectable;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.event.api.UsageSession;
import org.sakaiproject.event.api.UsageSessionService;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.logic.PollVoteManager;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Poll;
import org.sakaiproject.poll.model.Vote;

public class PollVoteEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
Createable,
CollectionResolvable,
Outputable,
Inputable,
Describeable,
ActionsExecutable,
Redirectable {
    private static Log log = LogFactory.getLog(PollVoteEntityProvider.class);
    private PollListManager pollListManager;
    private PollVoteManager pollVoteManager;
    private UsageSessionService usageSessionService;
    public static final String PREFIX = "poll-vote";

    public void setPollListManager(PollListManager pollListManager) {
        this.pollListManager = pollListManager;
    }

    public void setPollVoteManager(PollVoteManager pollVoteManager) {
        this.pollVoteManager = pollVoteManager;
    }

    public void setUsageSessionService(UsageSessionService usageSessionService) {
        this.usageSessionService = usageSessionService;
    }

    public String getEntityPrefix() {
        return PREFIX;
    }

    public boolean entityExists(String id) {
        if (id == null) {
            return false;
        }
        if ("".equals(id)) {
            return true;
        }
        Vote vote = this.getVoteById(id);
        boolean exists = vote != null;
        return exists;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        boolean saved;
        UsageSession usageSession;
        String userId = this.developerHelperService.getCurrentUserId();
        if (userId == null) {
            throw new EntityException("User must be logged in to create new votes", ref.getId(), 401);
        }
        Vote vote = (Vote)entity;
        log.debug((Object)("got vote: " + vote.toString()));
        Long pollId = null;
        try {
            pollId = Long.valueOf((String)params.get("pollId"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        if (pollId == null) {
            throw new IllegalArgumentException("Poll Id must be set to create a vote");
        }
        vote.setPollId(pollId);
        Long optionId = null;
        try {
            optionId = Long.valueOf((String)params.get("pollOption"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        if (optionId == null) {
            throw new IllegalArgumentException("Poll Option must be set to create a vote");
        }
        if (!this.pollVoteManager.isUserAllowedVote(userId, pollId, false)) {
            throw new SecurityException("User (" + userId + ") is not allowed to vote in this poll (" + pollId + ")");
        }
        vote.setPollOption(optionId);
        Option option = this.pollListManager.getOptionById(vote.getPollOption());
        if (option == null) {
            throw new IllegalArgumentException("Invalid poll option (" + vote.getPollOption() + ") [cannot find option] in vote (" + vote + ") for user (" + userId + ")");
        }
        if (!pollId.equals(option.getPollId())) {
            throw new IllegalArgumentException("Invalid poll option (" + vote.getPollOption() + ") [not in poll (" + pollId + ")] in vote (" + vote + ") for user (" + userId + ")");
        }
        vote.setVoteDate(new Date());
        vote.setUserId(userId);
        if (vote.getSubmissionId() == null) {
            String sid = userId + ":" + UUID.randomUUID();
            vote.setSubmissionId(sid);
        }
        if ((usageSession = this.usageSessionService.getSession()) != null) {
            vote.setIp(usageSession.getIpAddress());
        }
        if (!(saved = this.pollVoteManager.saveVote(vote))) {
            throw new IllegalStateException("Unable to save vote (" + vote + ") for user (" + userId + "): " + ref);
        }
        return vote.getId() + "";
    }

    public Object getSampleEntity() {
        return new Vote();
    }

    public Object getEntity(EntityReference ref) {
        String id = ref.getId();
        String currentUser = this.developerHelperService.getCurrentUserReference();
        log.debug((Object)("current user is: " + currentUser));
        if (currentUser == null || currentUser.length() == 0) {
            throw new EntityException("Anonymous users cannot view specific votes", ref.getId(), 401);
        }
        if (ref.getId() == null) {
            new Vote();
        }
        Vote vote = this.getVoteById(id);
        String userId = this.developerHelperService.getUserIdFromRef(currentUser);
        if (!(this.developerHelperService.isUserAdmin(currentUser) || userId.equals(vote.getUserId()) || this.developerHelperService.isEntityRequestInternal(ref.toString()))) {
            throw new SecurityException("User (" + currentUser + ") cannot view vote (" + ref + ")");
        }
        if (id == null) {
            return new Vote();
        }
        return vote;
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        String currentUser = this.developerHelperService.getCurrentUserReference();
        if (currentUser == null) {
            throw new EntityException("Anonymous users cannot view votes", ref.getId(), 401);
        }
        Restriction pollRes = search.getRestrictionByProperty("pollId");
        if (pollRes == null || pollRes.getSingleValue() == null) {
            return null;
        }
        Long pollId = null;
        boolean viewVoters = false;
        try {
            pollId = (Long)this.developerHelperService.convert(pollRes.getSingleValue(), Long.class);
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException("Invalid: pollId must be a long number: " + e.getMessage(), e);
        }
        Poll poll = this.pollListManager.getPollById(pollId);
        if (poll == null) {
            throw new IllegalArgumentException("pollId (" + pollId + ") is invalid and does not match any known polls");
        }
        List votes = this.pollVoteManager.getAllVotesForPoll(poll);
        String userId = this.developerHelperService.getUserIdFromRef(currentUser);
        if (this.developerHelperService.isUserAdmin(currentUser)) {
            viewVoters = true;
        } else if (!this.developerHelperService.isEntityRequestInternal(ref.toString()) && !this.pollListManager.isAllowedViewResults(poll, userId)) {
            throw new SecurityException("User (" + currentUser + ") cannot view vote (" + ref + ")");
        }
        if (viewVoters) {
            return votes;
        }
        return this.anonymizeVotes(votes);
    }

    private List<?> anonymizeVotes(List<Vote> votes) {
        ArrayList<Vote> ret = new ArrayList<Vote>();
        String userId = this.developerHelperService.getCurrentUserId();
        for (int i = 0; i < votes.size(); ++i) {
            Vote vote = votes.get(i);
            if (!userId.equals(vote.getUserId())) {
                Vote newVote = new Vote();
                newVote.setPollId(vote.getPollId());
                newVote.setPollOption(vote.getPollOption());
                newVote.setSubmissionId(vote.getSubmissionId());
                ret.add(newVote);
                continue;
            }
            ret.add(vote);
        }
        return ret;
    }

    @EntityCustomAction(action="vote", viewKey="new")
    public List<Vote> vote(EntityView view, EntityReference ref, String prefix, Search search, OutputStream out, Map<String, Object> params) {
        Long pollId = null;
        try {
            pollId = Long.valueOf((String)params.get("pollId"));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("No pollId found.");
        }
        String userId = this.developerHelperService.getCurrentUserId();
        if (userId == null) {
            throw new SecurityException("user must be logged in to create new votes");
        }
        Poll poll = this.pollListManager.getPollById(pollId, false);
        if (poll == null) {
            throw new IllegalArgumentException("No poll found to update for the given reference: " + ref);
        }
        if (!this.pollVoteManager.isUserAllowedVote(userId, poll.getPollId(), false)) {
            throw new SecurityException("User (" + userId + ") is not allowed to vote in this poll (" + poll.getPollId() + ")");
        }
        HashSet<String> optionIds = new HashSet<String>();
        Object param = params.get("pollOption");
        if (param == null) {
            throw new IllegalArgumentException("At least one pollOption parameter must be provided to vote.");
        }
        if (param instanceof String) {
            optionIds.add((String)param);
        } else if (param instanceof Iterable) {
            for (Object o : (Iterable)param) {
                if (o instanceof String) {
                    optionIds.add((String)o);
                    continue;
                }
                throw new IllegalArgumentException("Each pollOption must be a String, not " + o.getClass().getName());
            }
        } else if (param instanceof Object[]) {
            for (Object o : (Object[])param) {
                if (!(o instanceof String)) {
                    throw new IllegalArgumentException("Each pollOption must be a String, not " + o.getClass().getName());
                }
                optionIds.add((String)o);
            }
        } else {
            throw new IllegalArgumentException("pollOption must be String, String[] or List<String>, not " + param.getClass().getName());
        }
        HashMap<Long, Option> options = new HashMap<Long, Option>();
        for (String optionId : optionIds) {
            try {
                Option option = this.pollListManager.getOptionById(Long.valueOf(optionId));
                if (!poll.getPollId().equals(option.getPollId())) {
                    throw new Exception();
                }
                options.put(option.getOptionId(), option);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid pollOption: " + optionId);
            }
        }
        if (options.size() < poll.getMinOptions()) {
            throw new IllegalArgumentException("You must provide at least " + poll.getMinOptions() + " options, not " + options.size() + ".");
        }
        if (options.size() > poll.getMaxOptions()) {
            throw new IllegalArgumentException("You may provide at most " + poll.getMaxOptions() + " options, not " + options.size() + ".");
        }
        UsageSession usageSession = this.usageSessionService.getSession();
        ArrayList<Vote> votes = new ArrayList<Vote>();
        for (Option option : options.values()) {
            boolean saved;
            Vote vote = new Vote();
            vote.setVoteDate(new Date());
            vote.setUserId(userId);
            vote.setPollId(poll.getPollId());
            vote.setPollOption(option.getOptionId());
            if (vote.getSubmissionId() == null) {
                String sid = userId + ":" + UUID.randomUUID();
                vote.setSubmissionId(sid);
            }
            if (usageSession != null) {
                vote.setIp(usageSession.getIpAddress());
            }
            if (!(saved = this.pollVoteManager.saveVote(vote))) {
                throw new IllegalStateException("Unable to save vote (" + vote + ") for user (" + userId + "): " + ref);
            }
            votes.add(vote);
        }
        return votes;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json", "form"};
    }

    public String[] getHandledInputFormats() {
        return new String[]{"xml", "json", "html"};
    }

    private Vote getVoteById(String id) {
        Long voteId;
        try {
            voteId = Long.valueOf(id);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot convert id (" + id + ") to long: " + e.getMessage(), e);
        }
        Vote vote = this.pollVoteManager.getVoteById(voteId);
        return vote;
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        throw new UnsupportedOperationException("Votes cannot currently be updated: " + ref);
    }
}

