/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.producers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.poll.logic.ExternalLogic;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.logic.PollVoteManager;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Poll;
import org.sakaiproject.poll.tool.params.OptionViewParameters;
import org.sakaiproject.poll.tool.params.PollViewParameters;
import org.sakaiproject.poll.tool.params.VoteBean;
import org.sakaiproject.util.FormattedText;
import uk.org.ponder.messageutil.MessageLocator;
import uk.org.ponder.messageutil.TargettedMessage;
import uk.org.ponder.messageutil.TargettedMessageList;
import uk.org.ponder.rsf.components.UIBoundBoolean;
import uk.org.ponder.rsf.components.UIBoundString;
import uk.org.ponder.rsf.components.UIBranchContainer;
import uk.org.ponder.rsf.components.UICommand;
import uk.org.ponder.rsf.components.UIComponent;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIELBinding;
import uk.org.ponder.rsf.components.UIForm;
import uk.org.ponder.rsf.components.UIInput;
import uk.org.ponder.rsf.components.UIInternalLink;
import uk.org.ponder.rsf.components.UIMessage;
import uk.org.ponder.rsf.components.UIOutputMany;
import uk.org.ponder.rsf.components.UISelect;
import uk.org.ponder.rsf.components.UISelectChoice;
import uk.org.ponder.rsf.components.UISelectLabel;
import uk.org.ponder.rsf.components.UIVerbatim;
import uk.org.ponder.rsf.components.decorators.DecoratorList;
import uk.org.ponder.rsf.components.decorators.UIDecorator;
import uk.org.ponder.rsf.components.decorators.UILabelTargetDecorator;
import uk.org.ponder.rsf.components.decorators.UITooltipDecorator;
import uk.org.ponder.rsf.evolvers.FormatAwareDateInputEvolver;
import uk.org.ponder.rsf.evolvers.TextInputEvolver;
import uk.org.ponder.rsf.flow.ARIResult;
import uk.org.ponder.rsf.flow.ActionResultInterceptor;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCase;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCaseReporter;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.AnyViewParameters;
import uk.org.ponder.rsf.viewstate.SimpleViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParamsReporter;

public class AddPollProducer
implements ViewComponentProducer,
NavigationCaseReporter,
ViewParamsReporter,
ActionResultInterceptor {
    public static final String VIEW_ID = "voteAdd";
    private PollListManager pollListManager;
    private MessageLocator messageLocator;
    private static final Log LOG = LogFactory.getLog(AddPollProducer.class);
    private VoteBean voteBean;
    private TextInputEvolver richTextEvolver;
    private TargettedMessageList tml;
    private ExternalLogic externalLogic;
    private PollVoteManager pollVoteManager;
    private FormatAwareDateInputEvolver dateevolver;

    public String getViewID() {
        return VIEW_ID;
    }

    public void setMessageLocator(MessageLocator messageLocator) {
        this.messageLocator = messageLocator;
    }

    public void setPollListManager(PollListManager pollListManager) {
        this.pollListManager = pollListManager;
    }

    public void setVoteBean(VoteBean vb) {
        this.voteBean = vb;
    }

    public void setRichTextEvolver(TextInputEvolver richTextEvolver) {
        this.richTextEvolver = richTextEvolver;
    }

    public void setTargettedMessageList(TargettedMessageList tml) {
        this.tml = tml;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void setPollVoteManager(PollVoteManager pvm) {
        this.pollVoteManager = pvm;
    }

    public void setDateEvolver(FormatAwareDateInputEvolver dateevolver) {
        this.dateevolver = dateevolver;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker checker) {
        UIInput itemDescr;
        String currentuserid = this.externalLogic.getCurrentUserId();
        PollViewParameters ecvp = (PollViewParameters)viewparams;
        Poll poll = null;
        boolean isNew = true;
        UIForm newPoll = UIForm.make((UIContainer)tofill, (String)"add-poll-form");
        LOG.debug((Object)("Poll of id: " + ecvp.id));
        if (ecvp.id == null || "New 0".equals(ecvp.id)) {
            UIMessage.make((UIContainer)tofill, (String)"new_poll_title", (String)"new_poll_title");
            LOG.debug((Object)"this is a new poll");
            poll = new Poll();
        } else {
            UIMessage.make((UIContainer)tofill, (String)"new_poll_title", (String)"new_poll_title_edit");
            String strId = ecvp.id;
            LOG.debug((Object)("got id of " + strId));
            poll = this.pollListManager.getPollById(Long.valueOf(strId));
            this.voteBean.setPoll(poll);
            newPoll.parameters.add((Object)new UIELBinding("#{poll.pollId}", (Object)poll.getPollId()));
            isNew = false;
        }
        if (!this.externalLogic.isUserAdmin() && !this.externalLogic.isAllowedInLocation("poll.add", this.externalLogic.getCurrentLocationReference(), this.externalLogic.getCurrentuserReference())) {
            this.tml.addMessage(new TargettedMessage("new_poll_noperms"));
            return;
        }
        if (!isNew) {
            UIBranchContainer actionBlock = UIBranchContainer.make((UIContainer)newPoll, (String)"option-headers:");
            UIMessage.make((UIContainer)actionBlock, (String)"options-title", (String)"new_poll_option_title");
            UIInternalLink.make((UIContainer)actionBlock, (String)"option-add", (UIBoundString)UIMessage.make((String)"new_poll_option_add"), (ViewParameters)new OptionViewParameters("pollOption", null, poll.getPollId().toString()));
            List votes = this.pollVoteManager.getAllVotesForPoll(poll);
            if (votes != null && votes.size() > 0) {
                LOG.debug((Object)("Poll has " + votes.size() + " votes"));
                UIBranchContainer errorRow = UIBranchContainer.make((UIContainer)tofill, (String)"error-row:", (String)"0");
                UIMessage.make((UIContainer)errorRow, (String)"error", (String)"warn_poll_has_votes");
            }
            List options = this.pollListManager.getVisibleOptionsForPoll(poll.getPollId());
            for (int i = 0; i < options.size(); ++i) {
                Option o = (Option)options.get(i);
                UIBranchContainer oRow = UIBranchContainer.make((UIContainer)actionBlock, (String)"options-row:", (String)o.getOptionId().toString());
                UIVerbatim.make((UIContainer)oRow, (String)"options-name", (Object)o.getOptionText());
                UIInternalLink editOption = UIInternalLink.make((UIContainer)oRow, (String)"option-edit", (UIBoundString)UIMessage.make((String)"new_poll_option_edit"), (ViewParameters)new OptionViewParameters("pollOption", o.getOptionId().toString()));
                editOption.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("new_poll_option_edit") + ":" + FormattedText.convertFormattedTextToPlaintext((String)o.getOptionText())));
                UIInternalLink deleteOption = UIInternalLink.make((UIContainer)oRow, (String)"option-delete", (UIBoundString)UIMessage.make((String)"new_poll_option_delete"), (ViewParameters)new OptionViewParameters("pollOptionDelete", o.getOptionId().toString()));
                deleteOption.decorators = new DecoratorList((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("new_poll_option_delete") + ":" + FormattedText.convertFormattedTextToPlaintext((String)o.getOptionText())));
            }
        }
        UIMessage.make((UIContainer)tofill, (String)"new-poll-descr", (String)"new_poll_title");
        UIMessage.make((UIContainer)tofill, (String)"new-poll-question-label", (String)"new_poll_question_label");
        UIMessage pollDescr = UIMessage.make((UIContainer)tofill, (String)"new-poll-descr-label", (String)"new_poll_descr_label");
        UIMessage.make((UIContainer)tofill, (String)"new-poll-descr-label2", (String)"new_poll_descr_label2");
        UIMessage.make((UIContainer)tofill, (String)"new-poll-limits", (String)"new_poll_limits");
        UIInput.make((UIContainer)newPoll, (String)"new-poll-text", (String)"#{poll.text}", (String)poll.getText());
        if (!this.externalLogic.isMobileBrowser()) {
            itemDescr = UIInput.make((UIContainer)newPoll, (String)"newpolldescr:", (String)"#{poll.details}", (String)poll.getDetails());
            this.richTextEvolver.evolveTextInput(itemDescr);
            UILabelTargetDecorator.targetLabel((UIComponent)pollDescr, (UIComponent)itemDescr);
        } else {
            itemDescr = UIInput.make((UIContainer)newPoll, (String)"newpolldescr_mobile", (String)"#{poll.details}", (String)poll.getDetails());
            UILabelTargetDecorator.targetLabel((UIComponent)pollDescr, (UIComponent)itemDescr);
        }
        UIInput voteOpen = UIInput.make((UIContainer)newPoll, (String)"openDate:", (String)"poll.voteOpen");
        UIInput voteClose = UIInput.make((UIContainer)newPoll, (String)"closeDate:", (String)"poll.voteClose");
        this.dateevolver.setStyle("date time input");
        this.dateevolver.evolveDateInput(voteOpen, poll.getVoteOpen());
        this.dateevolver.evolveDateInput(voteClose, poll.getVoteClose());
        UIMessage.make((UIContainer)newPoll, (String)"poll_access_label", (String)"new_poll_access_label");
        UIBoundBoolean.make((UIContainer)newPoll, (String)"access-public", (String)"poll.isPublic", (boolean)poll.getIsPublic());
        String[] minVotes = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
        String[] maxVotes = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
        UISelect min = UISelect.make((UIContainer)newPoll, (String)"min-votes", (String[])minVotes, (String)"#{poll.minOptions}", (String)Integer.toString(poll.getMinOptions()));
        UISelect max = UISelect.make((UIContainer)newPoll, (String)"max-votes", (String[])maxVotes, (String)"#{poll.maxOptions}", (String)Integer.toString(poll.getMaxOptions()));
        String[] values = new String[]{"open", "afterVoting", "afterClosing", "never"};
        String[] labels = new String[]{this.messageLocator.getMessage("new_poll_open"), this.messageLocator.getMessage("new_poll_aftervoting"), this.messageLocator.getMessage("new_poll_afterClosing"), this.messageLocator.getMessage("new_poll_never")};
        UISelect radioselect = UISelect.make((UIContainer)newPoll, (String)"release-select", (String[])values, (String)"#{poll.displayResult}", (String)poll.getDisplayResult());
        radioselect.optionnames = UIOutputMany.make((String[])labels);
        String selectID = radioselect.getFullID();
        UIMessage.make((UIContainer)newPoll, (String)"add_results_label", (String)"new_poll_results_label");
        for (int i = 0; i < values.length; ++i) {
            UIBranchContainer radiobranch = UIBranchContainer.make((UIContainer)newPoll, (String)"releaserow:", (String)Integer.toString(i));
            UISelectChoice choice = UISelectChoice.make((UIContainer)radiobranch, (String)"release", (String)selectID, (int)i);
            UISelectLabel lb = UISelectLabel.make((UIContainer)radiobranch, (String)"releaseLabel", (String)selectID, (int)i);
            UILabelTargetDecorator.targetLabel((UIComponent)lb, (UIComponent)choice);
        }
        LOG.debug((Object)"About to close the form");
        newPoll.parameters.add((Object)new UIELBinding("#{poll.owner}", (Object)currentuserid));
        String siteId = this.externalLogic.getCurrentLocationId();
        newPoll.parameters.add((Object)new UIELBinding("#{poll.siteId}", (Object)siteId));
        if (isNew || poll.getPollOptions() == null || poll.getPollOptions().size() == 0) {
            UICommand.make((UIContainer)newPoll, (String)"submit-new-poll", (UIBoundString)UIMessage.make((String)"new_poll_saveoption"), (String)"#{pollToolBean.processActionAdd}");
        } else {
            UICommand.make((UIContainer)newPoll, (String)"submit-new-poll", (UIBoundString)UIMessage.make((String)"new_poll_submit"), (String)"#{pollToolBean.processActionAdd}");
        }
        UICommand cancel = UICommand.make((UIContainer)newPoll, (String)"cancel", (UIBoundString)UIMessage.make((String)"new_poll_cancel"), (String)"#{pollToolBean.cancel}");
        cancel.parameters.add((Object)new UIELBinding("#{voteCollection.submissionStatus}", (Object)"cancel"));
        LOG.debug((Object)"Finished generating view");
    }

    public List<NavigationCase> reportNavigationCases() {
        ArrayList<NavigationCase> togo = new ArrayList<NavigationCase>();
        togo.add(new NavigationCase(null, (AnyViewParameters)new SimpleViewParameters(VIEW_ID)));
        togo.add(new NavigationCase("added", (AnyViewParameters)new SimpleViewParameters("votePolls")));
        togo.add(new NavigationCase("option", (AnyViewParameters)new OptionViewParameters("pollOption", null, null)));
        togo.add(new NavigationCase("cancel", (AnyViewParameters)new SimpleViewParameters("votePolls")));
        return togo;
    }

    public ViewParameters getViewParameters() {
        return new PollViewParameters();
    }

    public void interceptActionResult(ARIResult result, ViewParameters incoming, Object actionReturn) {
        if (LOG.isDebugEnabled() && actionReturn != null) {
            LOG.debug((Object)("actionReturn is of type " + actionReturn.getClass()));
        }
        if (actionReturn == null) {
            return;
        }
        Poll poll = null;
        if (actionReturn instanceof Poll) {
            poll = (Poll)actionReturn;
        } else {
            PollViewParameters ecvp = (PollViewParameters)incoming;
            if (null == ecvp || null == ecvp.id) {
                return;
            }
            poll = this.pollListManager.getPollById(Long.valueOf(ecvp.id));
        }
        if (poll == null) {
            return;
        }
        LOG.debug((Object)("Action result got poll: " + poll.getPollId()));
        LOG.debug((Object)("resulting view is: " + result.resultingView));
        result.resultingView = poll.getPollOptions() == null || poll.getPollOptions().size() == 0 ? new OptionViewParameters("pollOption", null, poll.getPollId().toString()) : new SimpleViewParameters("votePolls");
    }
}

