/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.validators;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.util.PollUtils;
import org.sakaiproject.util.FormattedText;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class OptionValidator
implements Validator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public String submissionStatus;

    public boolean supports(Class clazz) {
        return clazz.equals(Option.class);
    }

    public void validate(Object obj, Errors errors) {
        Option option = (Option)obj;
        String stripText = null;
        if (null != option.getOptionText()) {
            stripText = FormattedText.convertFormattedTextToPlaintext((String)option.getOptionText()).trim();
        }
        this.logger.debug((Object)("validating Option with id:" + option.getOptionId()));
        if (option.getStatus() != null && (option.getStatus().equals("cancel") || option.getStatus().equals("delete"))) {
            return;
        }
        if (option.getOptionText() == null || option.getOptionText().trim().length() == 0 || stripText == null || stripText.length() == 0) {
            this.logger.debug((Object)"OptionText is empty!");
            errors.reject("option_empty", "option empty");
            return;
        }
        String text = option.getOptionText();
        text = PollUtils.cleanupHtmlPtags((String)text);
        text = text.replace("&nbsp;", "");
        text = StringEscapeUtils.unescapeHtml((String)text).trim();
        this.logger.debug((Object)("text to validate is: " + text));
        if (text.trim().length() == 0) {
            this.logger.debug((Object)"OptionText is empty! (after excaping html)");
            errors.reject("option_empty", "option empty");
            return;
        }
    }
}

