/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.params;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.poll.logic.ExternalLogic;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.logic.PollVoteManager;
import org.sakaiproject.poll.model.Option;
import org.sakaiproject.poll.model.Poll;
import org.sakaiproject.poll.model.Vote;
import org.sakaiproject.poll.model.VoteCollection;
import org.sakaiproject.poll.tool.params.VoteBean;
import org.sakaiproject.poll.util.PollUtils;
import org.sakaiproject.util.FormattedText;
import uk.org.ponder.localeutil.LocaleGetter;
import uk.org.ponder.messageutil.MessageLocator;
import uk.org.ponder.messageutil.TargettedMessage;
import uk.org.ponder.messageutil.TargettedMessageList;

public class PollToolBean {
    private static final Log LOG = LogFactory.getLog(PollToolBean.class);
    public static final String HANDLE_DELETE_OPTION_DO_NOTHING = "do-nothing";
    public static final String HANDLE_DELETE_OPTION_RETURN_VOTES = "return-votes";
    public String siteID;
    public Option option;
    private VoteCollection voteCollection;
    public String openDay;
    public String openMonth;
    public String openYear;
    public String openHour;
    public String openMinutes;
    public String openAmPm;
    public String closeDay;
    public String closeMonth;
    public String closeYear;
    public String closeHour;
    public String closeMinutes;
    public String closeAmPm;
    private VoteBean voteBean;
    public Long[] deleteids;
    public String submissionStatus;
    private PollVoteManager pollVoteManager;
    private String handleOrphanVotes;
    public Map perms = null;
    private PollListManager manager;
    private ExternalLogic externalLogic;
    private Poll poll;
    private LocaleGetter localegetter;
    private TargettedMessageList messages;
    private MessageLocator messageLocator;

    public void setRoleperms(Map perms) {
        this.perms = perms;
    }

    public void setPollListManager(PollListManager manager) {
        this.manager = manager;
    }

    public void setPollVoteManager(PollVoteManager pvm) {
        this.pollVoteManager = pvm;
    }

    public void setVoteBean(VoteBean vb) {
        this.voteBean = vb;
    }

    public void setVoteCollection(VoteCollection vc) {
        this.voteCollection = vc;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public void setOption(Option o) {
        this.option = o;
    }

    public void setPoll(Poll p) {
        this.poll = p;
    }

    public void setLocaleGetter(LocaleGetter localegetter) {
        this.localegetter = localegetter;
    }

    public void setMessages(TargettedMessageList messages) {
        this.messages = messages;
    }

    public void setMessageLocator(MessageLocator messageLocator) {
        this.messageLocator = messageLocator;
    }

    public Poll processActionAdd() {
        boolean isNew = true;
        if (this.poll.getPollId() != null) {
            LOG.debug((Object)("Actualy updating poll " + this.poll.getPollId()));
            isNew = false;
            LOG.debug((Object)(" newPoll is " + this.poll.getText() + " while poll text is " + this.poll.getText()));
            if (this.poll.getText().equals("") && this.poll.getText() != null) {
                this.poll.setText(this.poll.getText());
            }
            if (this.poll.getDetails().equals("") && this.poll.getDetails() != null) {
                this.poll.setDetails(this.poll.getDetails());
            }
        }
        LOG.debug((Object)("Poll opens: " + this.poll.getVoteOpen() + " and closes: " + this.poll.getVoteClose()));
        if (this.poll.getVoteOpen().after(this.poll.getVoteClose())) {
            LOG.debug((Object)"Poll closes before it opens");
            this.messages.addMessage(new TargettedMessage("close_before_open"));
            throw new IllegalArgumentException("close_before_open");
        }
        if (this.poll.getMinOptions() > this.poll.getMaxOptions()) {
            LOG.debug((Object)"Min options greater than max options");
            this.messages.addMessage(new TargettedMessage("min_greater_than_max", " min greater than max"));
            throw new IllegalArgumentException("min_greater_than_max");
        }
        if (this.poll.getText().trim() == null || this.poll.getText().length() == 0) {
            LOG.debug((Object)"Poll question is Empty!");
            this.messages.addMessage(new TargettedMessage("error_no_text", "no text"));
            throw new IllegalArgumentException("error_no_text");
        }
        this.poll.setDetails(PollUtils.cleanupHtmlPtags((String)FormattedText.processFormattedText((String)this.poll.getDetails(), (StringBuilder)new StringBuilder())));
        LOG.debug((Object)("about to save poll " + this.poll));
        this.manager.savePoll(this.poll);
        LOG.info((Object)("Poll saved with id of " + this.poll.getPollId()));
        if (!isNew) {
            this.poll.setOptions(this.manager.getOptionsForPoll(this.poll));
        }
        this.voteBean.poll = this.poll;
        return this.poll;
    }

    public void processActionDelete() {
        for (int i = 0; i < this.deleteids.length; ++i) {
            Poll todelete = this.manager.getPollById(Long.valueOf(this.deleteids[i]));
            try {
                this.manager.deletePoll(todelete);
                continue;
            }
            catch (SecurityException e) {
                LOG.error((Object)(" Permission Error" + e));
            }
        }
    }

    public VoteCollection processActionVote() {
        LOG.debug((Object)("vote is on poll " + this.voteCollection.getPollId()));
        Poll poll = this.manager.getPollById(this.voteCollection.getPollId());
        VoteCollection votes = this.voteCollection;
        LOG.info((Object)("got vote collection with id " + votes.getId()));
        ArrayList<String> options = new ArrayList<String>();
        if (votes.getOptionsSelected() == null && votes.getOption() != null) {
            options.add(votes.getOption());
        } else if (votes.getOptionsSelected() != null) {
            for (int i = 0; i < votes.getOptionsSelected().length; ++i) {
                options.add(votes.getOptionsSelected()[i]);
            }
        }
        if (options.size() == 0 && poll.getMinOptions() == 0) {
            LOG.warn((Object)"this is a spoiled vote");
            options.add("0");
        }
        ArrayList<Vote> votesToSave = new ArrayList<Vote>();
        for (int i = 0; i < options.size(); ++i) {
            LOG.debug((Object)("this vote is for option " + options.get(i)));
            Option opt = new Option(Long.valueOf((String)options.get(i)));
            Vote vote = new Vote(poll, opt, votes.getId());
            if (vote.getIp() == null) {
                LOG.warn((Object)"IP is null");
                vote.setIp("Nothing");
            }
            votesToSave.add(vote);
        }
        this.pollVoteManager.saveVoteList(votesToSave);
        this.voteBean.voteCollection = votes;
        LOG.debug((Object)"Votes saved about to return");
        return votes;
    }

    public String proccessActionAddOption() {
        if ("cancel".equals(this.submissionStatus)) {
            return "cancel";
        }
        LOG.debug((Object)("adding option with text " + this.option.getOptionText()));
        if (this.option.getOptionText() == null || this.option.getOptionText().trim().length() == 0) {
            // empty if block
        }
        StringBuilder sb = new StringBuilder();
        this.option.setOptionText(FormattedText.processFormattedText((String)this.option.getOptionText(), (StringBuilder)sb, (boolean)true, (boolean)true));
        String text = this.option.getOptionText();
        text = PollUtils.cleanupHtmlPtags((String)text);
        this.option.setOptionText(text);
        this.manager.saveOption(this.option);
        LOG.debug((Object)("Succesuly save option with id" + this.option.getId()));
        if ("option".equals(this.submissionStatus)) {
            return "option";
        }
        return "Saved";
    }

    public Poll proccessActionDeleteOption() {
        LOG.info((Object)("about to delete option " + this.option.getId()));
        Long pollId = this.option.getPollId();
        List votes = this.pollVoteManager.getAllVotesForOption(this.option);
        if (votes != null && votes.size() > 0) {
            if (HANDLE_DELETE_OPTION_RETURN_VOTES.equals(this.getHandleOrphanVotes())) {
                HashSet<String> userEids = new HashSet<String>();
                this.manager.deleteOption(this.option);
                for (Vote vote : votes) {
                    String userId = vote.getUserId();
                    if (userId != null) {
                        String userEid = this.externalLogic.getUserEidFromId(userId);
                        userEids.add(userEid);
                    }
                    this.pollVoteManager.deleteVote(vote);
                }
                this.sendOptionDeletedNotification(userEids.toArray(new String[0]));
            } else {
                Option persistentOption = this.manager.getOptionById(this.option.getOptionId());
                this.manager.deleteOption(persistentOption, true);
            }
        } else {
            this.manager.deleteOption(this.option);
        }
        Poll poll = this.manager.getPollById(pollId);
        this.voteBean.setPoll(poll);
        return poll;
    }

    public String cancel() {
        return "cancel";
    }

    public void setHandleOrphanVotes(String handleOrphanVotes) {
        this.handleOrphanVotes = handleOrphanVotes;
    }

    public String getHandleOrphanVotes() {
        return this.handleOrphanVotes;
    }

    private void sendOptionDeletedNotification(String[] userEids) {
        Poll poll = this.manager.getPollById(this.option.getPollId());
        String siteTitle = this.externalLogic.getSiteTile(poll.getSiteId());
        this.externalLogic.notifyDeletedOption(Arrays.asList(userEids), siteTitle, poll.getPollText());
    }
}

