/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.poll.tool.validators;

import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.poll.logic.ExternalLogic;
import org.sakaiproject.poll.logic.PollListManager;
import org.sakaiproject.poll.logic.PollVoteManager;
import org.sakaiproject.poll.model.Poll;
import org.sakaiproject.poll.model.VoteCollection;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class VoteValidator
implements Validator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PollVoteManager pollVoteManager;
    private PollListManager manager;
    private ExternalLogic externalLogic;

    public void setPollListManager(PollListManager manager) {
        this.manager = manager;
    }

    public void setPollVoteManager(PollVoteManager pvm) {
        this.pollVoteManager = pvm;
    }

    public void setExternalLogic(ExternalLogic externalLogic) {
        this.externalLogic = externalLogic;
    }

    public boolean supports(Class clazz) {
        return clazz.equals(VoteCollection.class);
    }

    public void validate(Object obj, Errors errors) {
        VoteCollection votes = (VoteCollection)obj;
        this.logger.debug((Object)("we are validating a vote collection of " + votes + " for poll " + votes.getPollId()));
        if (votes.getSubmissionStatus().equals("cancel")) {
            return;
        }
        Poll poll = this.manager.getPollById(votes.getPollId());
        this.logger.debug((Object)("this is a vote for " + poll.getText()));
        ArrayList<String> options = new ArrayList<String>();
        if (!poll.getVoteClose().after(new Date()) || !new Date().after(poll.getVoteOpen())) {
            this.logger.warn((Object)"poll is closed!");
            errors.reject("vote_closed", "vote closed");
            return;
        }
        if (!this.externalLogic.isUserAdmin() && !this.pollVoteManager.pollIsVotable(poll)) {
            this.logger.error((Object)("attempt to vote in " + poll.getReference() + " by unauthorized user"));
            errors.reject("vote_noperm", "no permissions");
            return;
        }
        if (votes.getOptionsSelected() == null && votes.getOption() == null && poll.getMinOptions() > 0) {
            this.logger.debug((Object)"there seems to be no vote on this poll");
            String errStr = Integer.valueOf(poll.getMinOptions()).toString();
            errors.reject("error_novote", new Object[]{errStr}, "no vote");
            return;
        }
        if (votes.getOptionsSelected() == null && votes.getOption() == null && poll.getMinOptions() == 0) {
            options.add("0");
        }
        if (votes.getOptionsSelected() == null && votes.getOption() != null) {
            options.add(votes.getOption());
        } else if (votes.getOptionsSelected() != null) {
            for (int i = 0; i < votes.getOptionsSelected().length; ++i) {
                options.add(votes.getOptionsSelected()[i]);
            }
        }
        this.logger.debug((Object)("options selected is " + options.size()));
        if (this.pollVoteManager.userHasVoted(poll.getPollId()) && poll.getLimitVoting()) {
            errors.reject("vote_hasvoted", "has voted");
            return;
        }
        if (poll.getMaxOptions() == poll.getMinOptions() && options.size() != poll.getMaxOptions()) {
            this.logger.debug((Object)"exact match failure!");
            String errStr = Integer.valueOf(poll.getMinOptions()).toString();
            errors.reject("error_exact_required", new Object[]{errStr}, "exact required");
        } else if (options.size() > poll.getMaxOptions()) {
            this.logger.debug((Object)"votes are for more than allowed!");
            String errStr = Integer.valueOf(poll.getMaxOptions()).toString();
            errors.reject("error_tomany_votes", new Object[]{errStr}, "to many votes");
        } else if (options.size() < poll.getMinOptions()) {
            this.logger.debug((Object)"votes are for fewer than required!");
            String errStr = Integer.valueOf(poll.getMinOptions()).toString();
            errors.reject("error_tofew_votes", new Object[]{errStr}, "to few");
        }
    }
}

