/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.chat.entity;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.sakaiproject.component.api.ComponentManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.EntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Createable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Inputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.portal.chat.entity.PCServiceEntityProvider;
import org.sakaiproject.presence.api.PresenceService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;

public class PCServiceEntityProvider
extends AbstractEntityProvider
implements Receiver,
EntityProvider,
Createable,
Inputable,
Outputable,
ActionsExecutable,
AutoRegisterEntityProvider {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private static ResourceLoader rb = new ResourceLoader("portal-chat");
    public static final String ENTITY_PREFIX = "portal-chat";
    private final String HEARTBEAT_PREAMBLE = "heartbeat:";
    private final String MESSAGE_PREAMBLE = "message:";
    private final String CLEAR_PREAMBLE = "clear:";
    private boolean connectionsAvailable = true;
    private Object profileServiceObject = null;
    private Method getConnectionsForUserMethod = null;
    private Method getUuidMethod = null;
    private Method setProfileMethod = null;
    private Method setPrivacyMethod = null;
    private Method setPreferencesMethod = null;
    private UserDirectoryService userDirectoryService;
    private EmailService emailService;
    private PresenceService presenceService;
    private ServerConfigurationService serverConfigurationService;
    private DeveloperHelperService developerService = null;
    private Map<String, List<UserMessage>> messageMap = new HashMap();
    private Map<String, Date> heartbeatMap;
    private Channel clusterChannel = null;
    private boolean clustered = false;
    private String portalUrl;
    private String service;
    private String serverName;

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setPresenceService(PresenceService presenceService) {
        this.presenceService = presenceService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setDeveloperService(DeveloperHelperService developerService) {
        this.developerService = developerService;
    }

    public void init() {
        this.service = this.serverConfigurationService.getString("ui.service", "Sakai");
        this.portalUrl = this.serverConfigurationService.getServerUrl() + "/portal";
        this.serverName = this.serverConfigurationService.getServerName();
        try {
            String channelId = this.serverConfigurationService.getString("portalchat.cluster.channel");
            if (channelId != null && !channelId.equals("")) {
                File jgroupsConfig = new File(this.serverConfigurationService.getSakaiHomePath() + File.separator + "jgroups-config.xml");
                if (jgroupsConfig.exists()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Using jgroups config file: " + jgroupsConfig.getAbsolutePath()));
                    }
                    this.clusterChannel = new JChannel(jgroupsConfig);
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"No jgroups config file. Using jgroup defaults.");
                    }
                    this.clusterChannel = new JChannel();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("JGROUPS PROTOCOL: " + this.clusterChannel.getProtocolStack().printProtocolSpecAsXML()));
                }
                this.clusterChannel.setReceiver((Receiver)this);
                this.clusterChannel.connect(channelId);
                this.clusterChannel.setDiscardOwnMessages(true);
                this.clustered = true;
                this.logger.info((Object)("Portal chat is connected on JGroups channel '" + channelId + "'"));
            } else {
                this.logger.info((Object)"No 'portalchat.cluster.channel' specified in sakai.properties. JGroups will not be used and chat messages will not be replicated.");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error creating JGroups channel. Chat messages will now NOT BE KEPT IN SYNC", (Throwable)e);
        }
        int heartbeatMapSize = this.serverConfigurationService.getInt("portalchat.heartbeatmap.size", 1000);
        this.heartbeatMap = new ConcurrentHashMap(heartbeatMapSize, 0.75f, 64);
        ComponentManager componentManager = org.sakaiproject.component.cover.ComponentManager.getInstance();
        this.profileServiceObject = componentManager.get("org.sakaiproject.profile2.service.ProfileService");
        if (this.profileServiceObject != null) {
            try {
                this.getConnectionsForUserMethod = this.profileServiceObject.getClass().getMethod("getConnectionsForUser", String.class);
                try {
                    Class<?> clazz;
                    Class<?> personClass = Class.forName("org.sakaiproject.profile2.model.Person");
                    try {
                        this.getUuidMethod = personClass.getMethod("getUuid", null);
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)"Failed to set getUuidMethod");
                    }
                    try {
                        clazz = Class.forName("org.sakaiproject.profile2.model.UserProfile");
                        this.setProfileMethod = personClass.getMethod("setProfile", clazz);
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)"Failed to set setProfileMethod");
                    }
                    try {
                        clazz = Class.forName("org.sakaiproject.profile2.model.ProfilePrivacy");
                        this.setPrivacyMethod = personClass.getMethod("setPrivacy", clazz);
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)"Failed to set setPrivacyMethod");
                    }
                    try {
                        clazz = Class.forName("org.sakaiproject.profile2.model.ProfilePreferences");
                        this.setPreferencesMethod = personClass.getMethod("setPreferences", clazz);
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)"Failed to set setPreferencesMethod");
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed to find Person class. Connections will NOT be available in portal chat.", (Throwable)e);
                    this.connectionsAvailable = false;
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Failed to set getConnectionsForUserMethod. Connections will NOT be available in portal chat.");
                this.connectionsAvailable = false;
            }
        } else {
            this.logger.warn((Object)"Failed to find ProfileService interface. Connections will NOT be available in portal chat.");
            this.connectionsAvailable = false;
        }
    }

    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"DESTROY!!!!!");
        }
        if (this.clusterChannel != null && this.clusterChannel.isConnected()) {
            this.clusterChannel.close();
        }
    }

    private List<Object> getConnectionsForUser(String uuid) {
        List<Object> connections = new ArrayList<Object>();
        if (!this.connectionsAvailable) {
            return connections;
        }
        try {
            connections = (List)this.getConnectionsForUserMethod.invoke(this.profileServiceObject, uuid);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to invoke the getConnectionsForUser method. Returning an empty connections list ...", (Throwable)e);
        }
        return connections;
    }

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"txt", "json"};
    }

    public Object getSampleEntity() {
        return new UserMessage(this, null);
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        User currentUser = this.userDirectoryService.getCurrentUser();
        User anon = this.userDirectoryService.getAnonymousUser();
        if (anon.equals(currentUser)) {
            throw new SecurityException("You must be logged in to use this service");
        }
        String to = (String)params.get("to");
        if (to == null) {
            throw new IllegalArgumentException("You must supply a recipient");
        }
        if (to.equals(currentUser.getId())) {
            throw new IllegalArgumentException("You can't chat with yourself");
        }
        Date now = new Date();
        Date lastHeartbeat = null;
        lastHeartbeat = (Date)this.heartbeatMap.get(to);
        if (lastHeartbeat == null) {
            return "OFFLINE";
        }
        if (now.getTime() - lastHeartbeat.getTime() >= 5000L) {
            return "OFFLINE";
        }
        String message = (String)params.get("message");
        if (message == null) {
            throw new IllegalArgumentException("You must supply a message");
        }
        message = StringEscapeUtils.escapeHtml4((String)StringEscapeUtils.escapeEcmaScript((String)message)).replaceAll("\\\\'", "'");
        this.addMessageToMap(new UserMessage(this, currentUser.getId(), to, message, null));
        if (this.clustered) {
            try {
                Message msg = new Message(null, null, (Object)("message:" + currentUser.getId() + ":" + to + ":" + message));
                this.clusterChannel.send(msg);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error sending JGroups message", (Throwable)e);
            }
        }
        return "success";
    }

    public String[] getHandledInputFormats() {
        return new String[]{"html"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EntityCustomAction(action="latestData", viewKey="show")
    public Map<String, Object> handleLatestData(EntityReference ref, Map<String, Object> params) {
        Object uuid;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"handleLatestData");
        }
        User currentUser = this.userDirectoryService.getCurrentUser();
        User anon = this.userDirectoryService.getAnonymousUser();
        if (anon.equals(currentUser)) {
            return new HashMap<String, Object>(0);
        }
        String online = (String)params.get("online");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("online: " + online));
        }
        if (online != null && "true".equals(online)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(currentUser.getEid() + " is online. Stamping their heartbeat ..."));
            }
            this.heartbeatMap.put(currentUser.getId(), new Date());
            if (this.clustered) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"We are clustered. Propagating heartbeat ...");
                }
                Message msg = new Message(null, null, (Object)("heartbeat:" + currentUser.getId()));
                try {
                    this.clusterChannel.send(msg);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Heartbeat message sent.");
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error sending JGroups heartbeat message", (Throwable)e);
                }
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(currentUser.getEid() + " is offline. Removing them from the message map ..."));
            }
            Map msg = this.messageMap;
            synchronized (msg) {
                this.messageMap.remove(currentUser.getId());
            }
            this.sendClearMessage(currentUser.getId());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(currentUser.getEid() + " is offline. Returning an empty data map ..."));
            }
            return new HashMap<String, Object>(0);
        }
        ArrayList<PortalChatUser> presentUsers = new ArrayList<PortalChatUser>();
        String siteId = (String)params.get("siteId");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Site ID: " + siteId));
        }
        if (siteId != null && siteId.length() > 0) {
            String location = siteId + "-presence";
            this.presenceService.setPresence(location);
            List presentSakaiUsers = this.presenceService.getPresentUsers(siteId + "-presence");
            presentSakaiUsers.remove(currentUser);
            for (User user : presentSakaiUsers) {
                presentUsers.add(new PortalChatUser(this, user.getId(), user.getDisplayName()));
            }
        }
        List connections = this.getConnectionsForUser(currentUser.getId());
        ArrayList<Object> onlineConnections = new ArrayList<Object>(connections.size());
        Date now = new Date();
        for (Object personObject : connections) {
            block29: {
                uuid = null;
                try {
                    uuid = (String)this.getUuidMethod.invoke(personObject, null);
                    if (this.setProfileMethod != null) {
                        this.setProfileMethod.invoke(personObject, new Object[]{null});
                    }
                    if (this.setPrivacyMethod != null) {
                        this.setPrivacyMethod.invoke(personObject, new Object[]{null});
                    }
                    if (this.setPreferencesMethod == null) break block29;
                    this.setPreferencesMethod.invoke(personObject, new Object[]{null});
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed to invoke getUuid on a Person instance. Skipping this person ...", (Throwable)e);
                    continue;
                }
            }
            Date lastHeartbeat = null;
            lastHeartbeat = (Date)this.heartbeatMap.get(uuid);
            if (lastHeartbeat == null || now.getTime() - lastHeartbeat.getTime() >= 5000L) continue;
            onlineConnections.add(uuid);
        }
        List messages = new ArrayList();
        String currentUserId = currentUser.getId();
        uuid = this.messageMap;
        synchronized (uuid) {
            if (this.messageMap.containsKey(currentUserId)) {
                messages = (List)this.messageMap.get(currentUserId);
                this.messageMap.remove(currentUserId);
            }
            this.sendClearMessage(currentUserId);
        }
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("connections", connections);
        data.put("messages", messages);
        data.put("online", onlineConnections);
        data.put("presentUsers", presentUsers);
        data.put("connectionsAvailable", this.connectionsAvailable);
        return data;
    }

    private void sendClearMessage(String userId) {
        if (this.clustered) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending messagMap clear message for " + userId + " ..."));
                }
                Message msg = new Message(null, null, (Object)("clear:" + userId));
                this.clusterChannel.send(msg);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error sending JGroups clear message", (Throwable)e);
            }
        }
    }

    @EntityCustomAction(action="ping", viewKey="show")
    public String handlePing(EntityReference ref) {
        User currentUser = this.userDirectoryService.getCurrentUser();
        User anon = this.userDirectoryService.getAnonymousUser();
        if (anon.equals(currentUser)) {
            throw new SecurityException("You must be logged in to use this service");
        }
        String userId = ref.getId();
        try {
            String email = this.userDirectoryService.getUser(userId).getEmail();
            new EmailSender(this, email, rb.getFormattedMessage("email.subject", (Object[])new String[]{this.service}), rb.getFormattedMessage("email.body", (Object[])new String[]{currentUser.getDisplayName(), this.service, this.portalUrl}));
        }
        catch (Exception e) {
            throw new EntityException("Failed to send email", userId);
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageToMap(UserMessage m) {
        Map map = this.messageMap;
        synchronized (map) {
            List current = (List)this.messageMap.get(m.to);
            if (current != null) {
                ArrayList<UserMessage> copy = new ArrayList<UserMessage>(current.size());
                copy.addAll(current);
                copy.add(m);
                this.messageMap.put(m.to, copy);
            } else {
                this.messageMap.put(m.to, Arrays.asList(m));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message msg) {
        Object o = msg.getObject();
        if (o instanceof String) {
            String message = (String)o;
            if (message.startsWith("heartbeat:")) {
                String onlineUserId = message.substring("heartbeat:".length());
                this.heartbeatMap.put(onlineUserId, new Date());
            } else if (message.startsWith("message:")) {
                Address address = this.clusterChannel.getAddress();
                String[] parts = message.split(":");
                String from = parts[1];
                String to = parts[2];
                String m = parts[3];
                this.addMessageToMap(new UserMessage(this, from, to, m, null));
            } else if (message.startsWith("clear:")) {
                String userId = message.substring("clear:".length());
                Map map = this.messageMap;
                synchronized (map) {
                    this.messageMap.remove(userId);
                }
            }
        }
    }

    public void getState(OutputStream arg0) throws Exception {
    }

    public void setState(InputStream arg0) throws Exception {
    }

    public void block() {
    }

    public void suspect(Address arg0) {
    }

    public void unblock() {
    }

    public void viewAccepted(View arg0) {
    }

    static /* synthetic */ String access$200(PCServiceEntityProvider x0) {
        return x0.service;
    }

    static /* synthetic */ String access$300(PCServiceEntityProvider x0) {
        return x0.serverName;
    }

    static /* synthetic */ EmailService access$400(PCServiceEntityProvider x0) {
        return x0.emailService;
    }
}

