/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.editor;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.portal.api.Editor;
import org.sakaiproject.portal.api.EditorRegistry;
import org.sakaiproject.portal.api.PortalService;
import org.sakaiproject.portal.util.ErrorReporter;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.util.EditorConfiguration;
import org.sakaiproject.util.StringUtil;

public class EditorServlet
extends HttpServlet {
    public static final String EDITOR_BOOTSTRAP_JS = "editor-bootstrap.js";
    public static final String EDITOR_JS = "editor.js";
    public static final String EDITOR_LAUNCH_JS = "editor-launch.js";
    public static final PortalService portalService = (PortalService)ComponentManager.get(PortalService.class);
    public static final EditorRegistry editorRegistry = (EditorRegistry)ComponentManager.get(EditorRegistry.class);
    private static Log M_log = LogFactory.getLog(EditorServlet.class);

    public String getServletInfo() {
        return "Sakai Rich-text Editor Support";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        M_log.info((Object)"init()");
    }

    public void destroy() {
        M_log.info((Object)"destroy()");
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block6: {
            try {
                String path = req.getPathInfo();
                if (path == null || path.length() <= 1) {
                    throw new Exception("no path");
                }
                String[] parts = StringUtil.splitFirst((String)path.substring(1), (String)"/");
                String name = parts[0];
                String placementId = req.getParameter("placement");
                ToolConfiguration tool = SiteService.findTool((String)placementId);
                Editor editor = portalService.getActiveEditor((Placement)tool);
                if (EDITOR_JS.equals(name)) {
                    res.sendRedirect(editor.getEditorUrl());
                    break block6;
                }
                if (EDITOR_LAUNCH_JS.equals(name)) {
                    res.sendRedirect(editor.getLaunchUrl());
                    break block6;
                }
                if (EDITOR_BOOTSTRAP_JS.equals(name)) {
                    res.addHeader("Pragma", "no-cache");
                    res.addHeader("Cache-Control", "no-cache");
                    res.addHeader("Content-Type", "text/javascript");
                    PrintWriter out = res.getWriter();
                    out.print("var sakai = sakai || {}; sakai.editor = sakai.editor || {}; \n");
                    out.print("sakai.editor.collectionId = '" + portalService.getBrowserCollectionId((Placement)tool) + "';\n");
                    out.print("sakai.editor.enableResourceSearch = '" + EditorConfiguration.enableResourceSearch() + "';\n");
                    out.print(editor.getPreloadScript());
                    break block6;
                }
                throw new Exception("unrecognized request");
            }
            catch (Throwable t) {
                this.doError(req, res, t);
            }
        }
    }

    protected void doError(HttpServletRequest req, HttpServletResponse res, Throwable t) {
        ErrorReporter err = new ErrorReporter();
        err.report(req, res, t);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }
}

