/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.beans.bullhornhandlers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.hibernate.SessionFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.portal.api.BullhornData;
import org.sakaiproject.portal.beans.bullhornhandlers.AbstractBullhornHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class FriendIgnoreBullhornHandler
extends AbstractBullhornHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendIgnoreBullhornHandler.class);
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalSessionFactory")
    private SessionFactory sessionFactory;
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalTransactionManager")
    private PlatformTransactionManager transactionManager;

    @Override
    public List<String> getHandledEvents() {
        return Arrays.asList("profile.friend.ignore");
    }

    @Override
    public Optional<List<BullhornData>> handleEvent(Event e, Cache<String, Map> countCache) {
        String from = e.getUserId();
        String ref = e.getResource();
        String[] pathParts = ref.split("/");
        final String to = pathParts[2];
        try {
            TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
            transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    FriendIgnoreBullhornHandler.this.sessionFactory.getCurrentSession().createQuery("delete BullhornAlert where event = :event and fromUser = :fromUser").setString("event", "profile.friend.request").setString("fromUser", to).executeUpdate();
                }
            });
        }
        catch (Exception e1) {
            log.error("Failed to delete bullhorn request event", (Throwable)e1);
        }
        countCache.remove((Object)from);
        return Optional.empty();
    }
}

