/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.beans.bullhornhandlers;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.sakaiproject.assignment.api.AssignmentService;
import org.sakaiproject.assignment.api.model.Assignment;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.portal.api.BullhornData;
import org.sakaiproject.portal.beans.bullhornhandlers.AbstractBullhornHandler;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AddAssignmentBullhornHandler
extends AbstractBullhornHandler {
    private static final Logger log = LoggerFactory.getLogger(AddAssignmentBullhornHandler.class);
    @Inject
    private AssignmentService assignmentService;
    @Inject
    private AuthzGroupService authzGroupService;
    @Inject
    private SiteService siteService;

    @Override
    public List<String> getHandledEvents() {
        return Arrays.asList("asn.new.assignment");
    }

    @Override
    public Optional<List<BullhornData>> handleEvent(Event e, Cache<String, Map> countCache) {
        String from = e.getUserId();
        String ref = e.getResource();
        String[] pathParts = ref.split("/");
        String siteId = pathParts[3];
        String assignmentId = pathParts[pathParts.length - 1];
        try {
            Assignment assignment = this.assignmentService.getAssignment(assignmentId);
            Instant openTime = assignment.getOpenDate();
            if (openTime == null || openTime.isBefore(Instant.now())) {
                Site site = this.siteService.getSite(siteId);
                String title = assignment.getTitle();
                Set groupIds = assignment.getGroups();
                Collection groupsUsers = this.authzGroupService.getAuthzUsersInGroups(groupIds);
                ArrayList<BullhornData> bhEvents = new ArrayList<BullhornData>();
                for (String to : site.getUsersIsAllowed("asn.read")) {
                    if (groupIds.size() != 0 && !groupsUsers.contains(to) || from.equals(to) || this.securityService.isSuperUser(to)) continue;
                    String url = this.assignmentService.getDeepLink(siteId, assignmentId, to);
                    bhEvents.add(new BullhornData(from, to, siteId, title, url, false));
                    countCache.remove((Object)to);
                }
                return Optional.of(bhEvents);
            }
        }
        catch (Exception ex) {
            log.error("Failed to find either the assignment or the site", (Throwable)ex);
        }
        return Optional.empty();
    }
}

