/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.beans.bullhornhandlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.portal.api.BullhornData;
import org.sakaiproject.portal.beans.bullhornhandlers.AbstractBullhornHandler;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FriendMessageBullhornHandler
extends AbstractBullhornHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendMessageBullhornHandler.class);
    @Inject
    private ServerConfigurationService serverConfigurationService;
    @Inject
    private SiteService siteService;

    @Override
    public List<String> getHandledEvents() {
        return Arrays.asList("profile.message.sent");
    }

    @Override
    public Optional<List<BullhornData>> handleEvent(Event e, Cache<String, Map> countCache) {
        String from = e.getUserId();
        String ref = e.getResource();
        String[] pathParts = ref.split("/");
        String to = pathParts[2];
        String siteId = "~" + to;
        try {
            Site site = this.siteService.getSite(siteId);
            String toolId = site.getToolForCommonId("sakai.profile2").getId();
            String url = this.serverConfigurationService.getPortalUrl() + "/site/" + siteId + "/tool/" + toolId + "/messages";
            countCache.remove((Object)to);
            return Optional.of(Collections.singletonList(new BullhornData(from, to, siteId, "", url, true)));
        }
        catch (IdUnusedException idue) {
            log.error("No site for id: " + siteId);
            return Optional.empty();
        }
    }
}

