/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.beans.bullhornhandlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.hibernate.SessionFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.portal.api.BullhornData;
import org.sakaiproject.portal.beans.bullhornhandlers.AbstractBullhornHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class RemoveAssignmentBullhornHandler
extends AbstractBullhornHandler {
    private static final Logger log = LoggerFactory.getLogger(RemoveAssignmentBullhornHandler.class);
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalSessionFactory")
    private SessionFactory sessionFactory;
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalTransactionManager")
    private PlatformTransactionManager transactionManager;

    @Override
    public List<String> getHandledEvents() {
        return Arrays.asList("asn.delete.assignment");
    }

    @Override
    public Optional<List<BullhornData>> handleEvent(Event e, Cache<String, Long> countCache) {
        List users = new ArrayList();
        String from = e.getUserId();
        final String ref = e.getResource();
        String[] pathParts = ref.split("/");
        String assignmentId = pathParts[pathParts.length - 1];
        try {
            users = this.sessionFactory.getCurrentSession().createQuery("select toUser from BullhornAlert where event = :event and ref = :ref").setString("event", "asn.new.assignment").setString("ref", ref).list();
            users.addAll(this.sessionFactory.getCurrentSession().createQuery("select toUser from BullhornAlert where event = :event and ref like :ref").setString("event", "asn.grade.submission").setString("ref", ref.replace("/a/", "/s/") + "%").list());
            TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
            transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    RemoveAssignmentBullhornHandler.this.sessionFactory.getCurrentSession().createQuery("delete BullhornAlert where event = :event and ref = :ref").setString("event", "asn.new.assignment").setString("ref", ref).executeUpdate();
                }
            });
            transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    RemoveAssignmentBullhornHandler.this.sessionFactory.getCurrentSession().createQuery("delete BullhornAlert where event = :event and ref like :ref").setString("event", "asn.grade.submission").setString("ref", ref.replace("/a/", "/s/") + "%").executeUpdate();
                }
            });
        }
        catch (Exception e1) {
            log.error("Failed to delete bullhorn request event", (Throwable)e1);
        }
        users.forEach(arg_0 -> countCache.remove(arg_0));
        countCache.remove((Object)from);
        return Optional.empty();
    }
}

