/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.beans.bullhornhandlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.assignment.api.AssignmentService;
import org.sakaiproject.assignment.api.model.Assignment;
import org.sakaiproject.assignment.api.model.AssignmentSubmission;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.portal.api.BullhornData;
import org.sakaiproject.portal.beans.bullhornhandlers.AbstractBullhornHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GradeAssignmentBullhornHandler
extends AbstractBullhornHandler {
    private static final Logger log = LoggerFactory.getLogger(GradeAssignmentBullhornHandler.class);
    @Inject
    private AssignmentService assignmentService;

    @Override
    public List<String> getHandledEvents() {
        return Arrays.asList("asn.grade.submission");
    }

    @Override
    public Optional<List<BullhornData>> handleEvent(Event e, Cache<String, Long> countCache) {
        if (e.getLrsStatement() != null) {
            return Optional.empty();
        }
        String from = e.getUserId();
        String ref = e.getResource();
        String[] pathParts = ref.split("/");
        String siteId = pathParts[3];
        String submissionId = pathParts[pathParts.length - 1];
        try {
            AssignmentSubmission submission = this.assignmentService.getSubmission(submissionId);
            if (submission.getGradeReleased().booleanValue()) {
                Assignment assignment = submission.getAssignment();
                String title = assignment.getTitle();
                ArrayList bhEvents = new ArrayList();
                submission.getSubmitters().forEach(to -> {
                    try {
                        String url = this.assignmentService.getDeepLink(siteId, assignment.getId(), to.getSubmitter());
                        if (StringUtils.isNotBlank((CharSequence)url)) {
                            bhEvents.add(new BullhornData(from, to.getSubmitter(), siteId, title, url));
                        }
                        countCache.remove((Object)to.getSubmitter());
                    }
                    catch (Exception exc) {
                        log.error("Error retrieving deep link for assignment {} and user {} on site {}", new Object[]{assignment.getId(), to.getSubmitter(), siteId, exc});
                    }
                });
                return Optional.of(bhEvents);
            }
        }
        catch (Exception ex) {
            log.error("Failed to find either the submission or the site", (Throwable)ex);
        }
        return Optional.empty();
    }
}

