/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.beans.bullhornhandlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.portal.api.BullhornData;
import org.sakaiproject.portal.beans.bullhornhandlers.AbstractBullhornHandler;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfileLinkLogic;
import org.sakaiproject.user.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FriendStatusBullhornHandler
extends AbstractBullhornHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendStatusBullhornHandler.class);
    @Inject
    private ProfileConnectionsLogic profileConnectionsLogic;
    @Inject
    private ProfileLinkLogic profileLinkLogic;

    @Override
    public List<String> getHandledEvents() {
        return Arrays.asList("profile.status.update");
    }

    @Override
    public Optional<List<BullhornData>> handleEvent(Event e, Cache<String, Long> countCache) {
        String from = e.getUserId();
        String ref = e.getResource();
        String[] pathParts = ref.split("/");
        ArrayList<BullhornData> bhEvents = new ArrayList<BullhornData>();
        List connections = this.profileConnectionsLogic.getConnectedUsersForUserInsecurely(from);
        for (User connection : connections) {
            String to = connection.getId();
            String url = this.profileLinkLogic.getInternalDirectUrlToUserProfile(to, from);
            bhEvents.add(new BullhornData(from, to, "", "", url));
            countCache.remove((Object)to);
        }
        return Optional.of(bhEvents);
    }
}

