/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.beans.bullhornhandlers;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.hibernate.SessionFactory;
import org.sakaiproject.assignment.api.AssignmentService;
import org.sakaiproject.assignment.api.model.Assignment;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.portal.api.BullhornData;
import org.sakaiproject.portal.beans.bullhornhandlers.AbstractBullhornHandler;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class AddAssignmentBullhornHandler
extends AbstractBullhornHandler {
    private static final Logger log = LoggerFactory.getLogger(AddAssignmentBullhornHandler.class);
    @Inject
    private AssignmentService assignmentService;
    @Inject
    private AuthzGroupService authzGroupService;
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalTransactionManager")
    private PlatformTransactionManager transactionManager;
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalSessionFactory")
    private SessionFactory sessionFactory;
    @Inject
    private SiteService siteService;

    @Override
    public List<String> getHandledEvents() {
        return Arrays.asList("asn.new.assignment", "asn.revise.access");
    }

    @Override
    public Optional<List<BullhornData>> handleEvent(Event e, Cache<String, Long> countCache) {
        String from = e.getUserId();
        String ref = e.getResource();
        String[] pathParts = ref.split("/");
        String siteId = pathParts[3];
        String assignmentId = pathParts[pathParts.length - 1];
        try {
            Assignment assignment = this.assignmentService.getAssignment(assignmentId);
            switch (e.getEvent()) {
                case "asn.new.assignment": {
                    return this.bhAlreadyExists(ref) ? Optional.empty() : Optional.of(this.handleAdd(from, siteId, assignmentId, assignment, countCache));
                }
                case "asn.revise.access": {
                    return Optional.of(this.handleUpdateAccess(from, ref, siteId, assignmentId, assignment, countCache));
                }
            }
            return Optional.empty();
        }
        catch (Exception ex) {
            log.error("Failed to find either the assignment or the site", (Throwable)ex);
            return Optional.empty();
        }
    }

    private List<BullhornData> handleAdd(String from, String siteId, String assignmentId, Assignment assignment, Cache<String, Long> countCache) throws Exception {
        ArrayList<BullhornData> bhEvents = new ArrayList<BullhornData>();
        Instant openTime = assignment.getOpenDate();
        if (openTime == null || openTime.isBefore(Instant.now()) && !assignment.getDraft().booleanValue()) {
            Site site = this.siteService.getSite(siteId);
            String title = assignment.getTitle();
            Set groupIds = assignment.getGroups();
            Collection groupsUsers = this.authzGroupService.getAuthzUsersInGroups(groupIds);
            for (String to : site.getUsersIsAllowed("asn.read")) {
                if (groupIds.size() != 0 && !groupsUsers.contains(to) || from.equals(to) || this.securityService.isSuperUser(to)) continue;
                String url = this.assignmentService.getDeepLink(siteId, assignmentId, to);
                bhEvents.add(new BullhornData(from, to, siteId, title, url));
                countCache.remove((Object)to);
            }
        }
        return bhEvents;
    }

    private List<BullhornData> handleUpdateAccess(String from, String ref, String siteId, String assignmentId, Assignment assignment, Cache<String, Long> countCache) throws Exception {
        Site site = this.siteService.getSite(siteId);
        Set users = site.getUsersIsAllowed("asn.read");
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.execute(status -> {
            this.sessionFactory.getCurrentSession().createQuery("delete BullhornAlert where EVENT in :events and REF = :ref and TO_USER in :toUsers").setParameterList("events", (Object[])new String[]{"asn.new.assignment", "asn.revise.access"}).setString("ref", ref).setParameterList("toUsers", (Collection)users).executeUpdate();
            return null;
        });
        users.forEach(u -> countCache.remove(u));
        ArrayList<BullhornData> bhEvents = new ArrayList<BullhornData>();
        if (assignment.getTypeOfAccess() != Assignment.Access.GROUP) {
            String title = assignment.getTitle();
            for (String to : users) {
                if (from.equals(to) || this.securityService.isSuperUser(to)) continue;
                String url = this.assignmentService.getDeepLink(siteId, assignmentId, to);
                bhEvents.add(new BullhornData(from, to, siteId, title, url));
                countCache.remove((Object)to);
            }
        } else {
            Set groupIds = assignment.getGroups();
            Collection groupsUsers = this.authzGroupService.getAuthzUsersInGroups(groupIds);
            String title = assignment.getTitle();
            for (String to : groupsUsers) {
                if (from.equals(to) || this.securityService.isSuperUser(to)) continue;
                String url = this.assignmentService.getDeepLink(siteId, assignmentId, to);
                bhEvents.add(new BullhornData(from, to, siteId, title, url));
                countCache.remove((Object)to);
            }
            groupsUsers.forEach(u -> countCache.remove(u));
        }
        return bhEvents;
    }

    private boolean bhAlreadyExists(String ref) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        return (Boolean)transactionTemplate.execute(status -> {
            Long bhWithRef = (Long)this.sessionFactory.getCurrentSession().createQuery("select count(*) from BullhornAlert where ref = :ref and event = :event").setString("ref", ref).setString("event", "asn.revise.access").uniqueResult();
            return bhWithRef > 0L;
        });
    }
}

