/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.beans.bullhornhandlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.sakaiproject.commons.api.CommonsManager;
import org.sakaiproject.commons.api.datamodel.Comment;
import org.sakaiproject.commons.api.datamodel.Post;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.portal.api.BullhornData;
import org.sakaiproject.portal.beans.bullhornhandlers.AbstractBullhornHandler;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CommonsCommentBullhornHandler
extends AbstractBullhornHandler {
    private static final Logger log = LoggerFactory.getLogger(CommonsCommentBullhornHandler.class);
    @Inject
    private CommonsManager commonsManager;
    @Inject
    private ServerConfigurationService serverConfigurationService;
    @Inject
    private SiteService siteService;

    @Override
    public List<String> getHandledEvents() {
        return Arrays.asList("commons.comment.created");
    }

    @Override
    public Optional<List<BullhornData>> handleEvent(Event e, Cache<String, Long> countCache) {
        String commentCreator = e.getUserId();
        String ref = e.getResource();
        String siteId = e.getContext();
        String[] pathParts = ref.split("/");
        String postId = pathParts[4];
        Optional post = this.commonsManager.getPost(postId, true);
        if (post.isPresent()) {
            if ("SOCIAL".equals(siteId)) {
                return Optional.empty();
            }
            String postCreator = ((Post)post.get()).getCreatorId();
            String url = null;
            String siteTitle = null;
            try {
                Site site = this.siteService.getSite(siteId);
                siteTitle = site.getTitle();
                String toolId = site.getToolForCommonId("sakai.commons").getId();
                url = this.serverConfigurationService.getPortalUrl() + "/directtool/" + toolId + "/posts/" + postId;
            }
            catch (IdUnusedException ex) {
                log.error("Couldn't find site " + siteId, (Throwable)ex);
                return Optional.empty();
            }
            ArrayList<BullhornData> bhEvents = new ArrayList<BullhornData>();
            if (!commentCreator.equals(postCreator)) {
                bhEvents.add(new BullhornData(commentCreator, postCreator, siteId, siteTitle, url));
                countCache.remove((Object)postCreator);
            }
            ArrayList<String> sentAlready = new ArrayList<String>();
            for (Comment comment : ((Post)post.get()).getComments()) {
                String to = comment.getCreatorId();
                if (to.equals(postCreator) || to.equals(commentCreator) || sentAlready.contains(to)) continue;
                bhEvents.add(new BullhornData(commentCreator, to, siteId, siteTitle, url));
                countCache.remove((Object)to);
                sentAlready.add(to);
            }
            return Optional.of(bhEvents);
        }
        return Optional.empty();
    }
}

