/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.beans.bullhornhandlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.hibernate.SessionFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.portal.api.BullhornData;
import org.sakaiproject.portal.beans.bullhornhandlers.AbstractBullhornHandler;
import org.sakaiproject.profile2.logic.ProfileLinkLogic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class FriendConfirmBullhornHandler
extends AbstractBullhornHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendConfirmBullhornHandler.class);
    @Inject
    private ProfileLinkLogic profileLinkLogic;
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalSessionFactory")
    private SessionFactory sessionFactory;
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalTransactionManager")
    private PlatformTransactionManager transactionManager;

    @Override
    public List<String> getHandledEvents() {
        return Arrays.asList("profile.friend.confirm");
    }

    @Override
    public Optional<List<BullhornData>> handleEvent(Event e, Cache<String, Long> countCache) {
        String from = e.getUserId();
        String ref = e.getResource();
        String[] pathParts = ref.split("/");
        String to = pathParts[2];
        try {
            TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
            transactionTemplate.execute(status -> {
                this.sessionFactory.getCurrentSession().createQuery("delete BullhornAlert where event = :event and fromUser = :fromUser").setString("event", "profile.friend.request").setString("fromUser", to).executeUpdate();
                return null;
            });
        }
        catch (Exception e1) {
            log.error("Failed to delete bullhorn request event", (Throwable)e1);
        }
        String url = this.profileLinkLogic.getInternalDirectUrlToUserConnections(to);
        countCache.remove((Object)to);
        countCache.remove((Object)from);
        return Optional.of(Collections.singletonList(new BullhornData(from, to, "", "", url)));
    }
}

