/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.api.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="PINNED_SITES", uniqueConstraints={@UniqueConstraint(name="UniquePinning", columnNames={"USER_ID", "SITE_ID"})}, indexes={@Index(name="pinned_sites_user_idx", columnList="USER_ID"), @Index(name="pinned_sites_site_idx", columnList="SITE_ID")})
public class PinnedSite
implements PersistableEntity<Long> {
    public static final int UNPINNED_POSITION = -1;
    @Id
    @GeneratedValue
    @Column(name="ID")
    private Long id;
    @Column(name="USER_ID", length=99, nullable=false)
    private String userId;
    @Column(name="SITE_ID", length=99, nullable=false)
    private String siteId;
    @Column(name="POSITION", nullable=false)
    private int position;
    @Column(name="HAS_BEEN_UNPINNED", nullable=false)
    private Boolean hasBeenUnpinned = false;

    public PinnedSite() {
    }

    public PinnedSite(String userId, String siteId) {
        this.userId = userId;
        this.siteId = siteId;
    }

    public Long getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public int getPosition() {
        return this.position;
    }

    public Boolean getHasBeenUnpinned() {
        return this.hasBeenUnpinned;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setHasBeenUnpinned(Boolean hasBeenUnpinned) {
        this.hasBeenUnpinned = hasBeenUnpinned;
    }
}

