/*
 * Copyright (c) 2003-2021 The Apereo Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *             http://opensource.org/licenses/ecl2
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sakaiproject.portal.api.repository;

import java.util.List;
import java.util.Optional;

import org.sakaiproject.portal.api.model.PinnedSite;
import org.sakaiproject.springframework.data.SpringCrudRepository;

public interface PinnedSiteRepository extends SpringCrudRepository<PinnedSite, Long> {

    List<PinnedSite> findByUserIdOrderByPosition(String userId);
    List<PinnedSite> findByUserIdAndHasBeenUnpinnedOrderByPosition(String userId, boolean hasBeenUnpinned);
    Optional<PinnedSite> findByUserIdAndSiteId(String userId, String siteId);
    List<PinnedSite> findBySiteId(String siteId);
    Integer deleteByUserId(String userId);
    Integer deleteBySiteId(String siteId);
    Integer deleteByUserIdAndSiteId(String userId, String siteId);
    Integer deleteByUserIdAndSiteIds(String userId, List<String> siteIds);
}
