/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.charon.velocity;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.portal.api.PortalRenderContext;
import org.sakaiproject.portal.api.PortalRenderEngine;
import org.sakaiproject.portal.api.PortalService;
import org.sakaiproject.portal.api.StyleAbleProvider;
import org.sakaiproject.portal.charon.velocity.VelocityPortalRenderContext;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.SessionManager;

public class VelocityPortalRenderEngine
implements PortalRenderEngine {
    private static final Log log = LogFactory.getLog(VelocityPortalRenderEngine.class);
    private VelocityEngine vengine;
    private boolean debug = false;
    private List<Map<String, String>> availablePortalSkins;
    private ServletContext context;
    private String defaultSkin = "neoskin";
    private boolean styleAble = false;
    private boolean styleAbleContentSummary = false;
    private PortalService portalService;
    private ServerConfigurationService serverConfigurationService;
    private SessionManager sessionManager;
    private String portalConfig = "portalvelocity.config";

    public void init() throws Exception {
        if (log.isTraceEnabled()) {
            this.debug = true;
        }
        try {
            this.styleAble = this.serverConfigurationService.getBoolean("portal.styleable", false);
            this.styleAbleContentSummary = this.serverConfigurationService.getBoolean("portal.styleable.contentSummary", false);
            this.defaultSkin = this.serverConfigurationService.getString("portal.templates", "neoskin");
        }
        catch (Exception ex) {
            log.warn((Object)"No Server configuration service available, assuming default settings ");
        }
        if (this.sessionManager == null) {
            log.warn((Object)"No session Manager, assuming test mode ");
        }
        this.vengine = new VelocityEngine();
        this.vengine.setApplicationAttribute((Object)ServletContext.class.getName(), (Object)this.context);
        this.vengine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
        this.vengine.setProperty("runtime.log.logsystem.log4j.category", (Object)"ve.portal");
        Properties p = new Properties();
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(this.portalConfig);
            if (in == null) {
                throw new RuntimeException("Unable to load configuration " + this.portalConfig);
            }
            log.info((Object)("Loaded " + this.portalConfig));
            p.load(in);
            this.vengine.init(p);
            this.availablePortalSkins = new ArrayList<Map<String, String>>();
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("name", this.defaultSkin);
            m.put("display", "Default");
            this.availablePortalSkins.add(m);
            this.vengine.getTemplate("/vm/" + this.defaultSkin + "/macros.vm");
        }
        catch (IOException e) {
            throw new RuntimeException("Exception encounterd:  " + e, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortalRenderContext newRenderContext(HttpServletRequest request) {
        VelocityPortalRenderContext rc = new VelocityPortalRenderContext();
        rc.setRenderEngine(this);
        rc.setDebug(this.debug);
        rc.put("pageSkins", this.availablePortalSkins);
        rc.put("styleableStyleSheet", this.generateStyleAbleStyleSheet());
        rc.put("styleableJS", this.generateStyleAbleJavaScript());
        rc.put("styleable", this.styleAble);
        String portalSkin = this.defaultSkin;
        if (request != null) {
            HttpSession session = request.getSession();
            portalSkin = (String)session.getAttribute("portalskin");
            String newPortalSkin = request.getParameter("portalskin");
            if (newPortalSkin != null && newPortalSkin.length() > 0) {
                session.setAttribute("portalskin", (Object)newPortalSkin);
                portalSkin = newPortalSkin;
                log.debug((Object)("Set Skin To " + portalSkin));
            } else if (portalSkin == null || portalSkin.length() == 0) {
                portalSkin = this.defaultSkin;
                session.setAttribute("portalskin", (Object)portalSkin);
            }
            rc.put("pageCurrentSkin", portalSkin);
            log.debug((Object)("Current Skin is " + portalSkin));
        } else {
            log.debug((Object)"No Request Object Skin is default");
            rc.put("pageCurrentSkin", this.defaultSkin);
        }
        InputStream stream = null;
        try {
            Properties p = new Properties();
            stream = this.getClass().getResourceAsStream("/" + portalSkin + "/options.config");
            p.load(stream);
            rc.setOptions(p);
        }
        catch (Exception ex) {
            log.info((Object)"No options loaded ", (Throwable)ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rc;
    }

    public void render(String template, PortalRenderContext rcontext, Writer out) throws Exception {
        Context vc;
        String skin;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Portal trace is on, dumping PortalRenderContext to log:\n" + rcontext.dump()));
        }
        if ((skin = (String)(vc = ((VelocityPortalRenderContext)rcontext).getVelocityContext()).get("pageCurrentSkin")) == null || skin.length() == 0) {
            skin = this.defaultSkin;
        }
        if (!this.defaultSkin.equals(skin)) {
            this.vengine.getTemplate("/vm/" + skin + "/macros.vm");
        }
        this.vengine.mergeTemplate("/vm/" + skin + "/" + template + ".vm", ((VelocityPortalRenderContext)rcontext).getVelocityContext(), out);
    }

    private String generateStyleAbleStyleSheet() {
        StyleAbleProvider sp;
        if (this.styleAble && (sp = this.portalService.getStylableService()) != null) {
            String userId = this.getCurrentUserId();
            try {
                return sp.generateStyleSheet(userId);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private String generateStyleAbleJavaScript() {
        StyleAbleProvider sp;
        if (this.styleAble && this.styleAbleContentSummary && (sp = this.portalService.getStylableService()) != null) {
            String userId = this.getCurrentUserId();
            try {
                return sp.generateJavaScript(userId);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private String getCurrentUserId() {
        if (this.sessionManager == null) {
            return "test-mode-user";
        }
        return this.sessionManager.getCurrentSession().getUserId();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public void setContext(ServletContext context) {
        this.context = context;
    }

    public void setupForward(HttpServletRequest req, HttpServletResponse res, Placement p, String skin) {
        String headJs = (String)req.getAttribute("sakai.html.head.js");
        String headCssToolBase = (String)req.getAttribute("sakai.html.head.css.base");
        String headCssToolSkin = (String)req.getAttribute("sakai.html.head.css.skin");
        String bodyonload = (String)req.getAttribute("sakai.html.body.onload");
        String customUserCss = this.generateStyleAbleStyleSheet();
        customUserCss = customUserCss != null ? "<style type=\"text/css\" title=\"StyleAble\">\n" + customUserCss + "</style>\n" : "";
        String styleAbleJs = this.generateStyleAbleJavaScript();
        if (styleAbleJs != null) {
            styleAbleJs = "<script type=\"text/javascript\" language=\"JavaScript\">\n" + styleAbleJs + "\n</script>\n";
            headJs = headJs + styleAbleJs;
            bodyonload = bodyonload + "styleableonload();";
        }
        headCssToolSkin = headCssToolSkin + customUserCss;
        String headCss = headCssToolBase + headCssToolSkin + customUserCss;
        String head = headCss + headJs;
        req.setAttribute("sakai.html.head", (Object)head);
        req.setAttribute("sakai.html.head.css", (Object)headCss);
        req.setAttribute("sakai.html.head.js", (Object)headJs);
        req.setAttribute("sakai.html.head.css.base", (Object)headCssToolBase);
        req.setAttribute("sakai.html.head.css.skin", (Object)headCssToolSkin);
        req.setAttribute("sakai.html.body.onload", (Object)bodyonload);
    }

    public boolean isStyleAble() {
        return this.styleAble;
    }

    public void setStyleAble(boolean styleAble) {
        this.styleAble = styleAble;
    }

    public void setPortalService(PortalService instance) {
        this.portalService = instance;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public String getPortalConfig() {
        return this.portalConfig;
    }

    public void setPortalConfig(String portalConfig) {
        this.portalConfig = portalConfig;
    }
}

