/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.charon.velocity;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.webapp.api.WebappResourceManager;

public class LibraryWebappLoader
extends ResourceLoader {
    private static final long CACHE_EXPIRATION_IN_MILLIS = 60000L;
    private WebappResourceManager libraryWebappResourceManager;
    protected HashMap templatePaths = null;

    public void init(ExtendedProperties configuration) {
        this.rsvc.debug((Object)"WebappLoader : initialization starting.");
        this.getLibraryWebappResourceManager();
        this.templatePaths = new HashMap();
        this.rsvc.debug((Object)"WebappLoader : initialization complete.");
    }

    public synchronized InputStream getResourceStream(String name) throws ResourceNotFoundException {
        Exception exception;
        InputStream result;
        block6: {
            result = null;
            if (name == null || name.length() == 0) {
                throw new ResourceNotFoundException("WebappLoader : No template name provided");
            }
            while (!name.startsWith("/")) {
                name = "/" + name;
            }
            String adjustedName = this.adjustName(name);
            exception = null;
            try {
                result = this.getLibraryWebappResourceManager().getResourceAsStream(adjustedName);
                if (result != null) {
                    this.templatePaths.put(name, new Date());
                }
            }
            catch (Exception e) {
                if (exception != null) break block6;
                exception = e;
            }
        }
        if (result == null) {
            String msg = exception == null ? "WebappLoader : Resource '" + name + "' not found." : exception.getMessage();
            throw new ResourceNotFoundException(msg);
        }
        return result;
    }

    private Date getCachedFileLastLoaded(String fileName) {
        return (Date)this.templatePaths.get(fileName);
    }

    public boolean isSourceModified(Resource resource) {
        String fileName = resource.getName();
        Date fileLastLoaded = this.getCachedFileLastLoaded(fileName);
        if (fileLastLoaded == null) {
            return true;
        }
        return new Date().getTime() - fileLastLoaded.getTime() > 60000L;
    }

    public long getLastModified(Resource resource) {
        String fileName = resource.getName();
        Date fileLastLoaded = this.getCachedFileLastLoaded(fileName);
        if (fileLastLoaded == null) {
            return 0L;
        }
        return fileLastLoaded.getTime();
    }

    public WebappResourceManager getLibraryWebappResourceManager() {
        if (this.libraryWebappResourceManager == null) {
            this.libraryWebappResourceManager = (WebappResourceManager)ComponentManager.get((String)"org.sakaiproject.webapp.api.WebappResourceManager.library");
        }
        return this.libraryWebappResourceManager;
    }

    public String adjustName(String name) {
        String[] parts = name.split("/");
        return "/skin/" + this.getSkin() + "/" + parts[parts.length - 1];
    }

    protected String getSkin() {
        String skin = ServerConfigurationService.getString((String)"skin.default");
        return skin;
    }
}

