/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.charon.velocity;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.portal.api.PortalRenderEngine;
import org.sakaiproject.portal.api.cover.PortalService;
import org.sakaiproject.portal.charon.velocity.VelocityPortalRenderEngine;
import org.sakaiproject.tool.cover.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalRenderEngineContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(PortalRenderEngineContextListener.class);
    private VelocityPortalRenderEngine vengine;

    public void contextDestroyed(ServletContextEvent arg0) {
        PortalService.getInstance().removeRenderEngine("charon", (PortalRenderEngine)this.vengine);
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.vengine = new VelocityPortalRenderEngine();
            this.vengine.setContext(event.getServletContext());
            this.vengine.setServerConfigurationService(ServerConfigurationService.getInstance());
            this.vengine.setSessionManager(SessionManager.getInstance());
            this.vengine.init();
            this.vengine.setPortalService(PortalService.getInstance());
            PortalService.getInstance().addRenderEngine("charon", (PortalRenderEngine)this.vengine);
        }
        catch (Exception ex) {
            log.error("Failed to register render engine with the portal service, this is probably fatal ", (Throwable)ex);
        }
    }
}

