/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.charon.velocity;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.sakaiproject.portal.api.PortalRenderContext;
import org.sakaiproject.portal.api.PortalRenderEngine;

public class VelocityPortalRenderContext
implements PortalRenderContext {
    private static final Log log = LogFactory.getLog(VelocityPortalRenderContext.class);
    private Context vcontext = new VelocityContext();
    private boolean debug = false;
    private Map options = null;
    private PortalRenderEngine renderEngine = null;

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void put(String key, Object value) {
        this.vcontext.put(key, value);
    }

    public Context getVelocityContext() {
        return this.vcontext;
    }

    public String dump() {
        if (this.debug) {
            Object[] keys = this.vcontext.getKeys();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < keys.length; ++i) {
                Object o = this.vcontext.get((String)keys[i]);
                this.dumpObject(sb, keys[i], o);
            }
            return sb.toString();
        }
        return "";
    }

    private void dumpObject(StringBuilder sb, Object key, Object o) {
        if (o instanceof Map) {
            sb.append("Property ").append(key).append(":").append(o).append("\n");
            this.dumpMap(sb, key, (Map)o);
        } else if (o instanceof Collection) {
            sb.append("Property ").append(key).append(":").append(o).append("\n");
            this.dumpCollection(sb, key, (Collection)o);
        } else {
            sb.append("Property ").append(key).append(":").append(o).append("\n");
        }
    }

    private void dumpCollection(StringBuilder sb, Object key, Collection collection) {
        int n = 0;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            String keyn = key.toString() + "." + String.valueOf(n);
            this.dumpObject(sb, keyn, i.next());
            ++n;
        }
    }

    private void dumpMap(StringBuilder sb, Object key, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            Object keyn = entry.getKey();
            this.dumpObject(sb, key + "." + keyn, entry.getValue());
        }
    }

    public boolean uses(String includeOption) {
        if (this.options == null || includeOption == null) {
            return true;
        }
        return "true".equals(this.options.get(includeOption));
    }

    public Map getOptions() {
        return this.options;
    }

    public void setOptions(Map options) {
        this.options = options;
    }

    public PortalRenderEngine getRenderEngine() {
        return this.renderEngine;
    }

    public void setRenderEngine(PortalRenderEngine renderEngine) {
        this.renderEngine = renderEngine;
    }
}

