/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.iframe;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.portal.api.Portal;
import org.sakaiproject.portal.api.PortalService;
import org.sakaiproject.portal.api.StoredState;
import org.sakaiproject.portal.render.api.RenderResult;
import org.sakaiproject.portal.render.api.ToolRenderException;
import org.sakaiproject.portal.render.api.ToolRenderService;
import org.sakaiproject.portal.util.ByteArrayServletResponse;
import org.sakaiproject.portal.util.URLUtils;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.ActiveTool;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.ActiveToolManager;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.Web;

public class IFrameToolRenderService
implements ToolRenderService {
    private static final Log LOG = LogFactory.getLog(IFrameToolRenderService.class);
    private PortalService portalService;

    public boolean preprocess(Portal portal, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException, ToolRenderException {
        return true;
    }

    public RenderResult render(Portal portal, ToolConfiguration configuration, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException, ToolRenderException {
        String sakaiPanel;
        final String titleString = Web.escapeHtml((String)configuration.getTitle());
        String toolUrl = ServerConfigurationService.getToolUrl() + "/" + Web.escapeUrl((String)configuration.getId());
        StoredState ss = this.portalService.getStoredState();
        LOG.debug((Object)("Restoring Iframe [" + ss + "]"));
        Map parametermap = ss == null ? request.getParameterMap() : ss.getRequest(request).getParameterMap();
        String URLstub = this.portalService.decodeToolState(parametermap, configuration.getId());
        if (URLstub != null) {
            toolUrl = toolUrl + URLstub;
        }
        if ((sakaiPanel = request.getParameter("panel")) != null && sakaiPanel.matches(".*[\"'<>].*")) {
            sakaiPanel = null;
        }
        if (sakaiPanel == null) {
            sakaiPanel = "Main";
        }
        toolUrl = URLUtils.addParameter((String)toolUrl, (String)"panel", (String)sakaiPanel);
        final StringBuilder sb = new StringBuilder();
        toolUrl = toolUrl.replace("&", "&amp;");
        String sakaiAction = request.getParameter("sakai_action");
        if (sakaiAction != null && sakaiAction.matches(".*[\"'<>].*")) {
            sakaiAction = null;
        }
        sb.append("<iframe").append("\tname=\"").append(Web.escapeJavascript((String)("Main" + configuration.getId()))).append("\"\n").append("\tid=\"").append(Web.escapeJavascript((String)("Main" + configuration.getId()))).append("\"\n\ttitle=\"").append(titleString).append(" ").append("\"").append("\n").append("\tclass =\"portletMainIframe\"").append("\n").append("\theight=\"475\"").append("\n").append("\twidth=\"100%\"").append("\n").append("\tframeborder=\"0\"").append("\n").append("\tmarginwidth=\"0\"").append("\n").append("\tmarginheight=\"0\"").append("\n").append("\tscrolling=\"auto\"").append("\n").append("\tsrc=\"").append(toolUrl);
        if (sakaiAction != null) {
            sb.append(toolUrl.indexOf(63) >= 0 ? (char)'&' : '?');
            sb.append("sakai_action=").append(Web.escapeHtml((String)sakaiAction));
        }
        sb.append("\">").append("\n").append("</iframe>");
        final String[] buffered = this.bufferContent(portal, request, response, configuration);
        RenderResult result = new RenderResult(){

            public String getHead() {
                if (buffered != null) {
                    return buffered[0];
                }
                return "";
            }

            public String getTitle() {
                return titleString;
            }

            public String getContent() {
                if (buffered != null) {
                    return buffered[1];
                }
                return sb.toString();
            }

            public void setContent(String content) {
            }

            public String getJSR168EditUrl() {
                return null;
            }

            public String getJSR168HelpUrl() {
                return null;
            }
        };
        return result;
    }

    public boolean accept(Portal portal, ToolConfiguration configuration, HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        return true;
    }

    public void reset(ToolConfiguration configuration) {
    }

    public PortalService getPortalService() {
        return this.portalService;
    }

    public void setPortalService(PortalService portalService) {
        this.portalService = portalService;
    }

    public String[] bufferContent(Portal portal, HttpServletRequest req, HttpServletResponse res, ToolConfiguration toolConfig) {
        if (toolConfig == null) {
            return null;
        }
        if (toolConfig.getId() == null) {
            return null;
        }
        String tidAllow = ServerConfigurationService.getString((String)"portal.experimental.iframesuppress");
        if (tidAllow == null) {
            return null;
        }
        if (tidAllow.indexOf(":all:") < 0 && tidAllow.indexOf(toolConfig.getToolId()) < 0) {
            return null;
        }
        ByteArrayServletResponse bufferedResponse = new ByteArrayServletResponse(res);
        try {
            boolean retval = this.doToolBuffer(portal, req, (HttpServletResponse)bufferedResponse, toolConfig);
            if (!retval) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        String responseStr = bufferedResponse.getInternalBuffer();
        if (responseStr == null || responseStr.length() < 1) {
            return null;
        }
        String responseStrLower = responseStr.toLowerCase();
        int headStart = responseStrLower.indexOf("<head");
        headStart = this.findEndOfTag(responseStrLower, headStart);
        int headEnd = responseStrLower.indexOf("</head");
        int bodyStart = responseStrLower.indexOf("<body");
        bodyStart = this.findEndOfTag(responseStrLower, bodyStart);
        int bodyEnd = responseStrLower.lastIndexOf("</body");
        if (bodyEnd < bodyStart) {
            bodyEnd = responseStrLower.length() - 1;
        }
        if (tidAllow.indexOf(":debug:") >= 0) {
            LOG.info((Object)("Frameless HS=" + headStart + " HE=" + headEnd + " BS=" + bodyStart + " BE=" + bodyEnd));
        }
        if (bodyEnd > bodyStart && bodyStart > headEnd && headEnd > headStart && headStart > 1) {
            String headString = responseStr.substring(headStart + 1, headEnd);
            String bodyString = responseStr.substring(bodyStart + 1, bodyEnd);
            if (tidAllow.indexOf(":debug:") >= 0) {
                System.out.println(" ---- Head --- ");
                System.out.println(headString);
                System.out.println(" ---- Body --- ");
                System.out.println(bodyString);
            }
            String[] s = new String[]{headString, bodyString};
            return s;
        }
        return null;
    }

    private int findEndOfTag(String string, int startPos) {
        if (startPos < 1) {
            return -1;
        }
        for (int i = startPos; i < string.length(); ++i) {
            if (string.charAt(i) != '>') continue;
            return i;
        }
        return -1;
    }

    private boolean doToolBuffer(Portal portal, HttpServletRequest req, HttpServletResponse res, ToolConfiguration toolConfig) throws ToolException, IOException {
        ActiveTool tool;
        Session s = SessionManager.getCurrentSession();
        ToolSession ts = s.getToolSession(toolConfig.getId());
        if (this.portalService.isResetRequested(req)) {
            ts.clearAttributes();
        }
        if ((tool = ActiveToolManager.getActiveTool((String)toolConfig.getToolId())) == null) {
            return false;
        }
        if (tool.getAccessSecurity() == Tool.AccessSecurity.PORTAL) {
            Site site = null;
            try {
                site = SiteService.getSiteVisit((String)toolConfig.getSiteId());
            }
            catch (IdUnusedException e) {
                portal.doError(req, res, s, 2);
                return false;
            }
            catch (PermissionException e) {
                return false;
            }
        }
        String option = URLUtils.getSafePathInfo((HttpServletRequest)req);
        String[] parts = option.split("/");
        String toolContextPath = req.getContextPath() + req.getServletPath() + Web.makePath((String[])parts, (int)1, (int)3);
        String toolPathInfo = Web.makePath((String[])parts, (int)3, (int)parts.length);
        portal.forwardTool(tool, req, res, (Placement)toolConfig, toolConfig.getSkin(), toolContextPath, toolPathInfo);
        return true;
    }
}

