/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.portal.render.portlet.services.state;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.sakaiproject.portal.render.portlet.services.state.PortletState;
import org.sakaiproject.tool.cover.SessionManager;

public class PortletStateAccess {
    private static final String PORTLET_STATE_PARAM = "org.sakaiproject.portal.pluto.PORTLET_STATE";

    public static PortletState getPortletState(HttpServletRequest request, String windowId) {
        HttpSession session = (HttpSession)SessionManager.getCurrentSession();
        PortletStateContainer theContainer = PortletStateAccess.getContainer(session);
        PortletState theState = theContainer.get(windowId);
        if (theState == null) {
            theState = new PortletState(windowId);
            theContainer.add(theState);
        }
        return theState;
    }

    public static void setPortletState(HttpServletRequest request, PortletState state) {
        HttpSession session = (HttpSession)SessionManager.getCurrentSession();
        PortletStateAccess.getContainer(session).add(state);
    }

    private static PortletStateContainer getContainer(HttpSession session) {
        PortletStateContainer container = (PortletStateContainer)session.getAttribute(PORTLET_STATE_PARAM);
        if (container == null) {
            container = new PortletStateContainer();
            session.setAttribute(PORTLET_STATE_PARAM, (Object)container);
        }
        return container;
    }

    static class PortletStateContainer {
        private Map stateMap = new HashMap();

        PortletStateContainer() {
        }

        public void add(PortletState state) {
            this.stateMap.put(state.getId(), state);
        }

        public PortletState get(String windowId) {
            return (PortletState)this.stateMap.get(windowId);
        }
    }
}

